/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal.dynamic;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.ModularExplosionProvider;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalRecipeInput;
import de.dafuqs.spectrum.explosion.ExplosionArchetype;
import de.dafuqs.spectrum.explosion.ExplosionModifier;
import de.dafuqs.spectrum.explosion.ExplosionModifierProviders;
import de.dafuqs.spectrum.explosion.ModularExplosionDefinition;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.ShapelessPedestalRecipe;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ExplosionModificationRecipe
extends ShapelessPedestalRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/blocks/modular_explosives");

    public ExplosionModificationRecipe() {
        super("", false, Optional.of(UNLOCK_IDENTIFIER), PedestalRecipeTier.BASIC, ExplosionModificationRecipe.collectIngredients(), Map.of(), class_1799.field_8037, 0.0f, 40, false, true);
    }

    private static List<IngredientStack> collectIngredients() {
        ArrayList providers = new ArrayList();
        class_7923.field_41178.method_10220().filter(item -> item instanceof ModularExplosionProvider).forEach(providers::add);
        IngredientStack providerIngredient = IngredientStack.of(class_1856.method_8091((class_1935[])providers.toArray(new class_1935[0])));
        Set<class_1792> modifiers = ExplosionModifierProviders.getProviders();
        IngredientStack modifierIngredient = IngredientStack.of(class_1856.method_8091((class_1935[])modifiers.toArray(new class_1935[0])));
        return List.of(providerIngredient, modifierIngredient);
    }

    @Override
    public boolean matches(PedestalRecipeInput inventory, class_1937 world) {
        class_1799 nonModStack = this.validateGridAndFindModularExplosiveStack(inventory);
        class_1792 class_17922 = nonModStack.method_7909();
        if (!(class_17922 instanceof ModularExplosionProvider)) {
            return false;
        }
        ModularExplosionProvider modularExplosionProvider = (ModularExplosionProvider)class_17922;
        Pair<List<ExplosionArchetype>, List<ExplosionModifier>> pair = this.findArchetypeAndModifiers(inventory);
        ModularExplosionDefinition currentSet = ModularExplosionDefinition.cloneFromStack(nonModStack);
        List archetypes = (List)pair.getFirst();
        List mods = (List)pair.getSecond();
        if (archetypes.isEmpty() && mods.isEmpty()) {
            return currentSet.getArchetype() != ExplosionArchetype.COSMETIC || currentSet.getModifierCount() > 0;
        }
        if (!archetypes.isEmpty()) {
            @Nullable ExplosionArchetype newArchetype = ExplosionModificationRecipe.calculateExplosionArchetype(currentSet.getArchetype(), archetypes);
            if (newArchetype == null) {
                return false;
            }
            currentSet.setArchetype(newArchetype);
        }
        currentSet.addModifiers(mods);
        return currentSet.isValid(modularExplosionProvider);
    }

    @Nullable
    private static ExplosionArchetype calculateExplosionArchetype(ExplosionArchetype existingArchetype, List<ExplosionArchetype> newArchetypes) {
        ExplosionArchetype newArchetype = existingArchetype;
        int newArchetypesCount = newArchetypes.size();
        if (existingArchetype == ExplosionArchetype.ALL && newArchetypesCount > 0) {
            return null;
        }
        if (newArchetypes.contains((Object)ExplosionArchetype.ALL) && newArchetypesCount > 1) {
            return null;
        }
        for (ExplosionArchetype archetype : newArchetypes) {
            if (newArchetype == ExplosionArchetype.ALL) {
                return null;
            }
            newArchetype = ExplosionArchetype.get(newArchetype.affectsBlocks || archetype.affectsBlocks, newArchetype.affectsEntities || archetype.affectsEntities);
        }
        return newArchetype;
    }

    @Override
    public class_1799 assemble(PedestalRecipeInput input, class_7225.class_7874 drm) {
        ExplosionArchetype newArchetype;
        class_1799 output = this.validateGridAndFindModularExplosiveStack(input).method_7972();
        Pair<List<ExplosionArchetype>, List<ExplosionModifier>> pair = this.findArchetypeAndModifiers(input);
        List archetypes = (List)pair.getFirst();
        List mods = (List)pair.getSecond();
        if (archetypes.isEmpty() && mods.isEmpty()) {
            ModularExplosionDefinition.removeFromStack(output);
            return output;
        }
        ModularExplosionDefinition set = ModularExplosionDefinition.cloneFromStack(output);
        if (!archetypes.isEmpty() && (newArchetype = ExplosionModificationRecipe.calculateExplosionArchetype(set.getArchetype(), (List)pair.getFirst())) != null) {
            set.setArchetype(newArchetype);
        }
        set.addModifiers(mods);
        set.attachToStack(output);
        return output;
    }

    @Override
    public void consumeIngredients(PedestalBlockEntity pedestal) {
        for (int slot : CRAFTING_GRID_SLOTS) {
            class_1799 slotStack = pedestal.method_5438(slot);
            if (slotStack.method_7909() instanceof ModularExplosionProvider) {
                pedestal.method_5447(slot, class_1799.field_8037);
                continue;
            }
            slotStack.method_7934(1);
        }
    }

    public class_1799 validateGridAndFindModularExplosiveStack(PedestalRecipeInput recipeInput) {
        class_1799 foundStack = class_1799.field_8037;
        for (int slot : recipeInput.getCraftingGridSlots()) {
            class_1799 stack = recipeInput.method_59984(slot);
            if (stack.method_7960() || !(stack.method_7909() instanceof ModularExplosionProvider) || ExplosionModifierProviders.getModifier(stack) != null || ExplosionModifierProviders.getArchetype(stack) != null) continue;
            if (foundStack == class_1799.field_8037) {
                foundStack = stack;
                continue;
            }
            return class_1799.field_8037;
        }
        return foundStack;
    }

    public Pair<List<ExplosionArchetype>, List<ExplosionModifier>> findArchetypeAndModifiers(PedestalRecipeInput recipeInput) {
        ArrayList<ExplosionModifier> modifiers = new ArrayList<ExplosionModifier>();
        ArrayList<ExplosionArchetype> archetypes = new ArrayList<ExplosionArchetype>();
        for (int slot : recipeInput.getCraftingGridSlots()) {
            class_1799 stack = recipeInput.method_59984(slot);
            if (stack.method_7960()) continue;
            ExplosionModifier modifier = ExplosionModifierProviders.getModifier(stack);
            if (modifier != null) {
                modifiers.add(modifier);
                continue;
            }
            ExplosionArchetype archetype = ExplosionModifierProviders.getArchetype(stack);
            if (archetype == null) continue;
            archetypes.add(archetype);
        }
        return new Pair(archetypes, modifiers);
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.MODULAR_EXPLOSIVE_MODIFICATION;
    }
}

