/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.item.InkPoweredPotionFillable;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionRecipeEffect(boolean applicableToPotions, boolean applicableToTippedArrows, boolean applicableToPotionFillabes, boolean applicableToWeapons, int baseDurationTicks, float baseYield, int potencyHardCap, float potencyModifier, class_6880<class_1291> statusEffect, InkColor inkColor, int inkCost) {
    public static MapCodec<PotionRecipeEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("applicable_to_potions", (Object)true).forGetter(PotionRecipeEffect::applicableToPotions), (App)Codec.BOOL.optionalFieldOf("applicable_to_tipped_arrows", (Object)true).forGetter(PotionRecipeEffect::applicableToTippedArrows), (App)Codec.BOOL.optionalFieldOf("applicable_to_potion_fillabes", (Object)true).forGetter(PotionRecipeEffect::applicableToPotionFillabes), (App)Codec.BOOL.optionalFieldOf("applicable_to_weapons", (Object)true).forGetter(PotionRecipeEffect::applicableToWeapons), (App)Codec.INT.optionalFieldOf("base_duration_ticks", (Object)1600).forGetter(PotionRecipeEffect::baseDurationTicks), (App)Codec.FLOAT.optionalFieldOf("base_yield", (Object)Float.valueOf(3.0f)).forGetter(PotionRecipeEffect::baseYield), (App)Codec.INT.optionalFieldOf("potency_hard_cap", (Object)-1).forGetter(PotionRecipeEffect::potencyHardCap), (App)Codec.FLOAT.optionalFieldOf("potency_modifier", (Object)Float.valueOf(1.0f)).forGetter(PotionRecipeEffect::potencyModifier), (App)class_7923.field_41174.method_40294().fieldOf("effect").forGetter(PotionRecipeEffect::statusEffect), (App)InkColor.CODEC.fieldOf("ink_color").forGetter(PotionRecipeEffect::inkColor), (App)Codec.INT.fieldOf("ink_cost").forGetter(PotionRecipeEffect::inkCost)).apply((Applicative)i, PotionRecipeEffect::new));
    public static class_9139<class_9129, PotionRecipeEffect> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48547, PotionRecipeEffect::applicableToPotions, class_9135.field_48547, PotionRecipeEffect::applicableToTippedArrows, class_9135.field_48547, PotionRecipeEffect::applicableToPotionFillabes, class_9135.field_48547, PotionRecipeEffect::applicableToWeapons, class_9135.field_48550, PotionRecipeEffect::baseDurationTicks, class_9135.field_48552, PotionRecipeEffect::baseYield, class_9135.field_48550, PotionRecipeEffect::potencyHardCap, class_9135.field_48552, PotionRecipeEffect::potencyModifier, class_9135.method_56383((class_5321)class_7924.field_41208), PotionRecipeEffect::statusEffect, InkColor.PACKET_CODEC, PotionRecipeEffect::inkColor, class_9135.field_48550, PotionRecipeEffect::inkCost, PotionRecipeEffect::new);

    public static PotionRecipeEffect read(JsonObject jsonObject) {
        return (PotionRecipeEffect)CodecHelper.fromJson(CODEC.codec(), (JsonElement)jsonObject).orElseThrow();
    }

    public void write(class_9129 buf) {
        PACKET_CODEC.encode((Object)buf, (Object)this);
    }

    public static PotionRecipeEffect read(class_9129 buf) {
        return (PotionRecipeEffect)PACKET_CODEC.decode((Object)buf);
    }

    @Nullable
    public InkPoweredStatusEffectInstance getStatusEffectInstance(@NotNull PotionMod potionMod, class_5819 random) {
        float potency = potionMod.flatPotencyBonus();
        int durationTicks = this.baseDurationTicks() + potionMod.flatDurationBonusTicks();
        switch (((class_1291)this.statusEffect().comp_349()).method_18792()) {
            case field_18271: {
                potency += potionMod.flatPotencyBonusPositiveEffects();
                durationTicks += potionMod.flatDurationBonusPositiveEffects();
                break;
            }
            case field_18272: {
                potency += potionMod.flatPotencyBonusNegativeEffects();
                durationTicks += potionMod.flatDurationBonusNegativeEffects();
                break;
            }
        }
        int n = durationTicks = ((class_1291)this.statusEffect().comp_349()).method_5561() ? 1 : (int)((float)durationTicks * potionMod.durationMultiplier());
        if (this.potencyModifier() == 0.0f) {
            potency = 0.0f;
        } else {
            potency = ((1.0f + potency) * potionMod.potencyMultiplier() - 1.0f) * this.potencyModifier();
            if ((potency = (float)Support.getIntFromDecimalWithChance(potency, random)) < 0.0f && (double)potionMod.potencyMultiplier() == 0.0) {
                potency = 0.0f;
            }
        }
        if (this.potencyHardCap > -1 && potency > (float)this.potencyHardCap) {
            potency = this.potencyHardCap;
        }
        if (potency >= 0.0f && durationTicks > 0) {
            int effectColor = potionMod.getColor(random);
            return new InkPoweredStatusEffectInstance(new class_1293(this.statusEffect, durationTicks, (int)potency, !potionMod.flags().noParticles(), !potionMod.flags().noParticles()), new InkCost(this.inkColor(), this.inkCost()), effectColor, potionMod.flags().unidentifiable());
        }
        return null;
    }

    public boolean isApplicableTo(class_1799 baseIngredient, PotionMod potionMod) {
        if (baseIngredient.method_31574(class_1802.field_8107)) {
            return this.applicableToTippedArrows && potionMod.flags().makeSplashing() && potionMod.flags().makeLingering();
        }
        class_1792 class_17922 = baseIngredient.method_7909();
        if (class_17922 instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)class_17922;
            return this.applicableToPotionFillabes && !inkPoweredPotionFillable.isFull(baseIngredient) || this.applicableToWeapons && inkPoweredPotionFillable.isWeapon();
        }
        return this.applicableToPotions;
    }
}

