/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.item.FermentedItem;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.components.BeverageComponent;
import de.dafuqs.spectrum.components.InfusedBeverageComponent;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.StorageRecipeInput;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationStatusEffectEntry;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class TitrationBarrelRecipe
extends GatedStackSpectrumRecipe<StorageRecipeInput<SingleVariantStorage<FluidVariant>>>
implements ITitrationBarrelRecipe {
    public static final List<Integer> FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS = new ArrayList<Integer>(){
        {
            this.add(1);
            this.add(10);
            this.add(100);
        }
    };
    public final List<IngredientStack> inputStacks;
    public final class_1799 outputItemStack;
    public final class_1792 tappingItem;
    public final FluidIngredient fluid;
    public final int minFermentationTimeHours;
    public final FermentationData fermentationData;

    public TitrationBarrelRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, List<IngredientStack> inputStacks, FluidIngredient fluid, class_1799 outputItemStack, class_1792 tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(group, secret, requiredAdvancementIdentifier);
        this.inputStacks = inputStacks;
        this.fluid = fluid;
        this.minFermentationTimeHours = minFermentationTimeHours;
        this.outputItemStack = outputItemStack;
        this.tappingItem = tappingItem;
        this.fermentationData = fermentationData;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean matches(StorageRecipeInput<SingleVariantStorage<FluidVariant>> recipeInput, class_1937 world) {
        SingleVariantStorage<FluidVariant> fluidStorage = recipeInput.getFluidStorage();
        if (!this.fluid.test((FluidVariant)fluidStorage.variant)) {
            return false;
        }
        if (this.fluid != FluidIngredient.EMPTY && fluidStorage.getAmount() != fluidStorage.getCapacity()) {
            return false;
        }
        return this.matchIngredientStacksExclusively(recipeInput, this.getIngredientStacks());
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputStacks;
    }

    @Override
    public class_1792 getTappingItem() {
        return this.tappingItem;
    }

    @Override
    public int getMinFermentationTimeHours() {
        return this.minFermentationTimeHours;
    }

    @Override
    public FermentationData getFermentationData() {
        return this.fermentationData;
    }

    @Deprecated
    public class_1799 assemble(StorageRecipeInput<SingleVariantStorage<FluidVariant>> inventory, class_7225.class_7874 drm) {
        return this.getDefaultTap(1).method_7972();
    }

    public class_1799 getPreviewTap(int timeMultiplier) {
        return this.tapWith(1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    public class_1799 getDefaultTap(int timeMultiplier) {
        class_1799 stack = this.getPreviewTap(timeMultiplier);
        stack.method_7939(this.outputItemStack.method_7947());
        FermentedItem.setPreviewStack(stack);
        return stack;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.getDefaultTap(1);
    }

    public Collection<class_1799> getOutputVariations(List<Integer> timeMultipliers) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (int timeMultiplier : timeMultipliers) {
            list.add(this.getDefaultTap(timeMultiplier));
        }
        return list;
    }

    @Override
    public FluidIngredient getFluidInput() {
        return this.fluid;
    }

    @Override
    public float getAngelsSharePerMcDay() {
        return this.fermentationData.angelsSharePercentPerMcDay();
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int contentCount = InventoryHelper.countItemsInInventory(inventory);
        float thickness = this.getThickness(contentCount);
        return this.tapWith(thickness, secondsFermented, downfall);
    }

    private class_1799 tapWith(float thickness, long secondsFermented, float downfall) {
        class_1799 stack = this.outputItemStack.method_7972();
        return TitrationBarrelRecipe.getFermentedStack(this.fermentationData, thickness, secondsFermented, downfall, stack);
    }

    public static class_1799 getFermentedStack(@NotNull FermentationData fermentationData, float thickness, long secondsFermented, float downfall, class_1799 inputStack) {
        class_1844 potionContents;
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = 0.0;
        if (fermentationData.fermentationSpeedMod() > 0.0f) {
            alcPercent = TitrationBarrelRecipe.getAlcPercent(fermentationData.fermentationSpeedMod(), thickness, downfall, ageIngameDays);
            alcPercent = Math.max(0.0, alcPercent);
        }
        if (alcPercent >= 100.0 && inputStack.method_7909() instanceof FermentedItem) {
            return SpectrumItems.PURE_ALCOHOL.method_7854();
        }
        if (!(inputStack.method_7909() instanceof FermentedItem)) {
            inputStack.method_57379(SpectrumDataComponentTypes.INFUSED_BEVERAGE, (Object)InfusedBeverageComponent.DEFAULT);
        }
        if ((potionContents = (class_1844)inputStack.method_57824(class_9334.field_49651)) != null) {
            float durationMultiplier = (float)Support.logBase(1.0f + thickness, 2.0);
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            for (FermentationStatusEffectEntry entry : fermentationData.statusEffectEntries()) {
                int potency = -1;
                int durationTicks = entry.baseDuration();
                for (FermentationStatusEffectEntry.StatusEffectPotencyEntry potencyEntry : entry.potencyEntries()) {
                    if (!(thickness >= potencyEntry.minThickness()) || !(alcPercent >= (double)potencyEntry.minAlcPercent())) continue;
                    potency = potencyEntry.potency();
                }
                if (potency <= -1) continue;
                effects.add(new class_1293((class_6880)class_7923.field_41174.method_40290((class_5321)class_7923.field_41174.method_29113((Object)entry.statusEffect()).get()), (int)((float)durationTicks * durationMultiplier), potency));
            }
            inputStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), effects));
        }
        inputStack.method_57379(SpectrumDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        return inputStack;
    }

    protected static double getAlcPercent(float fermentationSpeedMod, float thickness, float downfall, float ageIngameDays) {
        return Support.logBase(1.0f + fermentationSpeedMod, (double)ageIngameDays * (0.5 + (double)thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }

    protected float getThickness(int contentCount) {
        int inputStacksCount = 0;
        for (IngredientStack stack : this.inputStacks) {
            inputStacksCount += stack.getCount();
        }
        return (float)contentCount / (float)inputStacksCount;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.TITRATION_BARREL;
    }

    public static class_5250 getDurationText(int minFermentationTimeHours, FermentationData fermentationData) {
        class_5250 text = fermentationData.equals(FermentationData.DEFAULT) ? (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_day") : (minFermentationTimeHours >= 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_hours", (Object[])new Object[]{minFermentationTimeHours})))) : (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_day") : (minFermentationTimeHours > 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_hours", (Object[])new Object[]{minFermentationTimeHours}))));
        return text;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return ITitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "titration_barrel";
    }

    public static class Serializer
    implements class_1865<TitrationBarrelRecipe> {
        public static final MapCodec<TitrationBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.Serializer.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.inputStacks), (App)FluidIngredient.CODEC.optionalFieldOf("fluid", (Object)FluidIngredient.EMPTY).forGetter(recipe -> recipe.fluid), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.outputItemStack), (App)class_7923.field_41178.method_39673().optionalFieldOf("tapping_item", (Object)class_1802.field_8162).forGetter(recipe -> recipe.tappingItem), (App)Codec.INT.optionalFieldOf("min_fermentation_time_hours", (Object)24).forGetter(recipe -> recipe.minFermentationTimeHours), (App)FermentationData.CODEC.optionalFieldOf("fermentation", (Object)FermentationData.DEFAULT).forGetter(recipe -> recipe.fermentationData)).apply((Applicative)i, TitrationBarrelRecipe::new));
        private static final class_9139<class_9129, TitrationBarrelRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, c -> c.group, class_9135.field_48547, c -> c.secret, class_9135.method_56382((class_9139)class_2960.field_48267), c -> c.requiredAdvancementIdentifier, IngredientStack.Serializer.PACKET_CODEC.method_56433(class_9135.method_56363()), c -> c.inputStacks, FluidIngredient.PACKET_CODEC, c -> c.fluid, class_1799.field_48349, c -> c.outputItemStack, class_9135.method_56365((class_5321)class_7924.field_41197), recipe -> recipe.tappingItem, class_9135.field_48550, recipe -> recipe.minFermentationTimeHours, FermentationData.PACKET_CODEC, recipe -> recipe.fermentationData, TitrationBarrelRecipe::new);

        public MapCodec<TitrationBarrelRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, TitrationBarrelRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

