/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.components.BeverageComponent;
import de.dafuqs.spectrum.components.JadeWineComponent;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2960;
import net.minecraft.class_9334;

public abstract class SweetenableTitrationBarrelRecipe
extends TitrationBarrelRecipe {
    public SweetenableTitrationBarrelRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, List<IngredientStack> inputStacks, FluidIngredient fluid, class_1799 outputItemStack, class_1792 tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(group, secret, requiredAdvancementIdentifier, inputStacks, fluid, outputItemStack, tappingItem, minFermentationTimeHours, fermentationData);
    }

    @Override
    public class_1799 getPreviewTap(int timeMultiplier) {
        return this.tapWith(1, 3, false, 1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    protected abstract List<class_1293> getEffects(boolean var1, double var2, double var4);

    protected class_1799 tapWith(int bulbCount, int petalCount, boolean nectar, float thickness, long secondsFermented, float downfall) {
        double alcPercent;
        double bloominess = SweetenableTitrationBarrelRecipe.getBloominess(bulbCount, petalCount);
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        if (nectar) {
            thickness *= 1.5f;
        }
        if ((alcPercent = this.getAlcPercentWithBloominess(ageIngameDays, downfall, bloominess, thickness)) >= 100.0) {
            return SpectrumItems.CHRYSOCOLLA.method_7854();
        }
        List<class_1293> effects = this.getEffects(nectar, bloominess, alcPercent);
        class_1799 outputStack = this.outputItemStack.method_7972();
        outputStack.method_7939(1);
        outputStack.method_57379(SpectrumDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        outputStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), effects));
        outputStack.method_57379(SpectrumDataComponentTypes.JADE_WINE, (Object)new JadeWineComponent((float)bloominess, nectar));
        return outputStack;
    }

    protected static double getBloominess(int bulbCount, int petalCount) {
        if (bulbCount == 0) {
            return 0.0;
        }
        return (double)petalCount / (double)bulbCount / 2.0;
    }

    protected float getThickness(int bulbCount, int petalCount) {
        return (float)bulbCount + (float)petalCount / 8.0f;
    }

    protected double getAlcPercentWithBloominess(float ageIngameDays, float downfall, double bloominess, double thickness) {
        return Support.logBase((double)(1.0f + this.fermentationData.fermentationSpeedMod()) + bloominess / 64.0, (double)ageIngameDays * (0.5 + thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }
}

