/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.arrowhead.api.CrossbowShootingCallback;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.AoEBreakingTool;
import de.dafuqs.spectrum.api.item.PrioritizedBlockInteraction;
import de.dafuqs.spectrum.api.item.PrioritizedEntityInteraction;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.blocks.idols.FirestarterIdolBlock;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.cca.HardcoreDeathComponent;
import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.components.InertiaComponent;
import de.dafuqs.spectrum.entity.spawners.ShootingStarSpawner;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.tools.GlassCrestCrossbowItem;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.items.trinkets.WhispyCircletItem;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.progression.UnlockToastManager;
import de.dafuqs.spectrum.registries.SpectrumAttributeTags;
import de.dafuqs.spectrum.registries.SpectrumDamageTypeTags;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class SpectrumEventListeners {
    public static final HashMap<class_3611, Integer> fluidLuminance = new HashMap();

    public static void register() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_1799 mainHandStack;
            class_1792 patt0$temp;
            if (!world.field_9236 && !player.method_7325() && (patt0$temp = (mainHandStack = player.method_6047()).method_7909()) instanceof ExchangeStaffItem) {
                Optional<class_2248> storedBlock;
                ExchangeStaffItem exchangeStaffItem = (ExchangeStaffItem)patt0$temp;
                class_2680 targetBlockState = world.method_8320(pos);
                if (exchangeStaffItem.canInteractWith(targetBlockState, (class_1922)world, pos, player) && (storedBlock = ExchangeStaffItem.getStoredBlock(player.method_6047())).isPresent() && storedBlock.get() != targetBlockState.method_26204() && storedBlock.get().method_8389() != class_1802.field_8162 && ExchangeStaffItem.exchange(world, pos, player, storedBlock.get(), player.method_6047(), true, direction)) {
                    return class_1269.field_5812;
                }
                world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                SpectrumColorProviders.resetToggleableProviders();
            }
        });
        PlayerBlockBreakEvents.AFTER.register((level, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                class_1799 stack = serverPlayerEntity.method_6047();
                class_1792 patt0$temp = stack.method_7909();
                if (patt0$temp instanceof AoEBreakingTool) {
                    AoEBreakingTool tool = (AoEBreakingTool)patt0$temp;
                    tool.afterBreakingBlock(stack, pos, (class_1657)serverPlayerEntity);
                }
                class_1799 handStack = player.method_5998(serverPlayerEntity.method_6058());
                if (SpectrumEnchantmentHelper.hasEnchantment((class_7225.class_7874)player.method_37908().method_30349(), SpectrumEnchantments.INERTIA, handStack)) {
                    InertiaComponent.onInertiaBlockBreak(level, pos, state, serverPlayerEntity, handStack);
                }
                SpectrumAdvancementCriteria.BLOCK_BROKEN.trigger(serverPlayerEntity, state);
            }
        });
        EnchantmentEvents.ALLOW_ENCHANTING.register((registryEntry, itemStack, enchantingContext) -> {
            if (registryEntry.method_40225(SpectrumEnchantments.INDESTRUCTIBLE) && itemStack.method_31573(SpectrumItemTags.INDESTRUCTIBLE_BLACKLISTED)) {
                return TriState.FALSE;
            }
            return TriState.DEFAULT;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedEntityInteraction && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return handStack.method_7920(player, livingEntity, hand);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedBlockInteraction) {
                return handStack.method_7981(new class_1838(player, hand, hitResult));
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (!server.method_54833().method_54751()) {
                return;
            }
            try {
                Pastel.getServerInstance().tick();
            }
            catch (Exception e) {
                SpectrumCommon.logError("Error in the Pastel Network transmission loop.");
                e.printStackTrace();
            }
            class_3324 playerManager = server.method_3760();
            for (class_3222 player : playerManager.method_14571()) {
                class_1937 world = player.method_37908();
                if (player.method_7337() || player.method_7325() || world.method_27983() != SpectrumDimensions.DIMENSION_KEY || !(player.method_23318() > (double)world.method_31600())) continue;
                player.method_5643(player.method_48923().method_48829(), 10.0f);
                if (!player.method_29504()) continue;
                Support.grantAdvancementCriterion(player, "lategame/get_killed_while_out_of_deeper_down_bounds", "get_rekt");
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (!world.method_54719().method_54751()) {
                return;
            }
            if (world.method_8510() % 100L == 0L && TimeHelper.getTimeOfDay((class_1937)world).isNight() && SpectrumCommon.CONFIG.ShootingStarWorlds.contains(world.method_27983().method_29177().toString())) {
                ShootingStarSpawner.INSTANCE.method_6445(world, true, true);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SpectrumCommon.logInfo("Querying fluid luminance...");
            Iterator it = class_7923.field_41175.method_10220().iterator();
            while (it.hasNext()) {
                class_2248 block = (class_2248)it.next();
                if (!(block instanceof class_2404)) continue;
                class_2404 fluidBlock = (class_2404)block;
                fluidLuminance.put((class_3611)fluidBlock.field_11279, fluidBlock.method_9564().method_26213());
            }
            SpectrumCommon.logInfo("Injecting dynamic recipes into recipe manager...");
            FirestarterIdolBlock.addBlockSmeltingRecipes(server);
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && (serverPlayerEntity = (class_3222)entity).method_7297() == 100 && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.WHISPY_CIRCLET)) {
                entity.method_6033(entity.method_6063());
                WhispyCircletItem.removeNegativeStatusEffects(entity);
            }
        });
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && SpectrumTrinketItem.hasEquipped((class_1309)(serverPlayerEntity = (class_3222)entity), SpectrumItems.JEOPARDANT)) {
                SpectrumAdvancementCriteria.JEOPARDANT_KILL.trigger(serverPlayerEntity, (class_1297)killedEntity);
            }
        });
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> {
            class_6862<class_1320> effectType;
            int oldInexorable = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)livingEntity.method_37908().method_30349(), SpectrumEnchantments.INEXORABLE, previousStack);
            int newInexorable = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)livingEntity.method_37908().method_30349(), SpectrumEnchantments.INEXORABLE, currentStack);
            class_6862<class_1320> class_68622 = effectType = equipmentSlot == class_1304.field_6174 ? SpectrumAttributeTags.INEXORABLE_ARMOR_EFFECTIVE : SpectrumAttributeTags.INEXORABLE_HANDHELD_EFFECTIVE;
            if (oldInexorable > 0 && newInexorable <= 0) {
                livingEntity.method_6026().stream().filter(instance -> {
                    AtomicBoolean result = new AtomicBoolean(false);
                    ((class_1291)instance.method_5579().comp_349()).method_55650(instance.method_5578(), (attribute, modifier) -> {
                        if (attribute.method_40220(effectType)) {
                            result.set(true);
                        }
                    });
                    return result.get();
                }).forEach(instance -> ((class_1291)instance.method_5579().comp_349()).method_52520(livingEntity, instance.method_5578()));
            }
        });
        EntitySleepEvents.ALLOW_BED.register((entity, sleepingPos, state, vanillaResult) -> {
            class_1657 player;
            if (entity instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)entity).isSleeping()) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.register((entity, sleepingPos, sleepingDirection) -> {
            class_1657 player;
            if (entity instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)entity).isSleeping()) {
                return player.method_5735();
            }
            return sleepingDirection;
        });
        EntitySleepEvents.ALLOW_NEARBY_MONSTERS.register((player, sleepingPos, vanillaResult) -> {
            if (MiscPlayerDataComponent.get(player).isSleeping() || player.method_6059(SpectrumStatusEffects.SOMNOLENCE)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (player.method_6059(SpectrumStatusEffects.SOMNOLENCE)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        CrossbowShootingCallback.register((world, shooter, crossbow, projectile) -> {
            int snipingLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)world.method_30349(), SpectrumEnchantments.SNIPING, crossbow);
            if (snipingLevel > 0) {
                projectile.method_18799(projectile.method_18798().method_1021((double)(1.25f * (float)snipingLevel)));
            }
            if (crossbow.method_7909() instanceof GlassCrestCrossbowItem && GlassCrestCrossbowItem.isOvercharged(crossbow)) {
                class_243 particleVelocity = projectile.method_18798().method_1021(0.05);
                if (GlassCrestCrossbowItem.getOvercharge(crossbow) > 0.99f) {
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectile.method_19538(), (class_2394)class_2398.field_29645, 5, class_243.field_1353, particleVelocity);
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectile.method_19538(), (class_2394)class_2398.field_29643, 5, class_243.field_1353, particleVelocity);
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectile.method_19538(), (class_2394)class_2398.field_29642, 5, class_243.field_1353, particleVelocity);
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectile.method_19538(), (class_2394)class_2398.field_28479, 5, class_243.field_1353, particleVelocity);
                    if (shooter instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)shooter;
                        Support.grantAdvancementCriterion(serverPlayerEntity, SpectrumCommon.locate("lategame/shoot_fully_overcharged_crossbow"), "shot_fully_overcharged_crossbow");
                    }
                    if (projectile instanceof class_1665) {
                        class_1665 persistentProjectileEntity = (class_1665)projectile;
                        persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() * 1.5);
                    }
                }
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectile.method_19538(), (class_2394)class_2398.field_11248, 10, class_243.field_1353, particleVelocity);
                GlassCrestCrossbowItem.unOvercharge(crossbow);
            }
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            if (damageSource.method_48789(class_8103.field_42242)) {
                return true;
            }
            Optional optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
            if (optionalTrinketComponent.isPresent()) {
                List totems = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(SpectrumItems.TOTEM_PENDANT);
                for (class_3545 pair : totems) {
                    class_1799 totemStack = (class_1799)pair.method_15441();
                    if (totemStack.method_7947() <= 0) continue;
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)entity;
                        serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)SpectrumItems.TOTEM_PENDANT));
                        class_174.field_1204.method_9165(serverPlayerEntity, totemStack);
                    }
                    totemStack.method_7934(1);
                    entity.method_6033(1.0f);
                    entity.method_6012();
                    entity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
                    entity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
                    entity.method_6092(new class_1293(class_1294.field_5918, 800, 0));
                    entity.method_37908().method_8421((class_1297)entity, (byte)35);
                    return false;
                }
            }
            return true;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                if (entity.method_37908().method_8401().method_152() || HardcoreDeathComponent.isInHardcore((class_1657)player)) {
                    HardcoreDeathComponent.addHardcoreDeath(player.method_51469(), player.method_7334());
                }
                SpectrumEventListeners.evaluateAndDropPlayerHead(player, damageSource);
            }
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (source.method_49708(class_8111.field_42338)) {
                Optional<class_1799> ashenCircletStack = SpectrumTrinketItem.getFirstEquipped(entity, SpectrumItems.ASHEN_CIRCLET);
                if (ashenCircletStack.isPresent() && AshenCircletItem.getCooldownTicks(ashenCircletStack.get(), entity.method_37908()) == 0L) {
                    AshenCircletItem.grantFireResistance(ashenCircletStack.get(), entity);
                    return false;
                }
            } else if (source.method_48789(class_8103.field_42246) && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.ASHEN_CIRCLET)) {
                return false;
            }
            return true;
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = SpectrumCommon.locate("server_data_cache_clearer");

            public void method_14491(class_3300 manager) {
                CompactingChestBlockEntity.clearCache();
                SpectrumCommon.CACHED_ITEM_TAG_MAP.clear();
                if (SpectrumCommon.minecraftServer != null) {
                    FirestarterIdolBlock.addBlockSmeltingRecipes(SpectrumCommon.minecraftServer);
                }
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    UnlockToastManager.clear();
                }
            }

            public class_2960 getFabricId() {
                return this.id;
            }
        });
    }

    private static void evaluateAndDropPlayerHead(class_3222 player, class_1282 source) {
        if (!player.method_7325()) {
            class_1297 class_12972;
            class_3218 serverWorld = player.method_51469();
            boolean shouldDropHead = source.method_48789(SpectrumDamageTypeTags.ALWAYS_DROPS_MOB_HEAD);
            if (!shouldDropHead && (class_12972 = source.method_5529()) instanceof class_1309) {
                class_1309 livingAttacker = (class_1309)class_12972;
                int damageSourceTreasureHunt = SpectrumEnchantmentHelper.getEquipmentLevel((class_7225.class_7874)serverWorld.method_30349(), SpectrumEnchantments.TREASURE_HUNTER, livingAttacker);
                boolean bl = shouldDropHead = damageSourceTreasureHunt > 0 && (double)serverWorld.method_8409().method_43057() < 0.2 * (double)damageSourceTreasureHunt;
            }
            if (shouldDropHead) {
                class_1799 headItemStack = new class_1799((class_1935)class_1802.field_8575);
                headItemStack.method_57379(class_9334.field_49617, (Object)new class_9296(player.method_7334()));
                class_1542 headEntity = new class_1542((class_1937)serverWorld, player.method_23317(), player.method_23318(), player.method_23321(), headItemStack);
                serverWorld.method_8649((class_1297)headEntity);
            }
        }
    }

    public static int getFluidLuminance(class_3611 fluid) {
        return fluidLuminance.getOrDefault(fluid, 0);
    }
}

