/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.interaction.ItemProjectileBehavior;
import de.dafuqs.spectrum.api.interaction.OmniAcceleratorProjectile;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.blocks.boom.IncandescentAmalgamBlock;
import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.entity.entity.ItemProjectileEntity;
import de.dafuqs.spectrum.items.magic_items.CraftingTabletItem;
import de.dafuqs.spectrum.items.magic_items.EnchantmentCanvasItem;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.items.magic_items.PipeBombItem;
import de.dafuqs.spectrum.items.magic_items.ampoules.GlassAmpouleItem;
import de.dafuqs.spectrum.items.tools.OmniAcceleratorItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3857;
import net.minecraft.class_3955;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SpectrumItemProjectileBehaviors {
    public static void register() {
        SpectrumItemProjectileBehaviors.registerHarmless();
        if (SpectrumCommon.CONFIG.OmniAcceleratorPvP) {
            SpectrumItemProjectileBehaviors.registerPvP();
        }
    }

    protected static void registerHarmless() {
        ItemProjectileBehavior.register(new ItemProjectileBehavior(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3966 hitResult) {
                class_1297 hitEntity = hitResult.method_17782();
                if (hitEntity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)hitEntity;
                    stack.method_7910(projectile.method_37908(), livingEntity);
                    return new class_1799((class_1935)class_1802.field_8469);
                }
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3965 hitResult) {
                return stack;
            }
        }, class_1802.field_8574);
        ItemProjectileBehavior.register(new ItemProjectileBehavior(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3966 hitResult) {
                if (this.strikeLightning(hitResult.method_17782().method_37908(), hitResult.method_17782().method_24515())) {
                    stack.method_7934(1);
                }
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, class_1297 owner, class_3965 hitResult) {
                if (this.strikeLightning(projectile.method_37908(), hitResult.method_17777())) {
                    stack.method_7934(1);
                }
                return stack;
            }

            private boolean strikeLightning(class_1937 world, class_2338 pos) {
                class_1538 lightningEntity;
                if (world.method_8311(pos.method_10084()) && (lightningEntity = (class_1538)class_1299.field_6112.method_5883(world)) != null) {
                    lightningEntity.method_29495(class_243.method_24955((class_2382)pos));
                    world.method_8649((class_1297)lightningEntity);
                    return true;
                }
                return false;
            }
        }, SpectrumItems.STORM_STONE);
        ItemProjectileBehavior.register(ItemProjectileBehavior.damaging(4.0f, true), SpectrumItemTags.GEMSTONE_SHARDS);
        ItemProjectileBehavior.register(ItemProjectileBehavior.damaging(6.0f, true), class_1802.field_28042);
        ItemProjectileBehavior.register(ItemProjectileBehavior.damaging(6.0f, true), class_1802.field_8056);
        ItemProjectileBehavior.register(ItemProjectileBehavior.damaging(6.0f, true), class_1802.field_8894);
        ItemProjectileBehavior.register(ItemProjectileBehavior.damaging(8.0f, true), SpectrumItems.STAR_FRAGMENT);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Damaging(){

            @Override
            public boolean destroyItemOnHit() {
                return false;
            }

            @Override
            public boolean dealDamage(class_3857 projectile, class_1297 owner, class_1297 target) {
                return target.method_5643(target.method_48923().method_48811((class_1297)projectile, owner), 6.0f);
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3965 hitResult) {
                class_1937 world = projectile.method_37908();
                class_2586 blockEntity = world.method_8321(hitResult.method_17777());
                if (blockEntity instanceof class_2619) {
                    class_2619 jukeboxBlockEntity = (class_2619)blockEntity;
                    if (!blockEntity.method_11015()) {
                        class_1799 currentStack = jukeboxBlockEntity.method_5438(0);
                        if (!currentStack.method_7960()) {
                            jukeboxBlockEntity.method_49213();
                        }
                        jukeboxBlockEntity.method_54077(stack.method_7972());
                        stack.method_7934(1);
                    }
                }
                return stack;
            }
        }, (class_6862<class_1792>)ConventionalItemTags.MUSIC_DISCS);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1297 entity = hitResult.method_17782();
                if (!entity.method_5753()) {
                    entity.method_5639(15.0f);
                    if (entity.method_5643(entity.method_48923().method_48794(), 4.0f)) {
                        entity.method_5783(class_3417.field_14821, 0.4f, 2.0f + entity.method_37908().method_8409().method_43057() * 0.4f);
                    }
                    stack.method_7934(1);
                }
                return stack;
            }
        }, class_1802.field_8814);
        ItemProjectileBehavior.register(new ItemProjectileBehavior(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                IncandescentAmalgamBlock.explode(projectile.method_37908(), class_2338.method_49638((class_2374)hitResult.method_17784()), owner, stack);
                stack.method_7934(1);
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3965 hitResult) {
                IncandescentAmalgamBlock.explode(projectile.method_37908(), class_2338.method_49638((class_2374)hitResult.method_17784()), owner, stack);
                stack.method_7934(1);
                return stack;
            }
        }, SpectrumBlocks.INCANDESCENT_AMALGAM.method_8389());
        ItemProjectileBehavior.register(new ItemProjectileBehavior(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 accelerator, @Nullable class_1297 owner, class_3965 hitResult) {
                Optional<class_1799> optionalAcceleratorContentStack = OmniAcceleratorItem.getFirstStack((class_7225.class_7874)projectile.method_37908().method_30349(), accelerator);
                if (optionalAcceleratorContentStack.isPresent() && owner instanceof class_1309) {
                    class_1309 livingOwner = (class_1309)owner;
                    class_1799 acceleratorContentStack = optionalAcceleratorContentStack.get();
                    class_1937 world = projectile.method_37908();
                    OmniAcceleratorProjectile newProjectile = OmniAcceleratorProjectile.get(optionalAcceleratorContentStack.get());
                    class_1297 newEntity = newProjectile.createProjectile(acceleratorContentStack, livingOwner, world, accelerator);
                    if (newEntity != null) {
                        class_243 pos = hitResult.method_17784();
                        newEntity.method_23327(pos.method_10216(), pos.method_10214(), pos.method_10215());
                        OmniAcceleratorProjectile.setVelocity(newEntity, (class_1297)projectile, 20.0f, world.method_8409().method_43057() * 360.0f, 0.0f, 2.0f, 1.0f);
                        world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), newProjectile.getSoundEffect(), class_3419.field_15248, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
                        OmniAcceleratorItem.decrementFirstItem(accelerator);
                    }
                }
                return accelerator;
            }
        }, SpectrumItems.OMNI_ACCELERATOR);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1297 target = hitResult.method_17782();
                if (target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    livingTarget.method_6092(new class_1293(class_1294.field_5922, 20, 0));
                    livingTarget.method_6092(new class_1293(class_1294.field_5919, 200, 0));
                }
                stack.method_7934(1);
                return stack;
            }
        }, class_1802.field_17534);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                if (MemoryBlockEntity.manifest((class_3218)projectile.method_37908(), hitResult.method_17782().method_24515(), stack, owner == null ? null : owner.method_5667())) {
                    stack.method_7934(1);
                }
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3965 hitResult) {
                if (MemoryBlockEntity.manifest((class_3218)projectile.method_37908(), hitResult.method_17777().method_10093(hitResult.method_17780()), stack, owner == null ? null : owner.method_5667())) {
                    stack.method_7934(1);
                }
                return stack;
            }
        }, SpectrumBlocks.MEMORY.method_8389());
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                PipeBombItem.prime(stack, projectile.method_37908(), projectile.method_19538(), owner);
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3965 hitResult) {
                PipeBombItem.prime(stack, projectile.method_37908(), projectile.method_19538(), owner);
                return stack;
            }
        }, SpectrumItems.PIPE_BOMB);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1297 class_12972 = projectile.method_24921();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingOwner = (class_1309)class_12972;
                    class_12972 = hitResult.method_17782();
                    if (class_12972 instanceof class_1309) {
                        class_1309 livingTarget = (class_1309)class_12972;
                        if (((GlassAmpouleItem)stack.method_7909()).trigger(projectile.method_37908(), stack, livingOwner, livingTarget, hitResult.method_17784())) {
                            stack.method_7934(1);
                        }
                    }
                }
                return stack;
            }

            @Override
            public class_1799 onBlockHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3965 hitResult) {
                class_1297 class_12972 = projectile.method_24921();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingOwner = (class_1309)class_12972;
                    if (((GlassAmpouleItem)stack.method_7909()).trigger(projectile.method_37908(), stack, livingOwner, null, hitResult.method_17784())) {
                        stack.method_7934(1);
                    }
                }
                return stack;
            }
        }, SpectrumItems.AZURITE_GLASS_AMPOULE, SpectrumItems.MALACHITE_GLASS_AMPOULE, SpectrumItems.BLOODSTONE_GLASS_AMPOULE);
    }

    protected static void registerPvP() {
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1297 class_12972 = hitResult.method_17782();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)class_12972;
                    ArrayList equipment = new ArrayList();
                    livingTarget.method_56675().forEach(equipment::add);
                    Collections.shuffle(equipment);
                    for (class_1799 equip : equipment) {
                        if (!EnchantmentCanvasItem.tryExchangeEnchantments(stack, equip, (class_1297)livingTarget)) continue;
                        return stack;
                    }
                }
                return stack;
            }
        }, SpectrumItems.ENCHANTMENT_CANVAS);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1297 class_12972 = hitResult.method_17782();
                if (class_12972 instanceof class_1657) {
                    class_1657 target = (class_1657)class_12972;
                    int playerExperience = target.field_7495;
                    if (playerExperience > 0) {
                        KnowledgeGemItem item = (KnowledgeGemItem)stack.method_7909();
                        long transferableExperiencePerTick = item.getTransferableExperiencePerTick((class_7225.class_7874)target.method_37908().method_30349(), stack);
                        int xpToTransfer = (int)Math.min((long)target.field_7495, transferableExperiencePerTick * 100L);
                        int experienceOverflow = ExperienceStorageItem.addStoredExperience((class_7225.class_7874)target.method_37908().method_30349(), stack, xpToTransfer);
                        target.method_7255(-xpToTransfer + experienceOverflow);
                        target.method_5783(class_3417.field_14627, 0.3f, 0.8f + target.method_37908().method_8409().method_43057() * 0.4f);
                        return stack;
                    }
                }
                return stack;
            }
        }, SpectrumItems.KNOWLEDGE_GEM);
        ItemProjectileBehavior.register((ItemProjectileBehavior)new ItemProjectileBehavior.Default(){

            @Override
            public class_1799 onEntityHit(ItemProjectileEntity projectile, class_1799 stack, @Nullable class_1297 owner, class_3966 hitResult) {
                class_1860 recipe = CraftingTabletItem.getStoredRecipe(projectile.method_37908(), stack).comp_1933();
                if (recipe instanceof class_3955) {
                    class_3955 craftingRecipe = (class_3955)recipe;
                    class_1297 class_12972 = hitResult.method_17782();
                    if (class_12972 instanceof class_3222) {
                        class_3222 target = (class_3222)class_12972;
                        CraftingTabletItem.tryCraftRecipe((class_1657)target, craftingRecipe, projectile.method_37908());
                    }
                }
                return stack;
            }
        }, SpectrumItems.CRAFTING_TABLET);
    }
}

