/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeSignature;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class SpectrumPastelUpgrades {
    private static final Map<class_1792, PastelUpgradeSignature> UPGRADES = new HashMap<class_1792, PastelUpgradeSignature>();
    private static final String NAMESPACE = "spectrum";
    public static PastelUpgradeSignature WEAK_STACK;
    public static PastelUpgradeSignature STRONG_STACK;
    public static PastelUpgradeSignature WEAK_SPEED;
    public static PastelUpgradeSignature STRONG_SPEED;
    public static PastelUpgradeSignature WEAK_FILTER;
    public static PastelUpgradeSignature STRONG_FILTER;
    public static PastelUpgradeSignature RATE;
    public static PastelUpgradeSignature LIGHT;
    public static PastelUpgradeSignature ALWAYS_ON;
    public static PastelUpgradeSignature ALWAYS_OFF;
    public static PastelUpgradeSignature INVERTED;
    public static PastelUpgradeSignature SENSOR;
    public static PastelUpgradeSignature TRIGGER;
    public static PastelUpgradeSignature LAMP;
    public static final PastelUpgradeSignature.Category NON_COMPOUNDING;
    public static final PastelUpgradeSignature.Category STACK;
    public static final PastelUpgradeSignature.Category SPEED;
    public static final PastelUpgradeSignature.Category FILTER;
    public static final PastelUpgradeSignature.Category REDSTONE;

    public static void register() {
        WEAK_STACK = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.RAW_BLOODSTONE, STACK, NAMESPACE).named("weak_stack").stackMod(3).stackMult(2.0f).build());
        STRONG_STACK = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_BLOODSTONE, STACK, NAMESPACE).named("strong_stack").stackMod(15).stackMult(4.0f).build());
        WEAK_SPEED = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.RAW_MALACHITE, SPEED, NAMESPACE).named("weak_speed").speedMod(-5).speedMult(0.8f).build());
        STRONG_SPEED = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_MALACHITE, SPEED, NAMESPACE).named("strong_speed").speedMod(-10).speedMult(0.5f).build());
        WEAK_FILTER = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.RAW_AZURITE, FILTER, NAMESPACE).named("weak_filter").slotRowMod(1).build());
        STRONG_FILTER = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_AZURITE, FILTER, NAMESPACE).named("strong_filter").slotRowMod(2).build());
        RATE = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.RESONANCE_SHARD, NON_COMPOUNDING, NAMESPACE).named("rate").priority(true).build());
        LIGHT = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.SHIMMERSTONE_GEM, NON_COMPOUNDING, NAMESPACE).named("light").light(true).build());
        ALWAYS_ON = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_REDSTONE, REDSTONE, NAMESPACE).redstone("always_active").redstonePreProcess(context -> class_1269.field_5812).buildRedstone());
        ALWAYS_OFF = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_LAPIS, REDSTONE, NAMESPACE).redstone("always_inactive").redstonePreProcess(context -> class_1269.field_5814).buildRedstone());
        INVERTED = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_COAL, REDSTONE, NAMESPACE).redstone("inverted").redstonePostProcess(context -> {
            if (context.active()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5812;
        }).buildRedstone());
        LAMP = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_GLOWSTONE, REDSTONE, NAMESPACE).redstone("lamp").lamp(true).buildRedstone());
        TRIGGER = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_QUARTZ, REDSTONE, NAMESPACE).redstone("trigger").triggerTransfer(true).buildRedstone());
        SENSOR = SpectrumPastelUpgrades.register(PastelUpgradeSignature.builder(SpectrumItems.PURE_ECHO, REDSTONE, NAMESPACE).redstone("sensor").sensor(true).buildRedstone());
    }

    private static PastelUpgradeSignature register(PastelUpgradeSignature upgrade) {
        UPGRADES.put(upgrade.upgradeItem, upgrade);
        return (PastelUpgradeSignature)class_2378.method_10230(SpectrumRegistries.PASTEL_UPGRADE, (class_2960)SpectrumCommon.locate(upgrade.name), (Object)upgrade);
    }

    public static PastelUpgradeSignature of(class_1792 item) {
        if (!UPGRADES.containsKey(item)) {
            throw new IllegalArgumentException("Attempted to fetch an upgrade that does not exist");
        }
        return UPGRADES.get(item);
    }

    public static String toString(PastelUpgradeSignature upgrade) {
        return SpectrumRegistries.PASTEL_UPGRADE.method_10221(upgrade).toString();
    }

    public static PastelUpgradeSignature of(class_1799 stack) {
        return SpectrumPastelUpgrades.of(stack.method_7909());
    }

    static {
        NON_COMPOUNDING = PastelUpgradeSignature.Category.nonCompounding();
        STACK = PastelUpgradeSignature.Category.simple();
        SPEED = PastelUpgradeSignature.Category.simple();
        FILTER = PastelUpgradeSignature.Category.simple();
        REDSTONE = PastelUpgradeSignature.Category.redstone();
    }
}

