/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.render.animation;

import de.dafuqs.spectrum.render.animation.DataSignature;
import de.dafuqs.spectrum.render.animation.FlowData;
import de.dafuqs.spectrum.render.animation.FlowHandler;
import de.dafuqs.spectrum.render.animation.FlowState;
import de.dafuqs.spectrum.render.animation.FlowStates;
import de.dafuqs.spectrum.render.animation.Interpolation;
import de.dafuqs.spectrum.render.animation.KeyFrame;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlowAnimator {
    final Map<FlowState, StateInfo> trackedStates;
    final Set<FlowData<?>> liveData = new HashSet();
    @NotNull
    private StateInfo info;
    int interpProgress;

    private FlowAnimator(Map<FlowState, StateInfo> trackedStates, @NotNull FlowState initialState) {
        this.trackedStates = trackedStates;
        this.info = trackedStates.get(initialState);
        this.interpProgress = this.info.interpTime;
    }

    public void tick() {
        if (this.interpProgress > 0) {
            --this.interpProgress;
        }
    }

    public void animate(float tickDelta, long time) {
        float delta = Math.clamp(1.0f - ((float)this.interpProgress - tickDelta) / (float)this.info.interpTime, 0.0f, 1.0f);
        this.liveData.forEach(flowData -> flowData.update(delta, time));
    }

    public void swapState(@NotNull FlowState newState) {
        if (newState == this.info.state || !this.trackedStates.containsKey(newState)) {
            return;
        }
        this.info = this.trackedStates.get(newState);
        this.liveData.forEach(flowData -> flowData.notifyStateChange(this.info.state, this.info.clearOnMiss));
        this.interpProgress = this.info.interpTime;
    }

    record StateInfo(FlowState state, int interpTime, boolean clearOnMiss) {
    }

    public static final class Factory<T> {
        private final Map<FlowState, StateInfo> stateRegistrar;
        private final List<DataSignature<?>> larvalData;
        private final Class<T> targetClazz;

        private Factory(Class<T> targetClazz, Map<FlowState, StateInfo> stateRegistrar, List<DataSignature<?>> larvalData) {
            this.stateRegistrar = Collections.unmodifiableMap(stateRegistrar);
            this.larvalData = larvalData;
            this.targetClazz = targetClazz;
        }

        public FlowAnimator create(@NotNull FlowState initialState, T instance) {
            if (!this.targetClazz.isInstance(instance)) {
                throw new IllegalStateException("Attempted to create an animator for an incompatible object");
            }
            FlowAnimator animator = new FlowAnimator(this.stateRegistrar, initialState);
            for (DataSignature<?> signature : this.larvalData) {
                try {
                    FlowData<?> data = signature.instantiate();
                    signature.link(data, instance);
                    animator.liveData.add(data);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to create flow data");
                }
            }
            return animator;
        }
    }

    public static final class Builder<T> {
        private final List<DataSignature<?>> holder = new ArrayList();
        private final Map<FlowState, StateInfo> states = new HashMap<FlowState, StateInfo>();
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.stateInfo(FlowStates.INIT, 0);
        }

        public Builder<T> stateInfo(FlowState state, int interpolationTime, boolean clearOnMiss) {
            this.states.put(state, new StateInfo(state, interpolationTime, clearOnMiss));
            return this;
        }

        public Builder<T> stateInfo(FlowState state, int interpolationTime) {
            return this.stateInfo(state, interpolationTime, false);
        }

        public <N extends Number> DataBuilder<T, N> handle(String reference, FlowHandler<N> handler) {
            return new DataBuilder(this, reference, handler);
        }

        public Factory<T> build() {
            return new Factory<T>(this.clazz, this.states, Collections.unmodifiableList(this.holder));
        }

        public static final class DataBuilder<T, N extends Number> {
            private final Builder<T> builder;
            private final Map<FlowState, KeyFrame<N>> stateHolder = new HashMap<FlowState, KeyFrame<N>>();
            private final String reference;
            private final FlowHandler<N> handler;
            private Interpolation interpolation = Interpolation.LINEAR;
            private KeyFrame<N> defaultKeyFrame;
            private N initialValue;

            public DataBuilder(Builder<T> builder, String reference, FlowHandler<N> handler) {
                this.builder = builder;
                this.reference = "_" + reference;
                this.handler = handler;
            }

            public DataBuilder<T, N> interpolate(Interpolation interpolation) {
                this.interpolation = interpolation;
                return this;
            }

            public DataBuilder<T, N> forStates(N keyFrame, FlowState ... states) {
                return this.forStates(KeyFrame.simple(keyFrame), states);
            }

            public DataBuilder<T, N> loopback(FlowState ... states) {
                if (this.defaultKeyFrame == null) {
                    if (this.initialValue == null) {
                        throw new IllegalStateException("What the fuck. Like actually how.");
                    }
                    this.defaultKeyFrame = KeyFrame.simple(this.initialValue);
                }
                return this.forStates(this.defaultKeyFrame, states);
            }

            public DataBuilder<T, N> forStates(KeyFrame<N> keyFrame, FlowState ... states) {
                for (FlowState state : states) {
                    this.stateHolder.put(state, keyFrame);
                }
                return this;
            }

            public DataBuilder<T, N> initial(N initialValue) {
                this.initialValue = initialValue;
                return this;
            }

            public DataBuilder<T, N> startingKeyFrame(KeyFrame<N> keyFrame) {
                this.defaultKeyFrame = keyFrame;
                return this;
            }

            public void push() {
                Class clazz = this.builder.clazz;
                assert (this.handler != null);
                assert (this.interpolation != null);
                assert (!this.stateHolder.isEmpty());
                if (this.defaultKeyFrame == null) {
                    this.defaultKeyFrame = KeyFrame.simple(this.initialValue);
                }
                try {
                    Field field = clazz.getDeclaredField(this.reference);
                    this.builder.holder.add(new DataSignature<N>(field, this.handler, this.interpolation, this.initialValue, this.defaultKeyFrame, this.stateHolder));
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError("Invalid animation target [" + this.reference + "] for " + clazz.getName());
                }
            }
        }
    }
}

