/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.render.capes;

import de.dafuqs.spectrum.render.capes.CapeType;
import de.dafuqs.spectrum.render.capes.Players;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;

public class WorthinessChecker {
    private static final HashMap<UUID, Entry> PLAYER_MAP = new HashMap();

    public static CapeType getCapeType(UUID uuid) {
        return Optional.ofNullable(PLAYER_MAP.get(uuid)).map(entry -> entry.capeType).orElse(CapeType.NONE);
    }

    private static void putPlayer(UUID id, CapeType cape) {
        PLAYER_MAP.put(id, new Entry(id, cape));
    }

    public static void init() {
    }

    static {
        WorthinessChecker.putPlayer(Players.AZZY, CapeType.LUNAR);
        WorthinessChecker.putPlayer(Players.DAF, CapeType.UNDERGROUND_ASTRONOMY);
        WorthinessChecker.putPlayer(Players.KRAK, CapeType.LUCKY_STARS);
        WorthinessChecker.putPlayer(Players.DRA, CapeType.PALE_ASTRONOMY);
        WorthinessChecker.putPlayer(Players.OPL, CapeType.PALE_ASTRONOMY);
        WorthinessChecker.putPlayer(Players.MAYA, CapeType.PALE_ASTRONOMY);
        WorthinessChecker.putPlayer(Players.PIE, CapeType.V1);
        WorthinessChecker.putPlayer(Players.GUDY, CapeType.GUDY);
        WorthinessChecker.putPlayer(Players.REO, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.SOLLY, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.ASH, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.KALUCKY, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.JACK, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.SUNSETTE, CapeType.IMMORTAL);
        WorthinessChecker.putPlayer(Players.TWENTYFOUR, CapeType.IMMORTAL);
    }

    public record Entry(UUID playerId, CapeType capeType) {
    }
}

