/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.sound;

import de.dafuqs.spectrum.SpectrumCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class CraftingBlockSoundInstance
extends class_1102
implements class_1117 {
    private static List<CraftingBlockSoundInstance> playingSoundInstances = new ArrayList<CraftingBlockSoundInstance>();
    final class_5321<class_1937> worldKey;
    final class_2338 sourceBlockPos;
    final class_2248 sourceBlock;
    final int maxDurationTicks;
    private int ticksPlayed = 0;
    private boolean done;

    protected CraftingBlockSoundInstance(class_3414 soundEvent, class_5321<class_1937> worldKey, class_2338 sourceBlockPos, class_2248 sourceBlock, int maxDurationTicks) {
        super(soundEvent, class_3419.field_15245, class_1113.method_43221());
        this.worldKey = worldKey;
        this.sourceBlockPos = sourceBlockPos;
        this.sourceBlock = sourceBlock;
        this.maxDurationTicks = maxDurationTicks;
        this.field_5446 = true;
        this.field_5451 = 0;
        this.field_5439 = (double)sourceBlockPos.method_10263() + 0.5;
        this.field_5450 = (double)sourceBlockPos.method_10264() + 0.5;
        this.field_5449 = (double)sourceBlockPos.method_10260() + 0.5;
        this.updateVolume();
    }

    @Environment(value=EnvType.CLIENT)
    public static void startSoundInstance(class_3414 soundEvent, class_2338 sourceBlockPos, class_2248 sourceBlock, int maxDurationTicks) {
        class_310 client = class_310.method_1551();
        CraftingBlockSoundInstance.stopPlayingOnPos(sourceBlockPos);
        CraftingBlockSoundInstance newInstance = new CraftingBlockSoundInstance(soundEvent, (class_5321<class_1937>)client.field_1687.method_27983(), sourceBlockPos, sourceBlock, maxDurationTicks);
        playingSoundInstances.add(newInstance);
        class_310.method_1551().method_1483().method_4873((class_1113)newInstance);
    }

    public static void stopPlayingOnPos(class_2338 blockPos) {
        ArrayList<CraftingBlockSoundInstance> newInstances = new ArrayList<CraftingBlockSoundInstance>();
        for (CraftingBlockSoundInstance soundInstance : playingSoundInstances) {
            if (soundInstance.sourceBlockPos.equals((Object)blockPos)) {
                soundInstance.setDone();
                continue;
            }
            newInstances.add(soundInstance);
        }
        playingSoundInstances = newInstances;
    }

    public boolean method_4793() {
        return this.done;
    }

    public boolean method_4785() {
        return true;
    }

    private void updateVolume() {
        class_310 client = class_310.method_1551();
        this.field_5442 = Math.max(0.0f, 0.75f * (SpectrumCommon.CONFIG.BlockSoundVolume - (float)this.sourceBlockPos.method_19455((class_2382)client.field_1724.method_24515()) / 64.0f));
    }

    public void method_16896() {
        ++this.ticksPlayed;
        this.updateVolume();
        if (this.ticksPlayed == this.maxDurationTicks) {
            this.field_5442 /= 2.0f;
        }
        if (this.ticksPlayed > this.maxDurationTicks || !Objects.equals(this.worldKey, class_310.method_1551().field_1687.method_27983()) || this.shouldStopPlaying()) {
            playingSoundInstances.remove((Object)this);
            this.setDone();
        }
    }

    private boolean shouldStopPlaying() {
        class_310 client = class_310.method_1551();
        class_2680 blockState = client.field_1687.method_8320(this.sourceBlockPos);
        return !blockState.method_26204().equals(this.sourceBlock);
    }

    protected final void setDone() {
        this.ticksPlayed = this.maxDurationTicks;
        this.done = true;
        this.field_5446 = false;
    }
}

