/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.blocks.deeper_down.groundcover.AshPileBlock;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.worldgen.features.AshDunesFeatureConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import net.minecraft.class_6017;

public class AshDunesFeature
extends class_3031<AshDunesFeatureConfig> {
    private static final class_2758 LAYERS = AshPileBlock.field_11518;

    public AshDunesFeature(Codec<AshDunesFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<AshDunesFeatureConfig> context) {
        int i;
        class_2338 origin = context.method_33655();
        AshDunesFeatureConfig config = (AshDunesFeatureConfig)context.method_33656();
        class_5819 random = context.method_33654();
        class_5281 world = context.method_33652();
        boolean bias = random.method_43056();
        class_6017 spreadProvider = config.nodeSpread();
        class_5863 strengthProvider = config.emitterStrength();
        int nodeQuantity = config.nodeQuantity().method_35008(random);
        int cutoutQuantity = config.cutoutQuantity().method_35008(random);
        float decay = config.emitterDecayModifier();
        ArrayList<Emitter> emitters = new ArrayList<Emitter>();
        for (i = 0; i < nodeQuantity; ++i) {
            AshDunesFeature.generateEmitter(origin, false, bias, spreadProvider, random, world, emitters, strengthProvider.method_33920(random));
        }
        if (emitters.isEmpty()) {
            return false;
        }
        for (i = 0; i < cutoutQuantity; ++i) {
            AshDunesFeature.generateEmitter(origin, true, bias, spreadProvider, random, world, emitters, strengthProvider.method_33920(random) / 1.667f);
        }
        emitters.add(new Emitter(origin.method_25503(), strengthProvider.method_33920(random), false));
        int placementArea = spreadProvider.method_35011() + Math.round(strengthProvider.method_33921() / decay);
        Iterator iterator = class_2338.method_25996((class_2338)origin, (int)placementArea, (int)0, (int)placementArea).iterator();
        boolean anyPlaced = false;
        while (iterator.hasNext()) {
            int height;
            class_2338.class_2339 placementPos = ((class_2338)iterator.next()).method_25503();
            int originalY = placementPos.method_10264();
            if (!world.method_8320((class_2338)placementPos).method_27852(SpectrumBlocks.ASH_PILE) && !AshDunesFeature.canPlaceAt(world, (class_2338)placementPos) && !this.adjustPlacementHeight(world, placementPos, placementArea / 3) || (height = Math.round(this.getStrengthAt((class_2338)placementPos, origin, emitters, originalY, placementArea, decay, config.emitterCutoutModifier()))) <= 0) continue;
            this.placeAsh(world, placementPos, height);
            anyPlaced = true;
        }
        return anyPlaced;
    }

    private static void generateEmitter(class_2338 origin, boolean cutout, boolean bias, class_6017 spreadProvider, class_5819 random, class_5281 world, List<Emitter> emitters, float strength) {
        class_2338.class_2339 potentialNode = origin.method_10069(Math.round((float)(spreadProvider.method_35008(random) * (random.method_43056() ? 1 : -1)) * (bias ? 0.667f : 1.0f)), 0, Math.round((float)(spreadProvider.method_35008(random) * (random.method_43056() ? 1 : -1)) * (!bias ? 0.667f : 1.0f))).method_25503();
        if (world.method_8320((class_2338)potentialNode).method_26215() && world.method_8320(potentialNode.method_10069(0, -1, 0)).method_26215() && !world.method_8320(potentialNode.method_10069(0, -2, 0)).method_26215()) {
            emitters.add(new Emitter(potentialNode.method_10100(0, -1, 0), strength, cutout));
            return;
        }
        while (!world.method_8320((class_2338)potentialNode).method_26215()) {
            potentialNode.method_10100(0, 1, 0);
            if (world.method_8320((class_2338)potentialNode).method_26215()) {
                emitters.add(new Emitter(potentialNode, strength, cutout));
                break;
            }
            if (potentialNode.method_10264() - origin.method_10264() <= spreadProvider.method_35011() / 2) continue;
            break;
        }
    }

    private void placeAsh(class_5281 world, class_2338.class_2339 pos, int height) {
        class_2680 state = world.method_8320((class_2338)pos);
        if (state.method_27852(SpectrumBlocks.ASH_PILE)) {
            Integer layers = (Integer)state.method_11654((class_2769)LAYERS);
            int layerDif = 8 - layers;
            if (height >= layerDif) {
                this.placeAshBlock(world, pos, 8);
                if ((height -= layerDif) == 0) {
                    return;
                }
            } else {
                this.placeAshBlock(world, pos, layers + height);
                return;
            }
            pos.method_10098(class_2350.field_11036);
        }
        if (height <= 8) {
            this.placeAshBlock(world, pos, height);
            return;
        }
        while (height > 0) {
            if (height > 8) {
                this.placeAshBlock(world, pos, 8);
                pos.method_10098(class_2350.field_11036);
                height -= 8;
                continue;
            }
            this.placeAshBlock(world, pos, height);
            height = 0;
        }
    }

    private void placeAshBlock(class_5281 world, class_2338.class_2339 pos, int height) {
        if (height == 8) {
            this.method_13153((class_1945)world, (class_2338)pos, SpectrumBlocks.ASH.method_9564());
        } else {
            this.method_13153((class_1945)world, (class_2338)pos, (class_2680)SpectrumBlocks.ASH_PILE.method_9564().method_11657((class_2769)LAYERS, (Comparable)Integer.valueOf(height)));
        }
    }

    private float getStrengthAt(class_2338 pos, class_2338 origin, List<Emitter> emitters, int originalY, float maxArea, float decay, float cutoutDecay) {
        float strength = 0.0f;
        for (Emitter emitter : emitters) {
            if (emitter.cutout) {
                float cutoutStrength = (float)Math.sqrt(pos.method_10262((class_2382)emitter.pos));
                cutoutStrength *= -cutoutDecay;
                if (!((cutoutStrength += emitter.strength) > 0.0f)) continue;
                strength -= cutoutStrength;
                continue;
            }
            float emitterStrength = (float)Math.sqrt(pos.method_10262((class_2382)emitter.pos));
            emitterStrength *= -decay;
            if (!((emitterStrength += emitter.strength) > 0.0f)) continue;
            strength += emitterStrength;
        }
        strength = (float)class_3532.method_15390((double)strength, (double)0.0, (double)(Math.sqrt(pos.method_10262((class_2382)origin)) / (double)maxArea));
        return strength;
    }

    private boolean adjustPlacementHeight(class_5281 world, class_2338.class_2339 pos, int maxShifts) {
        boolean foundValidSpace = false;
        for (int shifts = 1; shifts < maxShifts + 1; ++shifts) {
            class_2338 upPos = pos.method_10069(0, shifts, 0);
            if (AshDunesFeature.canPlaceAt(world, upPos) || world.method_8320((class_2338)pos).method_27852(SpectrumBlocks.ASH_PILE)) {
                pos.method_10100(0, shifts, 0);
                foundValidSpace = true;
                break;
            }
            class_2338 downPos = pos.method_10069(0, -shifts, 0);
            if (!AshDunesFeature.canPlaceAt(world, downPos) && !world.method_8320((class_2338)pos).method_27852(SpectrumBlocks.ASH_PILE)) continue;
            pos.method_10100(0, -shifts, 0);
            foundValidSpace = true;
            break;
        }
        return foundValidSpace;
    }

    private static boolean canPlaceAt(class_5281 world, class_2338 pos) {
        return (world.method_22347(pos) || world.method_8320(pos).method_27852(SpectrumBlocks.VARIA_SPROUT)) && SpectrumBlocks.ASH_PILE.method_9564().method_26184((class_4538)world, pos);
    }

    private record Emitter(class_2338.class_2339 pos, float strength, boolean cutout) {
    }
}

