/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.worldgen.features.ColumnsFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class ColumnsFeature
extends class_3031<ColumnsFeatureConfig> {
    private static final ImmutableList<class_2248> CANNOT_REPLACE_BLOCKS = ImmutableList.of((Object)class_2246.field_9987, (Object)class_2246.field_10034, (Object)class_2246.field_10260, (Object)SpectrumBlocks.DOWNSTONE);
    private static final int BIG_MAX_OFFSET = 5;
    private static final int BIG_COUNT = 50;
    private static final int SMALL_MAX_OFFSET = 8;
    private static final int SMALL_COUNT = 15;

    public ColumnsFeature(Codec<ColumnsFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<ColumnsFeatureConfig> context) {
        int i = context.method_33653().method_16398();
        class_2338 blockPos = context.method_33655();
        class_5281 structureWorldAccess = context.method_33652();
        class_5819 random = context.method_33654();
        ColumnsFeatureConfig config = (ColumnsFeatureConfig)context.method_33656();
        if (!ColumnsFeature.canPlaceAt((class_1936)structureWorldAccess, i, blockPos.method_25503())) {
            return false;
        }
        int j = config.height().method_35008(random);
        boolean big = random.method_43057() < 0.9f;
        int max_offset = Math.min(j, big ? 5 : 8);
        int count = big ? 50 : 15;
        boolean success = false;
        for (class_2338 blockPos2 : class_2338.method_27156((class_5819)random, (int)count, (int)(blockPos.method_10263() - max_offset), (int)blockPos.method_10264(), (int)(blockPos.method_10260() - max_offset), (int)(blockPos.method_10263() + max_offset), (int)blockPos.method_10264(), (int)(blockPos.method_10260() + max_offset))) {
            int m = j - blockPos2.method_19455((class_2382)blockPos);
            if (m < 0) continue;
            success |= this.placeColumn((class_1936)structureWorldAccess, i, blockPos2, m, config.reach().method_35008(random), config.blockState());
        }
        return success;
    }

    /*
     * Unable to fully structure code
     */
    private boolean placeColumn(class_1936 world, int seaLevel, class_2338 pos, int height, int reach, class_2680 blockState) {
        success = false;
        it = class_2338.method_10094((int)(pos.method_10263() - reach), (int)pos.method_10264(), (int)(pos.method_10260() - reach), (int)(pos.method_10263() + reach), (int)pos.method_10264(), (int)(pos.method_10260() + reach)).iterator();
        block0: while (true) {
            if (!it.hasNext()) {
                return success;
            }
            blockPos = (class_2338)it.next();
            manhattanDistanceFromOrigin = blockPos.method_19455((class_2382)pos);
            currPos = ColumnsFeature.isReplaceable(world, seaLevel, blockPos) != false ? ColumnsFeature.moveDownToGround(world, seaLevel, blockPos.method_25503(), manhattanDistanceFromOrigin) : ColumnsFeature.moveUpToAir(world, blockPos.method_25503(), manhattanDistanceFromOrigin);
            if (currPos == null) continue;
            j = height - manhattanDistanceFromOrigin / 2;
            mutable = currPos.method_25503();
            while (true) {
                if (j < 0) continue block0;
                if (ColumnsFeature.isReplaceable(world, seaLevel, (class_2338)mutable)) {
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                    mutable.method_10098(class_2350.field_11036);
                    success = true;
                } else {
                    if (world.method_8320((class_2338)mutable).method_27852(blockState.method_26204())) ** break;
                    continue block0;
                    mutable.method_10098(class_2350.field_11036);
                }
                --j;
            }
            break;
        }
    }

    @Nullable
    private static class_2338 moveDownToGround(class_1936 world, int seaLevel, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() > world.method_31607() + 1 && distance > 0) {
            --distance;
            if (ColumnsFeature.canPlaceAt(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_1936 world, int seaLevel, class_2338.class_2339 mutablePos) {
        if (!ColumnsFeature.isReplaceable(world, seaLevel, (class_2338)mutablePos)) {
            return false;
        }
        class_2680 blockState = world.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033));
        mutablePos.method_10098(class_2350.field_11036);
        return !blockState.method_26215() && !blockState.method_26164(SpectrumBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES) && !CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204());
    }

    @Nullable
    private static class_2338 moveUpToAir(class_1936 world, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() < world.method_31600() && distance > 0) {
            --distance;
            class_2680 blockState = world.method_8320((class_2338)mutablePos);
            if (CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204())) {
                return null;
            }
            if (blockState.method_26215() || blockState.method_26164(SpectrumBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES)) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isReplaceable(class_1936 world, int seaLevel, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_26164(SpectrumBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES) || !blockState.method_26227().method_15769() && pos.method_10264() <= seaLevel;
    }
}

