/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.components.InkPoweredComponent;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;

public class InkPoweredStatusEffectInstance {
    public static final Codec<InkPoweredStatusEffectInstance> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_1293.field_48821.fieldOf("effect").forGetter(c -> c.statusEffectInstance), (App)InkCost.CODEC.fieldOf("ink_cost").forGetter(c -> c.cost), (App)Codec.INT.optionalFieldOf("custom_color", (Object)-1).forGetter(c -> c.customColor), (App)Codec.BOOL.optionalFieldOf("unidentifiable", (Object)false).forGetter(c -> c.unidentifiable)).apply((Applicative)i, InkPoweredStatusEffectInstance::new));
    public static final class_9139<class_9129, InkPoweredStatusEffectInstance> PACKET_CODEC = class_9139.method_56905((class_9139)class_1293.field_49207, c -> c.statusEffectInstance, InkCost.PACKET_CODEC, c -> c.cost, (class_9139)class_9135.field_48550, c -> c.customColor, (class_9139)class_9135.field_48547, c -> c.unidentifiable, InkPoweredStatusEffectInstance::new);
    private final class_1293 statusEffectInstance;
    private final InkCost cost;
    private final int customColor;
    private final boolean unidentifiable;

    public InkPoweredStatusEffectInstance(class_1293 statusEffectInstance, InkCost cost, int customColor, boolean unidentifiable) {
        this.statusEffectInstance = statusEffectInstance;
        this.cost = cost;
        this.customColor = customColor;
        this.unidentifiable = unidentifiable;
    }

    public class_1293 getStatusEffectInstance() {
        return this.statusEffectInstance;
    }

    public InkCost getInkCost() {
        return this.cost;
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(class_1799 stack) {
        return ((InkPoweredComponent)stack.method_57825(SpectrumDataComponentTypes.INK_POWERED, (Object)InkPoweredComponent.DEFAULT)).effects();
    }

    public static void setEffects(class_1799 stack, List<InkPoweredStatusEffectInstance> effects) {
        stack.method_57379(SpectrumDataComponentTypes.INK_POWERED, (Object)new InkPoweredComponent(effects));
    }

    public static void buildTooltip(List<class_2561> tooltip, List<InkPoweredStatusEffectInstance> effects, class_5250 attributeModifierText, boolean showDuration, float tickRate) {
        if (!effects.isEmpty()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (InkPoweredStatusEffectInstance entry : effects) {
                if (entry.isUnidentifiable()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion.tooltip.unidentifiable"));
                    continue;
                }
                class_1293 effect = entry.getStatusEffectInstance();
                if (effect == null) continue;
                InkCost cost = entry.getInkCost();
                class_5250 mutableText = class_2561.method_43471((String)effect.method_5586());
                if (effect.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
                }
                if (showDuration && effect.method_5584() > 20) {
                    mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)effect, (float)1.0f, (float)tickRate)});
                }
                mutableText.method_27692(((class_1291)effect.method_5579().comp_349()).method_18792().method_18793());
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_cost", (Object[])new Object[]{Support.getShortenedNumberString(cost.cost()), cost.color().getColoredInkName()}).method_27692(class_124.field_1080));
                if (entry.statusEffectInstance.spectrum$isSevere()) {
                    mutableText.method_10852((class_2561)class_2561.method_43471((String)"item.spectrum.potion.tooltip.severe"));
                }
                tooltip.add((class_2561)mutableText);
                ((class_1291)effect.method_5579().comp_349()).method_55650(effect.method_5578(), (attribute, modifier) -> attributeModifiers.add(new class_3545(attribute, modifier)));
            }
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)attributeModifierText.method_27692(class_124.field_1064));
                for (class_3545 pair : attributeModifiers) {
                    class_5250 translatedAttribute = class_2561.method_43471((String)((class_1320)((class_6880)pair.method_15442()).comp_349()).method_26830());
                    class_1322 mutableText = (class_1322)pair.method_15441();
                    double statusEffect = mutableText.comp_2449();
                    double d = mutableText.comp_2450() != class_1322.class_1323.field_6330 && mutableText.comp_2450() != class_1322.class_1323.field_6331 ? mutableText.comp_2449() : mutableText.comp_2449() * 100.0;
                    if (statusEffect > 0.0) {
                        tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + mutableText.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(d), translatedAttribute}).method_27692(class_124.field_1078));
                        continue;
                    }
                    if (!(statusEffect < 0.0)) continue;
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + mutableText.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(d *= -1.0), translatedAttribute}).method_27692(class_124.field_1061));
                }
            }
        }
    }

    public int getColor() {
        if (this.customColor == -1) {
            return ((class_1291)this.statusEffectInstance.method_5579().comp_349()).method_5556();
        }
        return this.customColor;
    }

    public boolean isUnidentifiable() {
        return this.unidentifiable;
    }
}

