/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.recipe;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class FluidIngredient {
    public static final MapCodec<FluidIngredient> MAP_CODEC = Codec.mapEither((MapCodec)class_7923.field_41173.method_39673().fieldOf("fluid"), (MapCodec)class_2960.field_25139.fieldOf("tag")).xmap(FluidIngredient::new, c -> c.ingredient);
    public static final Codec<FluidIngredient> CODEC = Codec.withAlternative((Codec)Codec.withAlternative((Codec)class_7923.field_41173.method_39673().xmap(FluidIngredient::of, ingredient -> ingredient.fluid().get()), (Codec)class_6862.method_40093((class_5321)class_7924.field_41270).xmap(FluidIngredient::of, ingredient -> ingredient.tag().get())), (Codec)MAP_CODEC.codec());
    public static final class_9139<class_9129, FluidIngredient> PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.method_57995((class_9139)class_9135.method_56365((class_5321)class_7924.field_41270), (class_9139)class_2960.field_48267), o -> o.ingredient, FluidIngredient::new);
    private final Either<class_3611, class_2960> ingredient;
    public static FluidIngredient EMPTY = new FluidIngredient((Either<class_3611, class_2960>)Either.left((Object)class_3612.field_15906));

    private FluidIngredient(Either<class_3611, class_2960> ingredient) {
        this.ingredient = ingredient;
    }

    public String toString() {
        if (this == EMPTY) {
            return "FluidIngredient.EMPTY";
        }
        if (this.ingredient.left().isPresent()) {
            return String.format("FluidIngredient[fluid=%s]", this.ingredient.left().get());
        }
        assert (this.ingredient.right().isPresent());
        return String.format("FluidIngredient[tag=%s]", this.ingredient.right().get());
    }

    public static FluidIngredient of(@NotNull class_3611 fluid) {
        return new FluidIngredient((Either<class_3611, class_2960>)Either.left((Object)fluid));
    }

    public static FluidIngredient of(@NotNull class_6862<class_3611> tag) {
        return new FluidIngredient((Either<class_3611, class_2960>)Either.right((Object)tag.comp_327()));
    }

    public static FluidIngredient of(@NotNull class_2960 tag) {
        return new FluidIngredient((Either<class_3611, class_2960>)Either.right((Object)tag));
    }

    public Optional<class_3611> fluid() {
        return this.ingredient.left();
    }

    public Optional<class_6862<class_3611>> tag() {
        return this.ingredient.right().flatMap(tag -> class_7923.field_41173.method_40273().filter(tagKey -> tagKey.comp_327().equals(tag)).findFirst());
    }

    public boolean isTag() {
        return this.ingredient.right().isPresent();
    }

    public class_2960 id() {
        return (class_2960)this.ingredient.map(arg_0 -> ((class_7922)class_7923.field_41173).method_10221(arg_0), tag -> tag);
    }

    @NotNull
    public class_1856 into() {
        return (class_1856)this.ingredient.map(fluid -> fluid == class_3612.field_15906 ? class_1856.field_9017 : class_1856.method_8101((class_1799[])new class_1799[]{fluid.method_15774().method_7854()}), tag -> {
            class_7922 registry = class_7923.field_41173;
            if (registry == null) {
                return class_1856.method_35226();
            }
            Optional optional = registry.method_40266(this.tag().get());
            if (optional.isEmpty()) {
                return class_1856.method_35226();
            }
            class_6885.class_6888 list = (class_6885.class_6888)optional.get();
            Stream<class_1799> stacks = list.method_40239().map(entry -> ((class_3611)entry.comp_349()).method_15774().method_7854());
            return class_1856.method_26964(stacks);
        });
    }

    public boolean test(@NotNull class_3611 fluid) {
        return (Boolean)this.ingredient.map(fl -> fl == fluid, tag -> fluid.method_15785().method_15767(this.tag().get()));
    }

    public boolean test(@NotNull FluidVariant variant) {
        return this.test(variant.getFluid());
    }
}

