/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.bottomless_bundle;

import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class BottomlessBundleBlockEntity
extends class_2586 {
    private class_1799 bottomlessBundleStack;
    private boolean isVoiding;
    protected int powerLevel;
    public final SingleVariantStorage<ItemVariant> storage = new SingleVariantStorage<ItemVariant>(){

        protected boolean canInsert(ItemVariant variant) {
            return variant.getItem().method_31568() && (((ItemVariant)this.variant).isBlank() || ((ItemVariant)this.variant).isOf((Object)variant.getItem()) && class_1799.method_31577((class_1799)((ItemVariant)this.variant).toStack(), (class_1799)variant.toStack()));
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
            return BottomlessBundleBlockEntity.this.isVoiding ? maxAmount : inserted;
        }

        protected ItemVariant getBlankVariant() {
            return this.variant == null ? ItemVariant.blank() : (ItemVariant)this.variant;
        }

        protected long getCapacity(ItemVariant variant) {
            return BottomlessBundleItem.getMaxStoredAmount(BottomlessBundleBlockEntity.this.powerLevel);
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            BottomlessBundleBlockEntity.this.method_5431();
        }
    };

    public BottomlessBundleBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.BOTTOMLESS_BUNDLE, pos, state);
        this.bottomlessBundleStack = SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389().method_7854();
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.setBundleUnsynced(class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Bundle")).orElse(SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389().method_7854()), registryLookup);
        this.syncStorageWithBundle();
    }

    private void syncBundleWithStorage() {
        BottomlessBundleItem.BottomlessStack.Builder builder = BottomlessBundleItem.BottomlessStack.Builder.of(this.field_11863, this.bottomlessBundleStack);
        builder.set(this.storage);
        builder.buildAndSet(this.bottomlessBundleStack);
    }

    private void syncStorageWithBundle() {
        this.storage.variant = BottomlessBundleItem.getTemplateVariant(this.bottomlessBundleStack);
        this.storage.amount = BottomlessBundleItem.getStoredAmount(this.bottomlessBundleStack);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.syncBundleWithStorage();
        nbt.method_10566("Bundle", this.bottomlessBundleStack.method_57375(registryLookup));
    }

    private boolean setBundleUnsynced(class_1799 itemStack, class_7225.class_7874 registryLookup) {
        if (itemStack.method_7909() instanceof BottomlessBundleItem) {
            this.bottomlessBundleStack = itemStack;
            this.isVoiding = class_1890.method_60138((class_1799)this.bottomlessBundleStack, SpectrumEnchantmentTags.DELETES_OVERFLOW);
            this.powerLevel = class_1890.method_8225((class_6880)registryLookup.method_46759(class_7924.field_41265).flatMap(impl -> impl.method_46746(class_1893.field_9103)).orElse(null), (class_1799)itemStack);
            return true;
        }
        return false;
    }

    public void setBundle(@NotNull class_1799 itemStack, class_7225.class_7874 registryLookup) {
        if (this.setBundleUnsynced(itemStack, registryLookup)) {
            this.syncStorageWithBundle();
        }
    }

    public class_1799 retrieveBundle() {
        if (this.bottomlessBundleStack.method_7960()) {
            return SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389().method_7854();
        }
        this.syncBundleWithStorage();
        return this.bottomlessBundleStack;
    }
}

