/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class CompactingChestBlockEntityRenderer
implements class_827<CompactingChestBlockEntity> {
    private static final class_4730 SPRITE_IDENTIFIER = new class_4730(class_1723.field_21668, SpectrumCommon.locate("block/compacting_chest"));
    private final class_630 root;
    private final class_630 driver;
    private final class_630 piston;
    private final class_630 cap;

    public CompactingChestBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_5607 texturedModelData = CompactingChestBlockEntityRenderer.getTexturedModelData();
        this.root = texturedModelData.method_32109();
        class_630 fakeRoot = this.root.method_32086("root");
        this.driver = fakeRoot.method_32086("driver");
        this.piston = fakeRoot.method_32086("piston");
        this.cap = fakeRoot.method_32086("cap");
    }

    @NotNull
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 root = modelPartData.method_32117("root", class_5606.method_32108().method_32101(81, 44).method_32098(-1.5f, -10.0f, -1.5f, 3.0f, 9.0f, 3.0f, new class_5605(0.0f)).method_32101(0, 0).method_32098(-7.0f, -11.0f, -7.0f, 14.0f, 10.0f, 14.0f, new class_5605(0.0f)).method_32101(0, 60).method_32098(-5.0f, -11.0f, -5.0f, 10.0f, 10.0f, 10.0f, new class_5605(0.0f)).method_32101(0, 43).method_32098(-7.5f, -2.0f, -7.5f, 15.0f, 2.0f, 15.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 driver = root.method_32117("driver", class_5606.method_32108().method_32101(53, 38).method_32098(-3.5f, -36.0f, -3.5f, 7.0f, 11.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)21.0f, (float)0.0f));
        class_5610 piston = root.method_32117("piston", class_5606.method_32108().method_32101(89, 17).method_32098(-3.5f, 7.0f, -3.5f, 7.0f, 14.0f, 7.0f, new class_5605(0.0f)).method_32101(45, 13).method_32098(-5.5f, 7.0f, -5.5f, 11.0f, 14.0f, 11.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-22.0f, (float)0.0f));
        class_5610 cap = root.method_32117("cap", class_5606.method_32108().method_32101(0, 24).method_32098(-7.5f, -36.0f, -7.5f, 15.0f, 4.0f, 15.0f, new class_5605(0.0f)).method_32101(40, 65).method_32098(-5.5f, -36.0f, -5.5f, 11.0f, 4.0f, 11.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)21.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }

    public void render(CompactingChestBlockEntity chest, float tickDelta, class_4587 poseStack, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = chest.method_10997();
        boolean bl = world != null;
        class_2680 blockState = bl ? chest.method_11010() : (class_2680)SpectrumBlocks.COMPACTING_CHEST.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        poseStack.method_22903();
        float f = blockState.method_28498((class_2769)class_2281.field_10768) ? ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144() : 0.0f;
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        switch (chest.getState()) {
            case OPEN: {
                chest.pistonTarget = 14.0f;
                chest.driverTarget = 6.0f;
                chest.capTarget = 5.0f;
                break;
            }
            case CRAFTING: {
                chest.pistonTarget = (float)(Math.sin(((float)(chest.activeTicks % 500000L) + tickDelta) / 10.0f) * 5.0 + 4.0);
                chest.driverTarget = (float)(Math.sin(((float)((chest.activeTicks + 13L) % 500000L) + tickDelta) / 10.0f) * 5.0 + 5.0);
                chest.capTarget = 0.0f;
                break;
            }
            case CLOSED: {
                chest.pistonTarget = 0.0f;
                chest.driverTarget = 0.0f;
                chest.capTarget = 0.0f;
            }
        }
        float interp = class_3532.method_15363((float)(((float)chest.interpTicks + tickDelta) / (float)chest.interpLength), (float)0.0f, (float)1.0f);
        chest.pistonPos = class_3532.method_16439((float)interp, (float)chest.lastPistonTarget, (float)chest.pistonTarget);
        chest.driverPos = class_3532.method_16439((float)interp, (float)chest.lastDriverTarget, (float)chest.driverTarget);
        chest.capPos = class_3532.method_16439((float)interp, (float)chest.lastCapTarget, (float)chest.capTarget);
        this.piston.field_3656 = -22.0f - chest.pistonPos;
        this.driver.field_3656 = 21.0f - chest.driverPos;
        this.cap.field_3656 = 21.0f - chest.capPos;
        class_4588 vertexConsumer = SPRITE_IDENTIFIER.method_24145(vertexConsumers, class_1921::method_23578);
        this.root.method_22698(poseStack, vertexConsumer, light, overlay);
        poseStack.method_22909();
    }
}

