/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.chests.FabricationChestBlockEntity;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FabricationChestBlockEntityRenderer
implements class_827<FabricationChestBlockEntity> {
    private static final class_4730 spriteIdentifier = new class_4730(class_1723.field_21668, SpectrumCommon.locate("block/fabrication_chest"));
    private final class_630 rootNode;
    private final class_630 root;
    private final class_630 rim;
    private final class_630 crafting_tablet;
    private final class_630 assembly;
    private final class_630 rings;

    public FabricationChestBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_5607 texturedModelData = FabricationChestBlockEntityRenderer.getTexturedModelData();
        this.rootNode = texturedModelData.method_32109();
        this.root = this.rootNode.method_32086("root");
        this.rim = this.root.method_32086("rim");
        this.crafting_tablet = this.root.method_32086("crafting_tablet");
        this.assembly = this.root.method_32086("assembly");
        this.rings = this.root.method_32086("rings");
    }

    @NotNull
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 root = modelPartData.method_32117("root", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        root.method_32117("rim", class_5606.method_32108().method_32101(0, 0).method_32098(-8.0f, -3.0f, -8.0f, 16.0f, 4.0f, 16.0f, new class_5605(0.0f)).method_32101(52, 49).method_32098(-6.0f, -3.0f, -6.0f, 12.0f, 4.0f, 12.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-9.0f, (float)0.0f));
        root.method_32117("crafting_tablet", class_5606.method_32108().method_32101(48, 0).method_32098(-6.5f, 2.0f, -8.5f, 13.0f, 3.0f, 13.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-15.0f, (float)2.0f));
        root.method_32117("assembly", class_5606.method_32108().method_32101(0, 0).method_32098(-1.5f, -4.0f, -1.5f, 3.0f, 8.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-6.0f, (float)0.0f));
        root.method_32117("rings", class_5606.method_32108().method_32101(-13, 60).method_32098(-6.5f, 1.25f, -6.5f, 13.0f, 0.0f, 13.0f, new class_5605(0.0f)).method_32101(41, 65).method_32098(-5.5f, -1.25f, -5.5f, 11.0f, 0.0f, 11.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-17.25f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }

    public void render(FabricationChestBlockEntity chest, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        List<class_1799> outputs;
        class_1937 world = chest.method_10997();
        boolean bl = world != null;
        class_2680 blockState = bl ? chest.method_11010() : (class_2680)SpectrumBlocks.FABRICATION_CHEST.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        matrices.method_22903();
        float f = blockState.method_28498((class_2769)class_2281.field_10768) ? ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144() : 0.0f;
        matrices.method_22904(0.5, 1.5, 0.5);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        long time = chest.getRenderTime();
        float transform = (float)Math.sin(((float)time + tickDelta) / 13.0f);
        switch (chest.getState()) {
            case FULL: {
                chest.tabletTarget = 0.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 0.0f;
                chest.ringTarget = 0.0f;
                chest.itemTarget = 0.0f;
                chest.alphaTarget = 0.0f;
                chest.yawModTarget = 0.0f;
                break;
            }
            case CLOSED_CRAFTING: {
                chest.tabletTarget = 2.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 2.0f;
                chest.ringTarget = 2.0f + transform;
                chest.itemTarget = 12.0f + transform * 1.5f;
                chest.alphaTarget = 0.667f;
                chest.yawModTarget = 0.334f;
                break;
            }
            case CLOSED: {
                chest.tabletTarget = 0.0f;
                chest.rimTarget = 0.0f;
                chest.assemblyTarget = 1.0f;
                chest.ringTarget = 0.5f + transform / 2.5f;
                chest.itemTarget = 9.5f + transform / 2.125f;
                chest.alphaTarget = 0.2f;
                chest.yawModTarget = 0.05f;
                break;
            }
            case OPEN_CRAFTING: {
                chest.tabletTarget = 5.0f;
                chest.rimTarget = 7.0f;
                chest.assemblyTarget = 5.0f;
                chest.ringTarget = 6.25f + transform / 1.664f;
                chest.itemTarget = 15.25f + transform / 1.334f;
                chest.alphaTarget = 0.4f;
                chest.yawModTarget = 0.175f;
                break;
            }
            case OPEN: {
                chest.tabletTarget = 5.0f;
                chest.rimTarget = 7.0f;
                chest.assemblyTarget = 5.0f;
                chest.ringTarget = 5.25f + transform / 2.5f;
                chest.itemTarget = 13.25f + transform / 2.4f;
                chest.yawModTarget = 0.05f;
            }
        }
        float interp = class_3532.method_15363((float)(((float)chest.interpTicks + tickDelta) / (float)chest.interpLength), (float)0.0f, (float)1.0f);
        chest.tabletPos = class_3532.method_16439((float)interp, (float)chest.lastTabletTarget, (float)chest.tabletTarget);
        chest.rimPos = class_3532.method_16439((float)interp, (float)chest.lastRimTarget, (float)chest.rimTarget);
        chest.assemblyPos = class_3532.method_16439((float)interp, (float)chest.lastAssemblyTarget, (float)chest.assemblyTarget);
        chest.ringPos = class_3532.method_16439((float)interp, (float)chest.lastRingTarget, (float)chest.ringTarget);
        chest.itemPos = class_3532.method_16439((float)interp, (float)chest.lastItemTarget, (float)chest.itemTarget);
        chest.alphaValue = class_3532.method_16439((float)interp, (float)chest.lastAlphaTarget, (float)chest.alphaTarget);
        chest.yawMod = class_3532.method_16439((float)interp, (float)chest.lastYawModTarget, (float)chest.yawModTarget);
        this.rim.field_3656 = 15.0f - chest.rimPos;
        this.crafting_tablet.field_3656 = 9.0f - chest.tabletPos;
        this.assembly.field_3656 = 18.0f - chest.assemblyPos;
        this.rings.field_3656 = 6.75f - chest.ringPos;
        this.rings.field_3675 = class_3532.method_16439((float)tickDelta, (float)chest.lastYaw, (float)chest.yaw);
        class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, class_1921::method_23580);
        this.rim.method_22698(matrices, vertexConsumer, light, overlay);
        this.crafting_tablet.method_22698(matrices, vertexConsumer, light, overlay);
        if (chest.rimPos > 0.01f) {
            this.assembly.method_22698(matrices, vertexConsumer, light, overlay);
        }
        if (chest.alphaValue > 0.01f) {
            this.rings.method_22699(matrices, vertexConsumer, 0xF000F0, overlay, class_5253.class_5254.method_59554((float)chest.alphaValue, (float)1.0f, (float)1.0f, (float)1.0f));
        }
        if ((outputs = chest.getRecipeOutputs()).isEmpty()) {
            matrices.method_22909();
            return;
        }
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotation(-this.rings.field_3675));
        matrices.method_22904(0.0, -1.5 + (12.5 + (double)chest.itemPos) / 16.0, 0.0);
        matrices.method_22905(0.8f, 0.8f, 0.8f);
        if (outputs.size() == 1) {
            class_310.method_1551().method_1480().method_23177(null, outputs.getFirst(), class_811.field_4318, false, matrices, vertexConsumers, world, light, overlay, 0);
        } else {
            float rotation = 360.0f / (float)outputs.size();
            for (class_1799 output : outputs) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));
                matrices.method_46416(0.4f, 0.0f, 0.0f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(this.rings.field_3675 * 0.8f));
                class_310.method_1551().method_1480().method_23177(null, output, class_811.field_4318, false, matrices, vertexConsumers, world, light, overlay, 0);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-this.rings.field_3675 * 0.8f));
                matrices.method_46416(-0.4f, 0.0f, 0.0f);
            }
        }
        matrices.method_22909();
    }
}

