/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.chests.HeartboundChestBlockEntity;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlock;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class HeartboundChestBlock
extends SpectrumChestBlock {
    public static final MapCodec<HeartboundChestBlock> CODEC = HeartboundChestBlock.method_54094(HeartboundChestBlock::new);

    public HeartboundChestBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HeartboundChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? HeartboundChestBlock.method_31618(type, SpectrumBlockEntities.HEARTBOUND_CHEST, SpectrumChestBlockEntity::clientTick) : null;
    }

    @Override
    public void openScreen(class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            if (!heartboundChestBlockEntity.hasOwner()) {
                heartboundChestBlockEntity.setOwner(player);
            }
            if (!HeartboundChestBlock.isChestBlocked((class_1936)world, pos)) {
                player.method_17355((class_3908)heartboundChestBlockEntity);
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            if (placer instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)placer;
                heartboundChestBlockEntity.setOwner((class_1657)serverPlayerEntity);
            }
        }
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            if (((HeartboundChestBlockEntity)blockEntity).wasRecentlyTriedToOpenByNonOwner()) {
                return 15;
            }
            int lookingPlayers = HeartboundChestBlockEntity.getPlayersLookingInChestCount(world, pos);
            if (lookingPlayers > 0) {
                return 7;
            }
        }
        return 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return direction == class_2350.field_11036 ? state.method_26195(world, pos, direction) : 0;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        HeartboundChestBlockEntity heartboundChestBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity && (heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity).canBreak(player.method_5667())) {
            float hardness = 20.0f;
            int i = player.method_7305(state) ? 30 : 100;
            return player.method_7351(state) / hardness / (float)i;
        }
        return -1.0f;
    }

    public float method_36555() {
        return -1.0f;
    }
}

