/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.cinderhearth;

import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.api.item.ExperienceStorageItem;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.blocks.CraftingDelegate;
import de.dafuqs.spectrum.blocks.cinderhearth.CinderhearthBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.components.InkStorageComponent;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.inventories.CinderhearthScreenHandler;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.cinderhearth.CinderhearthRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3859;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CinderhearthBlockEntity
extends class_2624
implements MultiblockCrafter,
class_1278,
ExtendedScreenHandlerFactory<class_2338>,
InkStorageBlockEntity<IndividualCappedInkStorage>,
class_1737 {
    public static final int INVENTORY_SIZE = 11;
    public static final int INPUT_SLOT_ID = 0;
    public static final int INK_PROVIDER_SLOT_ID = 1;
    public static final int EXPERIENCE_STORAGE_ITEM_SLOT_ID = 2;
    public static final int FIRST_OUTPUT_SLOT_ID = 3;
    public static final int LAST_OUTPUT_SLOT_ID = 10;
    public static final int[] OUTPUT_SLOT_IDS = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
    protected class_2371<class_1799> inventory;
    protected boolean inventoryChanged;
    public static final List<InkColor> USED_INK_COLORS = List.of(InkColors.ORANGE, InkColors.MAGENTA, InkColors.LIGHT_BLUE, InkColors.PURPLE, InkColors.BLACK);
    public static final long INK_STORAGE_SIZE = 102400L;
    public static final long INK_COST_PER_TICK = 8L;
    protected IndividualCappedInkStorage inkStorage;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private class_8786<?> currentRecipe;
    private boolean usesEfficiency;
    protected boolean canTransferInk;
    protected boolean inkDirty;
    protected CinderHearthStructureType structure = CinderHearthStructureType.NONE;
    protected final CraftingDelegate propertyDelegate = new CraftingDelegate();

    public int[] method_5494(class_2350 side) {
        switch (side) {
            case field_11036: {
                return new int[]{0};
            }
            case field_11033: {
                return OUTPUT_SLOT_IDS;
            }
        }
        return new int[]{1, 2};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        switch (slot) {
            case 1: {
                InkStorageItem inkStorageItem;
                class_1792 class_17922 = stack.method_7909();
                return class_17922 instanceof InkStorageItem && (inkStorageItem = (InkStorageItem)class_17922).getDrainability().canDrain(false);
            }
            case 2: {
                return stack.method_7909() instanceof ExperienceStorageItem;
            }
        }
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 3;
    }

    public CinderhearthBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.CINDERHEARTH, pos, state);
        this.inventory = class_2371.method_10213((int)11, (Object)class_1799.field_8037);
        this.inkStorage = new IndividualCappedInkStorage(102400L, USED_INK_COLORS);
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        if (this.field_11863 == null) {
            return;
        }
        this.upgrades = Upgradeable.calculateUpgradeMods2(this.field_11863, this.field_11867, Support.rotationFromDirection((class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)CinderhearthBlock.FACING)), 2, 1, 1, this.ownerUUID);
        this.updateInClientWorld();
        this.method_5431();
    }

    public void updateInClientWorld() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound, registryLookup);
        return nbtCompound;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.cinderhearth");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CinderhearthScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        CodecHelper.fromNbt(InkStorageComponent.CODEC, nbt.method_10580("InkStorage")).ifPresent(storage -> {
            this.inkStorage = new IndividualCappedInkStorage(storage.maxPerColor(), storage.storedEnergy());
        });
        this.propertyDelegate.craftingTime = nbt.method_10568("CraftingTime");
        this.propertyDelegate.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.usesEfficiency = nbt.method_10577("UsesEfficiency");
        this.canTransferInk = nbt.method_10577("Paused");
        this.inventoryChanged = nbt.method_10577("InventoryChanged");
        this.structure = nbt.method_10573("Structure", 99) ? CinderHearthStructureType.values()[nbt.method_10550("Structure")] : CinderHearthStructureType.NONE;
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = MultiblockCrafter.getRecipeHolderFromNbt(this.field_11863, nbt);
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        CodecHelper.writeNbt(nbt, "InkStorage", InkStorageComponent.CODEC, new InkStorageComponent(this.inkStorage));
        nbt.method_10575("CraftingTime", (short)this.propertyDelegate.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.propertyDelegate.craftingTimeTotal);
        nbt.method_10556("UsesEfficiency", this.usesEfficiency);
        nbt.method_10556("Paused", this.canTransferInk);
        nbt.method_10556("InventoryChanged", this.inventoryChanged);
        nbt.method_10569("Structure", this.structure.ordinal());
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.comp_1932().toString());
        }
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, CinderhearthBlockEntity cinderhearthBlockEntity) {
        if (cinderhearthBlockEntity.upgrades == null) {
            cinderhearthBlockEntity.calculateUpgrades();
        }
        cinderhearthBlockEntity.inkDirty = false;
        if (cinderhearthBlockEntity.canTransferInk) {
            boolean didSomething = false;
            class_1799 stack = cinderhearthBlockEntity.method_5438(1);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof InkStorageItem) {
                InkStorageItem inkStorageItem = (InkStorageItem)class_17922;
                Object itemStorage = inkStorageItem.getEnergyStorage(stack);
                boolean bl = didSomething = InkStorage.transferInk(itemStorage, cinderhearthBlockEntity.inkStorage) != 0L;
                if (didSomething) {
                    inkStorageItem.setEnergyStorage(stack, (InkStorage)itemStorage);
                }
            }
            if (didSomething) {
                cinderhearthBlockEntity.method_5431();
                cinderhearthBlockEntity.setInkDirty();
            } else {
                cinderhearthBlockEntity.canTransferInk = false;
            }
        }
        if (cinderhearthBlockEntity.inventoryChanged) {
            CinderhearthBlockEntity.calculateRecipe(world, cinderhearthBlockEntity);
            cinderhearthBlockEntity.inventoryChanged = false;
            cinderhearthBlockEntity.updateInClientWorld();
        }
        if (cinderhearthBlockEntity.currentRecipe != null) {
            if (!CinderhearthBlockEntity.canContinue(world, blockPos, cinderhearthBlockEntity)) {
                cinderhearthBlockEntity.currentRecipe = null;
                cinderhearthBlockEntity.propertyDelegate.craftingTime = 0;
                cinderhearthBlockEntity.propertyDelegate.craftingTimeTotal = 0;
                cinderhearthBlockEntity.method_5431();
                return;
            }
            if (cinderhearthBlockEntity.propertyDelegate.craftingTime == 0) {
                int baseTime;
                class_8786<?> recipe = cinderhearthBlockEntity.currentRecipe;
                cinderhearthBlockEntity.usesEfficiency = cinderhearthBlockEntity.drainInkForUpgradesRequired(cinderhearthBlockEntity, Upgradeable.UpgradeType.EFFICIENCY, InkColors.BLACK, false);
                class_1860 class_18602 = recipe.comp_1933();
                if (class_18602 instanceof class_1874) {
                    class_1874 abstractCookingRecipe = (class_1874)class_18602;
                    v1 = abstractCookingRecipe.method_8167();
                } else {
                    class_18602 = recipe.comp_1933();
                    if (class_18602 instanceof CinderhearthRecipe) {
                        CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)class_18602;
                        v1 = cinderhearthRecipe.getCraftingTime();
                    } else {
                        v1 = baseTime = -1;
                    }
                }
                if (baseTime >= 0) {
                    float speedModifier = cinderhearthBlockEntity.drainInkForUpgrades(cinderhearthBlockEntity, Upgradeable.UpgradeType.SPEED, InkColors.MAGENTA, cinderhearthBlockEntity.usesEfficiency);
                    cinderhearthBlockEntity.propertyDelegate.craftingTimeTotal = (int)Math.ceil((float)baseTime / speedModifier);
                }
            }
            ++cinderhearthBlockEntity.propertyDelegate.craftingTime;
            if (cinderhearthBlockEntity.propertyDelegate.craftingTime == cinderhearthBlockEntity.propertyDelegate.craftingTimeTotal) {
                class_1860<?> class_18603 = cinderhearthBlockEntity.getCurrentRecipe();
                if (class_18603 instanceof CinderhearthRecipe) {
                    CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)class_18603;
                    CinderhearthBlockEntity.craftCinderhearthRecipe(world, cinderhearthBlockEntity, cinderhearthRecipe);
                } else {
                    class_18603 = cinderhearthBlockEntity.getCurrentRecipe();
                    if (class_18603 instanceof class_3859) {
                        class_3859 blastingRecipe = (class_3859)class_18603;
                        CinderhearthBlockEntity.craftBlastingRecipe(world, cinderhearthBlockEntity, blastingRecipe);
                    }
                }
            }
            cinderhearthBlockEntity.method_5431();
        }
    }

    private static boolean canContinue(class_1937 world, class_2338 blockPos, CinderhearthBlockEntity cinderhearthBlockEntity) {
        if (!CinderhearthBlockEntity.canAcceptRecipeOutput(world, cinderhearthBlockEntity.currentRecipe, (class_1263)cinderhearthBlockEntity)) {
            return false;
        }
        if (cinderhearthBlockEntity.propertyDelegate.craftingTime % 20 == 0) {
            if (!CinderhearthBlockEntity.checkRecipeRequirements(world, blockPos, cinderhearthBlockEntity)) {
                return false;
            }
            return cinderhearthBlockEntity.drainInkForUpgradesRequired(cinderhearthBlockEntity, InkColors.ORANGE, 8L, cinderhearthBlockEntity.usesEfficiency);
        }
        return true;
    }

    protected static boolean canAcceptRecipeOutput(class_1937 world, class_8786<?> recipe, class_1263 inventory) {
        if (recipe != null) {
            class_1799 outputStack = recipe.comp_1933().method_8110((class_7225.class_7874)world.method_30349());
            if (outputStack.method_7960()) {
                return true;
            }
            int outputSpaceFound = 0;
            for (int slot : OUTPUT_SLOT_IDS) {
                class_1799 slotStack = inventory.method_5438(slot);
                if (slotStack.method_7960()) {
                    return true;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)outputStack) || (outputSpaceFound += outputStack.method_7914() - slotStack.method_7947()) < outputStack.method_7947()) continue;
                return true;
            }
        }
        return false;
    }

    private static void calculateRecipe(@NotNull class_1937 world, @NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        class_3859 recipe;
        CinderhearthRecipe recipe2;
        class_9696 input = new class_9696(cinderhearthBlockEntity.method_5438(0));
        class_1860<?> class_18602 = cinderhearthBlockEntity.getCurrentRecipe();
        if (class_18602 instanceof CinderhearthRecipe ? (recipe2 = (CinderhearthRecipe)class_18602).matches(input, world) : (class_18602 = cinderhearthBlockEntity.getCurrentRecipe()) instanceof class_3859 && (recipe = (class_3859)class_18602).method_59981(input, world)) {
            return;
        }
        cinderhearthBlockEntity.currentRecipe = null;
        cinderhearthBlockEntity.propertyDelegate.craftingTime = 0;
        cinderhearthBlockEntity.propertyDelegate.craftingTimeTotal = -1;
        class_1799 inputStack = cinderhearthBlockEntity.method_5438(0);
        if (!inputStack.method_7960()) {
            world.method_8433().method_8132(SpectrumRecipeTypes.CINDERHEARTH, (class_9695)input, world).ifPresentOrElse(r -> {
                cinderhearthBlockEntity.currentRecipe = r;
            }, () -> world.method_8433().method_8132(class_3956.field_17547, (class_9695)input, world).ifPresent(r -> {
                cinderhearthBlockEntity.currentRecipe = r;
            }));
        }
    }

    private static boolean checkRecipeRequirements(class_1937 world, class_2338 blockPos, @NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        class_1657 lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(cinderhearthBlockEntity.ownerUUID);
        if (lastInteractedPlayer == null) {
            return false;
        }
        cinderhearthBlockEntity.structure = CinderhearthBlock.verifyStructure(world, blockPos, null);
        if (cinderhearthBlockEntity.structure == CinderHearthStructureType.NONE) {
            world.method_8396(null, cinderhearthBlockEntity.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
            return false;
        }
        class_1860<?> class_18602 = cinderhearthBlockEntity.getCurrentRecipe();
        if (class_18602 instanceof GatedRecipe) {
            GatedRecipe gatedRecipe = (GatedRecipe)class_18602;
            return gatedRecipe.canPlayerCraft(lastInteractedPlayer);
        }
        return true;
    }

    public static void craftBlastingRecipe(class_1937 world, @NotNull CinderhearthBlockEntity cinderhearth, @NotNull class_3859 blastingRecipe) {
        class_1799 inputStack = cinderhearth.method_5438(0);
        float yieldMod = inputStack.method_31573(SpectrumItemTags.NO_CINDERHEARTH_DOUBLING) ? 1.0f : cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.YIELD, InkColors.LIGHT_BLUE, cinderhearth.usesEfficiency);
        class_1799 output = blastingRecipe.method_8110((class_7225.class_7874)world.method_30349()).method_7972();
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        if (yieldMod > 1.0f) {
            int count;
            for (int outputCount = Support.getIntFromDecimalWithChance((float)output.method_7947() * yieldMod, world.field_9229); outputCount > 0; outputCount -= count) {
                count = Math.min(outputCount, output.method_7914());
                class_1799 outputStack = output.method_7972();
                outputStack.method_7939(count);
                outputs.add(outputStack);
            }
        } else {
            outputs.add(output.method_7972());
        }
        CinderhearthBlockEntity.craftRecipe(cinderhearth, inputStack, outputs, blastingRecipe.method_8171());
    }

    public static void craftCinderhearthRecipe(class_1937 world, @NotNull CinderhearthBlockEntity cinderhearth, @NotNull CinderhearthRecipe cinderhearthRecipe) {
        class_1799 inputStack = cinderhearth.method_5438(0);
        float yieldMod = inputStack.method_31573(SpectrumItemTags.NO_CINDERHEARTH_DOUBLING) ? 1.0f : cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.YIELD, InkColors.LIGHT_BLUE, cinderhearth.usesEfficiency);
        List<class_1799> outputs = cinderhearthRecipe.getRolledOutputs(world.field_9229, yieldMod);
        CinderhearthBlockEntity.craftRecipe(cinderhearth, inputStack, outputs, cinderhearthRecipe.getExperience());
    }

    private static void craftRecipe(@NotNull CinderhearthBlockEntity cinderhearth, class_1799 inputStack, List<class_1799> outputs, float experience) {
        class_1937 world = cinderhearth.field_11863;
        if (world == null) {
            return;
        }
        class_2371 backupInventory = class_2371.method_10213((int)11, (Object)class_1799.field_8037);
        for (int i = 0; i < cinderhearth.inventory.size(); ++i) {
            backupInventory.set(i, (Object)((class_1799)cinderhearth.inventory.get(i)));
        }
        boolean couldAdd = InventoryHelper.addToInventory((class_1263)cinderhearth, outputs, 3, 11);
        if (couldAdd) {
            boolean remainderAdded;
            int n;
            class_1799 remainder = inputStack.getRecipeRemainder();
            class_1799 inputStackCopy = inputStack.method_7972();
            class_1860<?> class_18602 = cinderhearth.getCurrentRecipe();
            if (class_18602 instanceof CinderhearthRecipe) {
                CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)class_18602;
                n = cinderhearthRecipe.getIngredientStacks().getFirst().getCount();
            } else {
                n = 1;
            }
            int amountToDecrementInput = n;
            inputStack.method_7934(amountToDecrementInput);
            if (remainder.method_7960() && !(remainderAdded = InventoryHelper.addToInventory((class_1263)cinderhearth, remainder, 3, 11))) {
                cinderhearth.method_5447(0, remainder);
            }
            CinderhearthBlockEntity.playCraftingFinishedEffects(cinderhearth);
            cinderhearth.propertyDelegate.craftingTime = 0;
            cinderhearth.method_5431();
            float experienceMod = cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.EXPERIENCE, InkColors.PURPLE, cinderhearth.usesEfficiency);
            int finalExperience = Support.getIntFromDecimalWithChance(experience * experienceMod, world.field_9229);
            ExperienceStorageItem.addStoredExperience((class_7225.class_7874)world.method_30349(), cinderhearth.method_5438(2), finalExperience);
            cinderhearth.grantPlayerCinderhearthSmeltingAdvancement(inputStackCopy, outputs, finalExperience);
        } else {
            cinderhearth.inventory = backupInventory;
            cinderhearth.propertyDelegate.craftingTimeTotal = -1;
            cinderhearth.currentRecipe = null;
            cinderhearth.inventoryChanged = false;
        }
    }

    public void grantPlayerCinderhearthSmeltingAdvancement(class_1799 input, List<class_1799> outputs, int experience) {
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.CINDERHEARTH_SMELTING.trigger(serverPlayerEntity, input, outputs, experience, this.upgrades);
        }
    }

    public static void playCraftingFinishedEffects(@NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        class_2350.class_2351 axis = null;
        class_2350 direction = class_2350.field_11036;
        class_1937 class_19372 = cinderhearthBlockEntity.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        for (Map.Entry entry : cinderhearthBlockEntity.upgrades.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            if (axis == null) {
                class_2680 state = world.method_8320(cinderhearthBlockEntity.field_11867);
                direction = (class_2350)state.method_11654((class_2769)CinderhearthBlock.FACING);
                axis = direction.method_10166();
            }
            double d = (double)cinderhearthBlockEntity.field_11867.method_10263() + 0.5;
            double f = (double)cinderhearthBlockEntity.field_11867.method_10260() + 0.5;
            double g2 = -0.1875;
            double h2 = 0.25;
            double i2 = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * g2 : h2;
            double k2 = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * g2 : h2;
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new class_243(d + i2, (double)cinderhearthBlockEntity.field_11867.method_10264() + 1.1, f + k2), (class_2394)class_2398.field_17430, 3, new class_243(0.05, 0.0, 0.05), new class_243(0.0, 0.3, 0.0));
        }
    }

    public int method_5439() {
        return 11;
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.method_5431();
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack = class_1262.method_5428(this.inventory, (int)slot);
        this.method_5431();
        return removedStack;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5431() {
        super.method_5431();
        this.inventoryChanged = true;
        this.canTransferInk = true;
    }

    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public List<class_2382> getUpgradePosOffsets() {
        return CinderhearthBlock.UPGRADE_BLOCK_OFFSETS;
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    public class_8786<?> getCurrentRecipeHolder() {
        return this.currentRecipe;
    }

    public class_1860<?> getCurrentRecipe() {
        return this.currentRecipe == null ? null : this.currentRecipe.comp_1933();
    }

    public void method_7683(class_1662 finder) {
        this.inventory.forEach(arg_0 -> ((class_1662)finder).method_7400(arg_0));
    }

    public static enum CinderHearthStructureType {
        NONE,
        WITH_LAVA,
        WITHOUT_LAVA;

    }
}

