/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fluid;

import de.dafuqs.spectrum.blocks.decay.BlackMateriaBlock;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.blocks.fluid.MidnightSolutionFluidBlock;
import de.dafuqs.spectrum.blocks.fluid.SpectrumFluid;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.effect.ColoredSparkleRisingParticleEffect;
import de.dafuqs.spectrum.recipe.fluid_converting.FluidConvertingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumFluidTags;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9304;

public abstract class MidnightSolutionFluid
extends SpectrumFluid {
    private static final int EXPERIENCE_DISENCHANT_RETURN_DIV = 3;

    public class_3611 method_15751() {
        return SpectrumFluids.MIDNIGHT_SOLUTION;
    }

    public class_3611 method_15750() {
        return SpectrumFluids.FLOWING_MIDNIGHT_SOLUTION;
    }

    public class_1792 method_15774() {
        return SpectrumItems.MIDNIGHT_SOLUTION_BUCKET;
    }

    protected class_2680 method_15790(class_3610 fluidState) {
        return (class_2680)SpectrumBlocks.MIDNIGHT_SOLUTION.method_9564().method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(MidnightSolutionFluid.method_15741((class_3610)fluidState)));
    }

    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == SpectrumFluids.MIDNIGHT_SOLUTION || fluid == SpectrumFluids.FLOWING_MIDNIGHT_SOLUTION;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_15776(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        class_2338 topPos = pos.method_10084();
        class_2680 topState = world.method_8320(topPos);
        if (topState.method_26215() && !topState.method_26216((class_1922)world, topPos) && random.method_43048(2000) == 0) {
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), SpectrumSoundEvents.MIDNIGHT_SOLUTION_AMBIENT, class_3419.field_15245, 0.2f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f, false);
        }
    }

    @Override
    protected int method_15733(class_4538 worldView) {
        return 5;
    }

    public void method_15778(class_1937 world, class_2338 pos, class_3610 state) {
        boolean converted;
        super.method_15778(world, pos, state);
        if ((double)state.method_20785() < 1.0) {
            for (class_2350 direction : class_2350.values()) {
                if (MidnightSolutionFluidBlock.tryConvertNeighbor(world, pos.method_10093(direction))) break;
            }
        }
        if (converted = BlackMateriaBlock.spreadBlackMateria(world, pos, world.field_9229, MidnightSolutionFluidBlock.SPREAD_BLOCKSTATE)) {
            world.method_39281(pos, state.method_15772(), 400 + world.field_9229.method_43048(800));
        }
    }

    @Override
    public int method_15789(class_4538 worldView) {
        return 12;
    }

    public class_2394 method_15787() {
        return SpectrumParticleTypes.DRIPPING_MIDNIGHT_SOLUTION;
    }

    @Override
    public class_2394 getSplashParticle() {
        return SpectrumParticleTypes.MIDNIGHT_SOLUTION_SPLASH;
    }

    @Override
    public void onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.onEntityCollision(state, world, pos, entity);
        if (!world.field_9236) {
            class_1542 itemEntity;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!livingEntity.method_29504() && world.method_8510() % 20L == 0L) {
                    float damageMult = 1.0f;
                    if (world.method_23753(pos).method_40225(SpectrumBiomes.BLACK_LANGAST)) {
                        damageMult = 9.0f;
                    }
                    if (livingEntity.method_5777(SpectrumFluidTags.MIDNIGHT_SOLUTION)) {
                        livingEntity.method_6092(new class_1293(class_1294.field_5919, 50, 0));
                        livingEntity.method_5643(SpectrumDamageTypes.midnightSolution(world), 2.0f * damageMult);
                    } else {
                        livingEntity.method_5643(SpectrumDamageTypes.midnightSolution(world), damageMult);
                    }
                    if (livingEntity.method_29504()) {
                        livingEntity.method_5775(SpectrumItems.MIDNIGHT_CHIP.method_7854());
                    }
                }
            } else if (entity instanceof class_1542 && !(itemEntity = (class_1542)entity).method_6977() && world.field_9229.method_43048(120) == 0) {
                MidnightSolutionFluid.disenchantItemAndSpawnXP(world, itemEntity);
            }
        }
    }

    @Override
    public class_3956<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return SpectrumRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING;
    }

    private static void disenchantItemAndSpawnXP(class_1937 world, class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        class_9304 enchantments = class_1890.method_57532((class_1799)itemStack);
        if (!enchantments.method_57543()) {
            int randomEnchantmentIndex = world.field_9229.method_43048(enchantments.method_57541());
            Object2IntMap.Entry entryToRemove = (Object2IntMap.Entry)enchantments.method_57539().stream().toList().get(randomEnchantmentIndex);
            class_3545<class_1799, Integer> result = SpectrumEnchantmentHelper.removeEnchantments(itemStack, (class_6880)entryToRemove.getKey());
            if ((Integer)result.method_15441() > 0) {
                MidnightSolutionFluid.spawnXP(world, itemEntity, EnchanterBlockEntity.getEnchantingPrice(itemStack, (class_6880<class_1887>)((class_6880)entryToRemove.getKey()), entryToRemove.getIntValue()));
                itemEntity.method_6979((class_1799)result.method_15442());
                itemEntity.method_6988();
            }
        } else if (itemStack.method_57826(SpectrumDataComponentTypes.CANVAS_ENCHANTMENTS)) {
            class_9304 canvasEnchantments = (class_9304)itemStack.method_57824(SpectrumDataComponentTypes.CANVAS_ENCHANTMENTS);
            class_1792 boundItem = (class_1792)class_7923.field_41178.method_10223((class_2960)itemStack.method_57824(SpectrumDataComponentTypes.BOUND_ITEM));
            if (!canvasEnchantments.method_57543()) {
                int randomEnchantmentIndex = world.field_9229.method_43048(canvasEnchantments.method_57541());
                Object2IntMap.Entry entryToRemove = (Object2IntMap.Entry)canvasEnchantments.method_57539().stream().toList().get(randomEnchantmentIndex);
                class_9304.class_9305 builder = new class_9304.class_9305(canvasEnchantments);
                builder.method_57547((class_6880)entryToRemove.getKey(), 0);
                MidnightSolutionFluid.spawnXP(world, itemEntity, EnchanterBlockEntity.getEnchantingPrice(boundItem.method_7854(), (class_6880<class_1887>)((class_6880)entryToRemove.getKey()), entryToRemove.getIntValue()));
                class_9304 targetEnchants = builder.method_57549();
                if (targetEnchants.method_57543()) {
                    itemStack.method_57381(SpectrumDataComponentTypes.CANVAS_ENCHANTMENTS);
                } else {
                    itemStack.method_57379(SpectrumDataComponentTypes.CANVAS_ENCHANTMENTS, (Object)targetEnchants);
                }
                itemEntity.method_6988();
            }
        }
    }

    private static void spawnXP(class_1937 world, class_1542 itemEntity, int exp) {
        if ((exp /= 3) > 0) {
            class_1303 experienceOrbEntity = new class_1303(world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), exp);
            world.method_8649((class_1297)experienceOrbEntity);
        }
        world.method_8396(null, itemEntity.method_24515(), class_3417.field_16865, class_3419.field_15254, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, itemEntity.method_19538(), ColoredSparkleRisingParticleEffect.GRAY, 10, class_243.field_1353, new class_243(0.2, 0.4, 0.2));
    }

    public static class Still
    extends MidnightSolutionFluid {
        public int method_15779(class_3610 fluidState) {
            return 8;
        }

        public boolean method_15793(class_3610 fluidState) {
            return true;
        }
    }

    public static class Flowing
    extends MidnightSolutionFluid {
        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(new class_2769[]{field_15900});
        }

        public int method_15779(class_3610 fluidState) {
            return (Integer)fluidState.method_11654((class_2769)field_15900);
        }

        public boolean method_15793(class_3610 fluidState) {
            return false;
        }
    }
}

