/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.memory;

import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.components.MemoryComponent;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.helpers.EntityHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayMemoryManifestingParticlesPayload;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_3737;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryBlockEntity
extends class_2586
implements PlayerOwned {
    protected class_1799 memoryItemStack = class_1799.field_8037;
    protected UUID ownerUUID;
    private int tint1 = -1;
    private int tint2 = -1;

    public MemoryBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.MEMORY, pos, state);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static class_3545<Integer, Integer> getEggColorsForEntity(class_1299<?> entityType) {
        class_1826 spawnEggItem = class_1826.method_8019(entityType);
        if (spawnEggItem != null) {
            return new class_3545((Object)spawnEggItem.method_8016(0), (Object)spawnEggItem.method_8016(1));
        }
        return new class_3545((Object)0x222222, (Object)0xDDDDDD);
    }

    public static int getManifestAdvanceSteps(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2680 belowBlockState = world.method_8320(blockPos.method_10074());
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_NEVER_MANIFESTERS)) {
            return 0;
        }
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_VERY_FAST_MANIFESTERS)) {
            return 8;
        }
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_FAST_MANIFESTERS)) {
            return 3;
        }
        return 1;
    }

    public void setData(class_1309 livingEntity, @NotNull class_1799 memoryStack) {
        class_1937 class_19372;
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            this.setOwner(playerEntity);
            if (playerEntity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)playerEntity;
                if (MemoryItem.getEntityType(memoryStack).isEmpty()) {
                    Support.grantAdvancementCriterion(serverPlayer, SpectrumAdvancements.PLACE_FORGOTTEN_MEMORY, "place_forgotten_memory");
                }
            }
        }
        if (memoryStack.method_7909() instanceof MemoryItem) {
            this.memoryItemStack = memoryStack.method_7972();
            this.memoryItemStack.method_7939(1);
        }
        if ((class_19372 = livingEntity.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
        this.method_5431();
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        if (nbt.method_10573("MemoryItem", 10)) {
            this.memoryItemStack = class_1799.method_57359((class_7225.class_7874)registryLookup, (class_2487)nbt.method_10562("MemoryItem"));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (!this.memoryItemStack.method_7960()) {
            CodecHelper.writeNbt(nbt, "MemoryItem", class_1799.field_24671, this.memoryItemStack);
        }
    }

    public void advanceManifesting(class_3218 world, class_2338 blockPos) {
        int additionalManifestAdvanceSteps;
        int ticksToManifest = MemoryItem.getTicksToManifest(this.memoryItemStack);
        if (ticksToManifest > 0 && (additionalManifestAdvanceSteps = MemoryBlockEntity.getManifestAdvanceSteps((class_1937)world, blockPos)) > 0) {
            int newTicksToManifest = ticksToManifest - additionalManifestAdvanceSteps;
            if (newTicksToManifest <= 0) {
                this.manifestFromBlock(world, blockPos);
            } else {
                Optional<class_9296> playerOptional = MemoryItem.getPlayer(this.memoryItemStack);
                Optional<Object> entityType = playerOptional.isPresent() ? Optional.of(class_1299.field_6097) : MemoryItem.getEntityType(this.memoryItemStack);
                if (entityType.isPresent()) {
                    MemoryItem.setTicksToManifest(this.memoryItemStack, newTicksToManifest);
                    PlayMemoryManifestingParticlesPayload.playMemoryManifestingParticles(world, blockPos, entityType.get(), 3);
                    world.method_8396(null, this.field_11867, SpectrumSoundEvents.BLOCK_MEMORY_ADVANCE, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
                    this.method_5431();
                }
            }
        }
    }

    protected void manifestFromBlock(@NotNull class_3218 world, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26204() instanceof class_3737 && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_8501(blockPos, class_2246.field_10382.method_9564());
        } else {
            world.method_8501(blockPos, class_2246.field_10124.method_9564());
        }
        MemoryBlockEntity.manifest(world, blockPos, this.memoryItemStack, this.ownerUUID);
    }

    public static boolean manifest(@NotNull class_3218 world, class_2338 blockPos, class_1799 memoryItemStack, @Nullable UUID ownerUUID) {
        Optional<class_1297> hatchedEntityOptional = MemoryBlockEntity.hatchEntity(world, blockPos, memoryItemStack);
        if (hatchedEntityOptional.isPresent()) {
            class_1657 owner;
            class_1297 hatchedEntity = hatchedEntityOptional.get();
            PlayMemoryManifestingParticlesPayload.playMemoryManifestingParticles(world, blockPos, hatchedEntity.method_5864(), 10);
            if (hatchedEntity instanceof class_1308) {
                class_1308 hatchedMobEntity = (class_1308)hatchedEntity;
                hatchedMobEntity.method_5971();
                hatchedMobEntity.method_5966();
                hatchedMobEntity.method_5990();
            }
            if (ownerUUID != null) {
                EntityHelper.addPlayerTrust(hatchedEntity, ownerUUID);
            }
            if ((owner = PlayerOwned.getPlayerEntityIfOnline(ownerUUID)) instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)owner;
                SpectrumAdvancementCriteria.MEMORY_MANIFESTING.trigger(serverPlayerEntity, hatchedEntity);
            }
            return true;
        }
        return false;
    }

    public int getEggColor(int tintIndex) {
        if (this.tint1 == -1) {
            if (this.memoryItemStack == null) {
                this.tint1 = 0x222222;
                this.tint2 = 0xDDDDDD;
            } else {
                this.tint1 = MemoryItem.getEggColor(this.memoryItemStack, 0);
                this.tint2 = MemoryItem.getEggColor(this.memoryItemStack, 1);
            }
        }
        if (tintIndex == 0) {
            return this.tint1;
        }
        return this.tint2;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public static Optional<class_1297> hatchEntity(class_3218 world, class_2338 blockPos, class_1799 memoryItemStack) {
        MemoryComponent memoryComponent = (MemoryComponent)memoryItemStack.method_57824(SpectrumDataComponentTypes.MEMORY);
        if (memoryComponent == null) {
            return Optional.empty();
        }
        class_9296 profile = (class_9296)memoryItemStack.method_57824(class_9334.field_49617);
        if (profile != null) {
            @Nullable class_3222 player = world.method_8503().method_3760().method_14602((UUID)profile.comp_2411().get());
            if (player == null) {
                return Optional.empty();
            }
            world.method_43128((class_1657)player, player.method_19538().method_10216(), player.method_19538().method_10214(), player.method_19538().method_10215(), SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            player.method_14251(world, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, player.field_6283, 0.0f);
            world.method_43128((class_1657)player, player.method_19538().method_10216(), player.method_19538().field_1351, player.method_19538().field_1350, SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.memory.you_were_remembered_by_a_memory"), true);
            return Optional.of(player);
        }
        Optional<class_1299<?>> entityType = MemoryItem.getEntityType(memoryItemStack);
        if (entityType.isPresent()) {
            class_1297 entity = entityType.get().method_5894(world, memoryItemStack, null, blockPos, class_3730.field_16465, true, false);
            if (entity instanceof class_1308) {
                class_1308 mobEntity = (class_1308)entity;
                if (!memoryComponent.spawnAsAdult()) {
                    mobEntity.method_7217(true);
                }
            }
            return Optional.ofNullable(entity);
        }
        return Optional.empty();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(@NotNull class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    public class_1799 getMemoryItemStack() {
        return this.memoryItemStack;
    }
}

