/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.particle_spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ParticleSpawnerConfiguration(class_2396<?> particleType, class_2382 cmyColor, boolean glowing, float particlesPerSecond, class_243 sourcePosition, class_243 sourcePositionVariance, class_243 velocity, class_243 velocityVariance, float scale, float scaleVariance, int lifetimeTicks, int lifetimeVariance, float gravity, boolean collisions) {
    public static final Codec<ParticleSpawnerConfiguration> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_7923.field_41180.method_39673().fieldOf("particle_type_identifier").forGetter(ParticleSpawnerConfiguration::particleType), (App)class_2382.field_25123.fieldOf("color").forGetter(ParticleSpawnerConfiguration::cmyColor), (App)Codec.BOOL.fieldOf("glowing").forGetter(ParticleSpawnerConfiguration::glowing), (App)Codec.FLOAT.fieldOf("particles_per_tick").forGetter(ParticleSpawnerConfiguration::particlesPerSecond), (App)class_243.field_38277.fieldOf("source_pos").forGetter(ParticleSpawnerConfiguration::sourcePosition), (App)class_243.field_38277.fieldOf("source_pos_variance").forGetter(ParticleSpawnerConfiguration::sourcePositionVariance), (App)class_243.field_38277.fieldOf("source_velocity").forGetter(ParticleSpawnerConfiguration::velocity), (App)class_243.field_38277.fieldOf("source_velocity_variance").forGetter(ParticleSpawnerConfiguration::velocityVariance), (App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleSpawnerConfiguration::scale), (App)Codec.FLOAT.fieldOf("scale_variance").forGetter(ParticleSpawnerConfiguration::scaleVariance), (App)Codec.INT.fieldOf("lifetime").forGetter(ParticleSpawnerConfiguration::lifetimeTicks), (App)Codec.INT.fieldOf("lifetime_variance").forGetter(ParticleSpawnerConfiguration::lifetimeVariance), (App)Codec.FLOAT.fieldOf("gravity").forGetter(ParticleSpawnerConfiguration::gravity), (App)Codec.BOOL.fieldOf("collisions").forGetter(ParticleSpawnerConfiguration::collisions)).apply((Applicative)i, ParticleSpawnerConfiguration::new));
    public static final class_9139<class_2540, ParticleSpawnerConfiguration> PACKET_CODEC = PacketCodecHelper.tuple(PacketCodecHelper.registryValueByName(class_7923.field_41180), c -> c.particleType, PacketCodecHelper.VEC3I, c -> c.cmyColor, class_9135.field_48547, c -> c.glowing, class_9135.field_48552, c -> Float.valueOf(c.particlesPerSecond), PacketCodecHelper.VEC3D, c -> c.sourcePosition, PacketCodecHelper.VEC3D, c -> c.sourcePositionVariance, PacketCodecHelper.VEC3D, c -> c.velocity, PacketCodecHelper.VEC3D, c -> c.velocityVariance, class_9135.field_48552, c -> Float.valueOf(c.scale), class_9135.field_48552, c -> Float.valueOf(c.scaleVariance), class_9135.field_48550, c -> c.lifetimeTicks, class_9135.field_48550, c -> c.lifetimeVariance, class_9135.field_48552, c -> Float.valueOf(c.gravity), class_9135.field_48547, c -> c.collisions, ParticleSpawnerConfiguration::new);

    public static Vector3fc CMYtoRGB(class_2382 cmy) {
        float r = 1.0f - (float)cmy.method_10263() / 100.0f;
        float g = 1.0f - (float)cmy.method_10264() / 100.0f;
        float b = 1.0f - (float)cmy.method_10260() / 100.0f;
        return new Vector3f(r, g, b);
    }

    public void spawnParticles(class_1937 world, @NotNull class_2338 pos) {
        for (float particlesToSpawn = this.particlesPerSecond / 20.0f; particlesToSpawn >= 1.0f || world.field_9229.method_43057() < particlesToSpawn; particlesToSpawn -= 1.0f) {
            this.spawnParticle(world, pos, world.field_9229);
        }
    }

    private void spawnParticle(class_1937 world, @NotNull class_2338 pos, class_5819 random) {
        int randomLifetime;
        float randomScale = this.scaleVariance == 0.0f ? this.scale : (float)((double)(this.scale + this.scaleVariance) - random.method_43058() * (double)this.scaleVariance * 2.0);
        int n = randomLifetime = this.lifetimeVariance == 0 ? this.lifetimeTicks : (int)((double)(this.lifetimeTicks + this.lifetimeVariance) - random.method_43058() * (double)this.lifetimeVariance * 2.0);
        if (randomScale > 0.0f && randomLifetime > 0) {
            double randomOffsetX = this.sourcePositionVariance.field_1352 == 0.0 ? 0.0 : this.sourcePositionVariance.field_1352 - random.method_43058() * this.sourcePositionVariance.field_1352 * 2.0;
            double randomOffsetY = this.sourcePositionVariance.field_1351 == 0.0 ? 0.0 : this.sourcePositionVariance.field_1351 - random.method_43058() * this.sourcePositionVariance.field_1351 * 2.0;
            double randomOffsetZ = this.sourcePositionVariance.field_1350 == 0.0 ? 0.0 : this.sourcePositionVariance.field_1350 - random.method_43058() * this.sourcePositionVariance.field_1350 * 2.0;
            double randomVelocityX = this.velocityVariance.field_1352 == 0.0 ? 0.0 : this.velocityVariance.field_1352 - random.method_43058() * this.velocityVariance.field_1352 * 2.0;
            double randomVelocityY = this.velocityVariance.field_1351 == 0.0 ? 0.0 : this.velocityVariance.field_1351 - random.method_43058() * this.velocityVariance.field_1351 * 2.0;
            double randomVelocityZ = this.velocityVariance.field_1350 == 0.0 ? 0.0 : this.velocityVariance.field_1350 - random.method_43058() * this.velocityVariance.field_1350 * 2.0;
            Vector3fc rgbColor = ParticleSpawnerConfiguration.CMYtoRGB(this.cmyColor);
            world.method_8406((class_2394)new DynamicParticleEffect(this.particleType, this.gravity, new Vector3f(rgbColor), randomScale, randomLifetime, this.collisions, this.glowing), (double)pos.method_10263() + 0.5 + this.sourcePosition.field_1352 + randomOffsetX, (double)pos.method_10264() + 0.5 + this.sourcePosition.field_1351 + randomOffsetY, (double)pos.method_10260() + 0.5 + this.sourcePosition.field_1350 + randomOffsetZ, this.velocity.field_1352 + randomVelocityX, this.velocity.field_1351 + randomVelocityY, this.velocity.field_1350 + randomVelocityZ);
        }
    }
}

