/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import com.google.common.base.Predicates;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.FilterConfigurable;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeSignature;
import de.dafuqs.spectrum.api.pastel.PastelUpgradeable;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlock;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.inventories.FilteringScreenHandler;
import de.dafuqs.spectrum.networking.s2c_payloads.PastelNetworkEdgeSyncPayload;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumPastelUpgrades;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlockEntity
extends class_2586
implements FilterConfigurable,
ExtendedScreenHandlerFactory<FilterConfigurable.ExtendedData>,
PastelUpgradeable {
    public static final int MAX_FILTER_SLOTS = 25;
    public static final int SLOTS_PER_ROW = 5;
    public static final int DEFAULT_FILTER_SLOT_ROWS = 1;
    public static final int RANGE = 12;
    @NotNull
    protected UUID nodeId = UUID.randomUUID();
    protected Optional<UUID> networkUUID = Optional.empty();
    protected Optional<PastelUpgradeSignature> outerRing;
    protected Optional<PastelUpgradeSignature> innerRing;
    protected Optional<PastelUpgradeSignature> redstoneRing;
    protected Optional<class_1767> color = Optional.empty();
    protected long lastTransferTick = 0L;
    protected final long cachedRedstonePowerTick = 0L;
    protected boolean cachedUnpowered = true;
    protected PastelNetwork.NodePriority priority = PastelNetwork.NodePriority.GENERIC;
    protected long itemCountUnderway = 0L;
    protected boolean lit;
    protected boolean triggerTransfer;
    protected boolean triggered;
    protected boolean waiting;
    protected boolean lamp;
    protected boolean sensor;
    protected boolean updated;
    protected int transferCount = 1;
    protected int transferTime = 30;
    protected int filterSlotRows = 1;
    protected BlockApiCache<Storage<ItemVariant>, class_2350> connectedStorageCache = null;
    protected class_2350 cachedDirection = null;
    protected Boolean isInitialized = false;
    private final List<ItemVariant> filterItems = class_2371.method_10213((int)25, (Object)ItemVariant.blank());
    float rotationTarget;
    float crystalRotation;
    float lastRotationTarget;
    float heightTarget;
    float crystalHeight;
    float lastHeightTarget;
    float alphaTarget;
    float ringAlpha;
    float lastAlphaTarget;
    long creationStamp = -1L;
    long interpTicks;
    long interpLength = -1L;
    long spinTicks;
    private ConnectionState connectionState;

    public PastelNodeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.PASTEL_NODE, blockPos, blockState);
        this.outerRing = Optional.empty();
        this.innerRing = Optional.empty();
        this.redstoneRing = Optional.empty();
    }

    @Nullable
    public Storage<ItemVariant> getConnectedStorage() {
        if (this.connectedStorageCache == null) {
            class_2680 state = this.method_11010();
            if (!(state.method_26204() instanceof PastelNodeBlock)) {
                return null;
            }
            this.cachedDirection = (class_2350)state.method_11654((class_2769)PastelNodeBlock.field_10927);
            this.connectedStorageCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016().method_10093(this.cachedDirection.method_10153()));
        }
        return (Storage)this.connectedStorageCache.find((Object)this.cachedDirection);
    }

    public static void tick(@NotNull class_1937 world, class_2338 pos, class_2680 state, PastelNodeBlockEntity node) {
        if (!node.isInitialized.booleanValue() && !world.method_8608()) {
            node.getServerNetwork().ifPresent(network -> network.initializeNode(node));
            node.isInitialized = true;
        }
        if (node.lamp && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() != node.canTransfer()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(node.cachedUnpowered)));
        }
        if (node.triggerTransfer) {
            boolean powered = world.method_49803(pos);
            if (node.waiting && !powered) {
                node.waiting = false;
            }
            if (!node.triggered && !node.waiting && powered) {
                node.triggered = true;
            }
        }
        if (world.method_8608()) {
            if (node.networkUUID.isEmpty()) {
                node.changeConnectionState(ConnectionState.DISCONNECTED);
                node.interpLength = 17L;
            } else if (!node.canTransfer()) {
                node.changeConnectionState(ConnectionState.INACTIVE);
                node.interpLength = 21L;
            } else if (node.spinTicks > 0L) {
                node.changeConnectionState(ConnectionState.ACTIVE);
                node.interpLength = 17L;
            } else {
                node.changeConnectionState(ConnectionState.CONNECTED);
                node.interpLength = 13L;
            }
            if (node.interpTicks < node.interpLength) {
                ++node.interpTicks;
            }
            if (node.spinTicks > 0L) {
                --node.spinTicks;
            }
        } else if (!node.updated) {
            node.updateUpgrades();
            node.updated = true;
        }
    }

    public void changeConnectionState(ConnectionState connectionState) {
        if (this.connectionState != connectionState) {
            this.connectionState = connectionState;
            this.lastRotationTarget = this.crystalRotation;
            this.lastHeightTarget = this.crystalHeight;
            this.lastAlphaTarget = this.ringAlpha;
            this.interpTicks = 0L;
        }
    }

    public Optional<PastelUpgradeSignature> getInnerRing() {
        return this.innerRing;
    }

    public Optional<PastelUpgradeSignature> getOuterRing() {
        return this.outerRing;
    }

    public Optional<PastelUpgradeSignature> getRedstoneRing() {
        return this.redstoneRing;
    }

    public PastelNetwork.NodePriority getPriority() {
        return this.priority;
    }

    public boolean tryInteractRings(class_1799 item, PastelNodeType type) {
        PastelUpgradeSignature upgrade = SpectrumPastelUpgrades.of(item);
        if (upgrade.category.isRedstone()) {
            if (this.redstoneRing.isEmpty()) {
                this.redstoneRing = Optional.of(upgrade);
                return true;
            }
            return false;
        }
        if (this.outerRing.isEmpty() && type.hasOuterRing()) {
            this.outerRing = Optional.of(upgrade);
            return true;
        }
        if (this.innerRing.isEmpty()) {
            this.innerRing = Optional.of(upgrade);
            return true;
        }
        return false;
    }

    public class_1799 tryRemoveUpgrade() {
        class_1799 stack = class_1799.field_8037;
        if (this.redstoneRing.isPresent()) {
            stack = this.redstoneRing.get().upgradeItem.method_7854();
            this.redstoneRing = Optional.empty();
        } else if (this.innerRing.isPresent()) {
            stack = this.innerRing.get().upgradeItem.method_7854();
            this.innerRing = Optional.empty();
        } else if (this.outerRing.isPresent()) {
            stack = this.outerRing.get().upgradeItem.method_7854();
            this.outerRing = Optional.empty();
        }
        if (!stack.method_7960()) {
            this.field_11863.method_45446(this.field_11867, SpectrumSoundEvents.SHATTER_LIGHT, class_3419.field_15245, 0.25f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f, true);
            this.method_5431();
        }
        return stack;
    }

    public void updateUpgrades() {
        this.transferCount = 1;
        this.transferTime = 30;
        int oldFilterSlotCount = this.filterSlotRows;
        this.filterSlotRows = 1;
        this.triggerTransfer = false;
        this.lit = false;
        this.lamp = false;
        this.sensor = false;
        PastelNetwork.NodePriority oldPriority = this.priority;
        this.priority = PastelNetwork.NodePriority.GENERIC;
        this.outerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.innerRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, this.outerRing.map(List::of).orElse(Collections.emptyList())));
        this.redstoneRing.ifPresent(r -> this.apply((PastelUpgradeSignature)r, Collections.emptyList()));
        this.transferCount = Math.max(this.transferCount, 1);
        this.transferTime = class_3532.method_15340((int)this.transferTime, (int)2, (int)100);
        this.filterSlotRows = class_3532.method_15340((int)this.filterSlotRows, (int)1, (int)5);
        if (this.lit && this.lamp) {
            this.lit = false;
        }
        if (this.field_11863 != null) {
            this.networkUUID.ifPresent(uuid -> ServerPastelNetworkManager.get((class_3218)this.field_11863).getNetwork((UUID)uuid).ifPresent(n -> n.updateNodePriority(this, oldPriority)));
            if ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12548) != this.lit) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(this.lit)));
            }
        }
        if (this.filterSlotRows < oldFilterSlotCount) {
            for (int i = this.getDrawnSlots(); i < this.filterItems.size(); ++i) {
                this.filterItems.set(i, ItemVariant.blank());
            }
        }
    }

    @Override
    public void notifySensor() {
        if (this.field_11863 != null) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)));
            if (!this.field_11863.method_8397().method_8674(this.field_11867, (Object)state.method_26204())) {
                this.field_11863.method_39279(this.field_11867, state.method_26204(), 2);
            }
        }
    }

    public long getMaxTransferredAmount() {
        return this.transferCount;
    }

    public int getTransferTime() {
        return this.transferTime;
    }

    public float getRedstoneAlphaMult() {
        return this.redstoneRing.isPresent() ? 0.5f : 0.25f;
    }

    public boolean canTransfer() {
        boolean canTransfer;
        class_1269 result = this.redstoneRing.map(r -> r.preProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.field_11863, this.field_11867, this.cachedUnpowered))).orElse(class_1269.field_5811);
        if (result == class_1269.field_5812) {
            return true;
        }
        if (result == class_1269.field_5814) {
            return false;
        }
        long time = this.method_10997().method_8510();
        if (time > this.cachedRedstonePowerTick && !((Boolean)this.method_11010().method_11654((class_2769)PastelNodeBlock.REDSTONE_EMITTING)).booleanValue()) {
            this.cachedUnpowered = this.field_11863.method_49804(this.field_11867) == 0;
        }
        boolean notPowered = this.redstoneRing.map(r -> {
            class_1269 post = r.postProcessor.apply(new PastelUpgradeSignature.RedstoneContext(this, this.field_11863, this.field_11867, this.cachedUnpowered));
            if (post == class_1269.field_5812) {
                return true;
            }
            if (post == class_1269.field_5814) {
                return false;
            }
            return this.cachedUnpowered;
        }).orElse(this.cachedUnpowered);
        boolean bl = canTransfer = this.method_10997().method_8510() > this.lastTransferTick;
        if (this.triggerTransfer) {
            return this.triggered && canTransfer;
        }
        return canTransfer && notPowered;
    }

    public void markTransferred() {
        if (this.triggerTransfer) {
            this.markTriggered();
        }
        this.lastTransferTick = this.field_11863.method_8510();
        this.method_5431();
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.nodeId = nbt.method_10545("NodeID") ? nbt.method_25926("NodeID") : UUID.randomUUID();
        this.networkUUID = nbt.method_10545("NetworkUUID") ? Optional.of(nbt.method_25926("NetworkUUID")) : Optional.empty();
        this.triggered = nbt.method_10545("Triggered") && nbt.method_10577("Triggered");
        this.waiting = nbt.method_10545("Waiting") && nbt.method_10577("Waiting");
        this.creationStamp = nbt.method_10545("creationStamp") ? nbt.method_10537("creationStamp") : 0L;
        this.lastTransferTick = nbt.method_10573("LastTransferTick", 4) ? nbt.method_10537("LastTransferTick") : 0L;
        this.itemCountUnderway = nbt.method_10573("ItemCountUnderway", 4) ? nbt.method_10537("ItemCountUnderway") : 0L;
        this.color = nbt.method_10573("ColorId", 3) ? Optional.of(class_1767.method_7791((int)nbt.method_10550("ColorId"))) : Optional.empty();
        this.outerRing = nbt.method_10545("OuterRing") ? Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("OuterRing")))) : Optional.empty();
        this.innerRing = nbt.method_10545("InnerRing") ? Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("InnerRing")))) : Optional.empty();
        Optional<Object> optional = this.redstoneRing = nbt.method_10545("RedstoneRing") ? Optional.ofNullable((PastelUpgradeSignature)SpectrumRegistries.PASTEL_UPGRADE.method_10223(class_2960.method_12829((String)nbt.method_10558("RedstoneRing")))) : Optional.empty();
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.readFilterNbt(nbt, this.filterItems);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.creationStamp != -1L) {
            nbt.method_10544("creationStamp", this.creationStamp);
        }
        if (this.networkUUID.isPresent()) {
            nbt.method_25927("NetworkUUID", this.networkUUID.get());
        }
        if (this.color.isPresent()) {
            nbt.method_10569("ColorId", this.color.get().method_7789());
        }
        nbt.method_25927("NodeID", this.nodeId);
        nbt.method_10556("Triggered", this.triggered);
        nbt.method_10556("Waiting", this.waiting);
        nbt.method_10544("LastTransferTick", this.lastTransferTick);
        nbt.method_10544("ItemCountUnderway", this.itemCountUnderway);
        if (this.getNodeType().usesFilters()) {
            FilterConfigurable.writeFilterNbt(nbt, this.filterItems);
        }
        this.outerRing.ifPresent(r -> nbt.method_10582("OuterRing", SpectrumPastelUpgrades.toString(r)));
        this.innerRing.ifPresent(r -> nbt.method_10582("InnerRing", SpectrumPastelUpgrades.toString(r)));
        this.redstoneRing.ifPresent(r -> nbt.method_10582("RedstoneRing", SpectrumPastelUpgrades.toString(r)));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        Optional<ServerPastelNetwork> network = this.getServerNetwork();
        network.ifPresent(serverPastelNetwork -> PastelNetworkEdgeSyncPayload.send(serverPastelNetwork, this.field_11867));
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public void method_11012() {
        super.method_11012();
        if (!this.field_11863.method_8608()) {
            Pastel.getServerInstance().removeNode(this, NodeRemovalReason.UNLOADED);
        }
    }

    @NotNull
    public UUID getNodeId() {
        return this.nodeId;
    }

    public void onBroken() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            Pastel.getServerInstance().removeNode(this, NodeRemovalReason.BROKEN);
        }
    }

    public PastelNodeType getNodeType() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof PastelNodeBlock) {
            PastelNodeBlock pastelNodeBlock = (PastelNodeBlock)class_22482;
            return pastelNodeBlock.pastelNodeType;
        }
        return PastelNodeType.CONNECTION;
    }

    public void setNetworkUUID(@Nullable UUID uuid) {
        this.networkUUID = Optional.ofNullable(uuid);
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            this.method_5431();
            this.updateInClientWorld();
        }
    }

    public long getItemCountUnderway() {
        return this.itemCountUnderway;
    }

    public void addItemCountUnderway(long count) {
        this.itemCountUnderway += count;
        this.itemCountUnderway = Math.max(0L, this.itemCountUnderway);
        this.method_5431();
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    @Override
    public List<ItemVariant> getItemFilters() {
        return this.filterItems;
    }

    @Override
    public void setFilterItem(int slot, ItemVariant item) {
        this.filterItems.set(slot, item);
    }

    public Predicate<ItemVariant> getTransferFilterTo(PastelNodeBlockEntity other) {
        if (this.getNodeType().usesFilters() && !this.hasEmptyFilter()) {
            if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
                return Predicates.and(this::filter, other::filter);
            }
            return this::filter;
        }
        if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
            return other::filter;
        }
        return itemVariant -> true;
    }

    private boolean filter(ItemVariant variant) {
        return this.filterItems.stream().anyMatch(filterItem -> {
            class_1799 filterStack = filterItem.toStack();
            if (!filterStack.method_57826(class_9334.field_49631) || !filterStack.method_31573(SpectrumItemTags.TAG_FILTERING_ITEMS)) {
                return filterStack.method_7909() == variant.getItem();
            }
            String name = StringUtils.trim((String)filterStack.method_7964().getString());
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"*", "any", "all", "everything", "c:*", "c:any", "c:all", "c:everything"})) {
                return true;
            }
            class_2960 id = class_2960.method_12829((String)StringUtils.remove((String)name, (char)'#'));
            if (id == null) {
                return false;
            }
            class_6862 tag = SpectrumCommon.CACHED_ITEM_TAG_MAP.computeIfAbsent(id, tagId -> class_7923.field_41178.method_40273().filter((? super T t) -> t.comp_327().equals(tagId)).findFirst().orElse(null));
            if (tag == null) {
                return false;
            }
            return variant.getItem().method_40131().method_40220(tag);
        });
    }

    public long getCreationStamp() {
        return this.creationStamp;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.spectrum.pastel_node");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FilteringScreenHandler(syncId, inv, new FilterConfigurable.ExtendedData(this));
    }

    @Override
    public int getFilterRows() {
        return this.filterSlotRows;
    }

    @Override
    public int getDrawnSlots() {
        return this.getFilterRows() * 5;
    }

    public FilterConfigurable.ExtendedData getScreenOpeningData(class_3222 player) {
        return new FilterConfigurable.ExtendedData(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PastelNodeBlockEntity)) return false;
        PastelNodeBlockEntity blockEntity = (PastelNodeBlockEntity)obj;
        if (!this.field_11867.equals((Object)blockEntity.field_11867)) return false;
        return true;
    }

    public int hashCode() {
        return this.field_11867.hashCode();
    }

    public ConnectionState getState() {
        return this.connectionState;
    }

    public Optional<class_1767> getColor() {
        return this.color;
    }

    public boolean setColor(Optional<class_1767> color, @Nullable class_1297 user) {
        if (this.color == color) {
            return false;
        }
        this.color = color;
        if (!this.field_11863.method_8608()) {
            this.connectToNearbyNodes(user);
        }
        return true;
    }

    public void connectToNearbyNodes(@Nullable class_1297 user) {
        Pastel.getServerInstance().removeNode(this, NodeRemovalReason.DISCONNECT);
        this.setNetworkUUID(null);
        Object2ObjectArrayMap connectableNodes = new Object2ObjectArrayMap();
        ServerPastelNetwork biggestNetwork = null;
        for (class_2338 pos : class_2338.method_25996((class_2338)this.method_11016(), (int)12, (int)12, (int)12)) {
            Optional blockEntity = this.field_11863.method_35230(pos, SpectrumBlockEntities.PASTEL_NODE);
            if (!blockEntity.isPresent() || !this.canConnect(this, (PastelNodeBlockEntity)blockEntity.get())) continue;
            PastelNodeBlockEntity connectableNode = (PastelNodeBlockEntity)blockEntity.get();
            Optional<ServerPastelNetwork> connectableNetwork = connectableNode.getServerNetwork();
            if (connectableNodes.containsKey(connectableNetwork)) {
                ((List)connectableNodes.get(connectableNetwork)).add(connectableNode);
            } else {
                ArrayList<PastelNodeBlockEntity> newList = new ArrayList<PastelNodeBlockEntity>();
                newList.add(connectableNode);
                connectableNodes.put(connectableNetwork, newList);
            }
            if (!connectableNetwork.isPresent()) continue;
            if (biggestNetwork == null) {
                biggestNetwork = connectableNetwork.get();
                continue;
            }
            if (connectableNetwork.get().size() <= biggestNetwork.size()) continue;
            biggestNetwork = connectableNetwork.get();
        }
        ServerPastelNetwork network = null;
        int foundNetworkCount = connectableNodes.size() - (connectableNodes.containsKey(Optional.empty()) ? 1 : 0);
        if (!connectableNodes.isEmpty()) {
            if (foundNetworkCount == 0) {
                network = Pastel.getServerInstance().createNetwork((class_3218)this.field_11863, this);
                for (PastelNodeBlockEntity entry : (List)connectableNodes.get(Optional.empty())) {
                    try {
                        network.addEdge(this, entry);
                    }
                    catch (Exception e) {
                        SpectrumCommon.logWarning("PastelNodeBlockEntity can't connectToNearbyNodes: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else if (foundNetworkCount == 1) {
                List nodesWithoutNetwork = null;
                for (Map.Entry entry : connectableNodes.entrySet()) {
                    currentNetwork = (Optional)entry.getKey();
                    if (currentNetwork.equals(Optional.empty())) {
                        nodesWithoutNetwork = (List)entry.getValue();
                        continue;
                    }
                    network = (ServerPastelNetwork)currentNetwork.get();
                    for (PastelNodeBlockEntity currentNode : (List)entry.getValue()) {
                        ((ServerPastelNetwork)currentNetwork.get()).addEdge(currentNode, this);
                    }
                }
                if (nodesWithoutNetwork != null) {
                    for (PastelNodeBlockEntity nodeWithoutNetwork : nodesWithoutNetwork) {
                        network.addEdge(this, nodeWithoutNetwork);
                    }
                }
            } else {
                List biggestNetworkNodes = (List)connectableNodes.get(Optional.of(biggestNetwork));
                for (PastelNodeBlockEntity currentNode : biggestNetworkNodes) {
                    biggestNetwork.addEdge(currentNode, this);
                }
                for (Map.Entry entry : connectableNodes.entrySet()) {
                    currentNetwork = (Optional)entry.getKey();
                    if (currentNetwork.equals(Optional.of(biggestNetwork))) continue;
                    if (currentNetwork.isPresent()) {
                        biggestNetwork.incorporate((ServerPastelNetwork)currentNetwork.get(), this.method_11016());
                    }
                    for (PastelNodeBlockEntity currentNode : (List)entry.getValue()) {
                        biggestNetwork.addEdge(this, currentNode);
                    }
                }
            }
        }
        if (network != null) {
            network.markDirty(this.method_11016());
            if (user instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)user;
                SpectrumAdvancementCriteria.PASTEL_NETWORK_CREATING.trigger(serverPlayer, network);
            }
        }
    }

    public boolean canConnect(PastelNodeBlockEntity first, PastelNodeBlockEntity second) {
        return first != second && first.getColor().equals(second.getColor()) && first.method_11016().method_19771((class_2382)second.method_11016(), 12.0);
    }

    public Optional<ServerPastelNetwork> getServerNetwork() {
        if (this.networkUUID.isPresent()) {
            return Pastel.getServerInstance().getNetwork(this.networkUUID.get());
        }
        return Optional.empty();
    }

    public int getPastelNetworkColor() {
        Optional<class_1767> color = this.getColor();
        return color.isPresent() ? color.get().method_7787() : SpectrumColorHelper.getRandomColor(this.getNodeId().hashCode());
    }

    public void setSpinTicks(long spinTicks) {
        this.spinTicks = spinTicks;
    }

    @Override
    public void markLit() {
        this.lit = true;
    }

    @Override
    public void markLamp() {
        this.lamp = true;
    }

    @Override
    public void markTriggerTransfer() {
        this.triggerTransfer = true;
    }

    @Override
    public void markSensor() {
        this.sensor = true;
    }

    @Override
    public void markTriggered() {
        this.triggered = false;
        this.waiting = true;
    }

    @Override
    public boolean isTriggerTransfer() {
        return this.triggerTransfer;
    }

    @Override
    public boolean isSensor() {
        return this.sensor;
    }

    @Override
    public void applySlotUpgrade(PastelUpgradeSignature upgrade) {
        this.filterSlotRows += this.getNodeType().hasOuterRing() ? upgrade.slotRows : upgrade.slotRows * 2;
    }

    @Override
    public void applySimple(PastelUpgradeSignature upgrade) {
        this.transferCount += upgrade.stack;
        this.transferTime += upgrade.speed;
    }

    @Override
    public void applyCompounding(PastelUpgradeSignature upgrade) {
        this.transferCount = Math.round((float)this.transferCount * upgrade.stackMult);
        this.transferTime = Math.round((float)this.transferTime * upgrade.speedMult);
    }

    @Override
    public void upgradePriority() {
        this.priority = this.priority == PastelNetwork.NodePriority.GENERIC ? PastelNetwork.NodePriority.MODERATE : PastelNetwork.NodePriority.HIGH;
    }

    public String toString() {
        return this.getNodeType().toString() + "-" + this.getColor().toString() + "-" + this.method_11016().toString() + "-" + String.valueOf(this.getNodeId());
    }

    static enum ConnectionState {
        DISCONNECTED,
        CONNECTED,
        ACTIVE,
        INACTIVE;

    }
}

