/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.present;

import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.block.PlayerOwnedWithName;
import de.dafuqs.spectrum.blocks.PlacedItemBlockEntity;
import de.dafuqs.spectrum.blocks.present.PresentBlockItem;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9296;

public class PresentBlockEntity
extends PlacedItemBlockEntity
implements PlayerOwnedWithName {
    protected int openingTicks = 0;

    public PresentBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.PRESENT, pos, state);
    }

    public void triggerAdvancement() {
        class_1657 wrapper;
        UUID ownerUUID;
        class_1657 opener;
        UUID openerUUID = this.getOpenerUUID();
        if (openerUUID != null && (opener = PlayerOwned.getPlayerEntityIfOnline(openerUUID)) != null) {
            Support.grantAdvancementCriterion((class_3222)opener, "gift_or_open_present", "gifted_or_opened_present");
        }
        if ((ownerUUID = this.getOwnerUUID()) != null && (wrapper = PlayerOwned.getPlayerEntityIfOnline(ownerUUID)) != null) {
            Support.grantAdvancementCriterion((class_3222)wrapper, "gift_or_open_present", "gifted_or_opened_present");
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10573("OpeningTick", 99)) {
            this.openingTicks = nbt.method_10550("OpeningTick");
        }
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.openingTicks > 0) {
            nbt.method_10569("OpeningTick", this.openingTicks);
        }
    }

    public int openingTick() {
        ++this.openingTicks;
        this.method_5431();
        return this.openingTicks;
    }

    @Override
    public UUID getOwnerUUID() {
        return PresentBlockItem.getOwner(this.stack).flatMap(class_9296::comp_2411).orElse(null);
    }

    public class_9296 getOwner() {
        return PresentBlockItem.getOwner(this.stack).orElse(null);
    }

    @Override
    public String getOwnerName() {
        return PresentBlockItem.getOwner(this.stack).flatMap(class_9296::comp_2410).orElse("???");
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        PresentBlockItem.setOwner(this.stack, playerEntity);
        this.method_5431();
    }

    public void setOpenerUUID(class_1657 opener) {
        this.ownerUUID = opener.method_5667();
        this.method_5431();
    }

    public UUID getOpenerUUID() {
        return this.ownerUUID;
    }

    public class_1799 retrievePresent() {
        return this.stack.method_7972();
    }

    public Map<Integer, Integer> getColors() {
        return PresentBlockItem.getWrapData(this.stack).colors();
    }

    public List<class_1799> getStacks() {
        return PresentBlockItem.getBundledStacks(this.stack).toList();
    }

    public void setPresent(class_1799 present) {
        this.stack = present.method_7972();
        this.method_5431();
    }

    public boolean isEmpty() {
        return PresentBlockItem.isEmpty(this.stack);
    }
}

