/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.present;

import com.mojang.authlib.GameProfile;
import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.components.WrappedPresentComponent;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_9276;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresentBlockItem
extends class_1747 {
    public PresentBlockItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    protected boolean method_7709(class_1750 context, class_2680 state) {
        return PresentBlockItem.isWrapped(context.method_8041()) && super.method_7709(context, state);
    }

    public static void setOwner(class_1799 itemStack, class_1657 giver) {
        GameProfile profile = new GameProfile(giver.method_5667(), giver.method_5477().getString());
        itemStack.method_57379(class_9334.field_49617, (Object)new class_9296(profile));
    }

    public static Optional<class_9296> getOwner(class_1799 itemStack) {
        return Optional.ofNullable((class_9296)itemStack.method_57824(class_9334.field_49617));
    }

    public static boolean isEmpty(class_1799 itemStack) {
        return ((class_9276)itemStack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289)).method_57429();
    }

    public static boolean isWrapped(class_1799 itemStack) {
        return PresentBlockItem.getWrapData(itemStack) != null;
    }

    @Nullable
    public static WrappedPresentComponent getWrapData(class_1799 itemStack) {
        return (WrappedPresentComponent)itemStack.method_57824(SpectrumDataComponentTypes.WRAPPED_PRESENT);
    }

    public static void wrap(class_1799 itemStack, PresentBlock.WrappingPaper wrappingPaper, Map<Integer, Integer> colors) {
        itemStack.method_57379(SpectrumDataComponentTypes.WRAPPED_PRESENT, (Object)new WrappedPresentComponent(wrappingPaper, colors));
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        int i;
        if (PresentBlockItem.isWrapped(stack)) {
            return false;
        }
        if (action != class_5536.field_27014) {
            return false;
        }
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        class_9276.class_9277 mutable = new class_9276.class_9277(bundleContents);
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            class_1799 itemStack2 = mutable.method_57430();
            if (itemStack2 != null) {
                class_1799 itemStack3 = slot.method_32756(itemStack2);
                mutable.method_57432(itemStack3);
            }
        } else if (itemStack.method_7909().method_31568() && (i = mutable.method_57431(slot, player)) > 0) {
            this.playInsertSound((class_1297)player);
        }
        stack.method_57379(class_9334.field_49650, (Object)mutable.method_57435());
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (PresentBlockItem.isWrapped(stack)) {
            return false;
        }
        if (this.isCraftingInventory(slot)) {
            return false;
        }
        if (action == class_5536.field_27014 && slot.method_32754(player)) {
            class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
            if (bundleContents == null) {
                return false;
            }
            class_9276.class_9277 mutable = new class_9276.class_9277(bundleContents);
            if (other.method_7960()) {
                class_1799 itemStack = mutable.method_57430();
                if (itemStack != null) {
                    this.playRemoveOneSound((class_1297)player);
                    access.method_32332(itemStack);
                }
            } else {
                int i = mutable.method_57432(other);
                if (i > 0) {
                    this.playInsertSound((class_1297)player);
                }
            }
            stack.method_57379(class_9334.field_49650, (Object)mutable.method_57435());
            return true;
        }
        return false;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (PresentBlockItem.isWrapped(itemStack)) {
            super.method_7836(world, user, hand);
        }
        return class_1271.method_22430((Object)itemStack);
    }

    private boolean isCraftingInventory(class_1735 slot) {
        return slot.field_7871 instanceof class_1715;
    }

    public void method_54465(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1657 player) {
        super.method_54465(stack, world, player);
        PresentBlockItem.setOwner(stack, player);
    }

    public boolean method_31567(class_1799 stack) {
        return !PresentBlockItem.isWrapped(stack) && super.method_31567(stack);
    }

    public static Stream<class_1799> getBundledStacks(class_1799 stack) {
        return ((class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289)).method_59707();
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 stack) {
        return !stack.method_57826(class_9334.field_50074) && !stack.method_57826(class_9334.field_49638) && !PresentBlockItem.isWrapped(stack) ? Optional.ofNullable((class_9276)stack.method_57824(class_9334.field_49650)).map(class_5631::new) : Optional.empty();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        boolean wrapped = PresentBlockItem.isWrapped(stack);
        if (wrapped) {
            Optional<class_9296> gifter = PresentBlockItem.getOwner(stack);
            if (gifter.isPresent()) {
                gifter.get().comp_2410().ifPresent(name -> tooltip.add((class_2561)class_2561.method_43469((String)"block.spectrum.present.tooltip.wrapped.giver", (Object[])new Object[]{name}).method_27692(class_124.field_1080)));
                if (type.method_8035()) {
                    gifter.get().comp_2411().ifPresent(id -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(id))).method_27692(class_124.field_1080)));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.wrapped").method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.description").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.description2").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{PresentBlockItem.getBundledStacks(stack).count(), 64}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_31568() {
        return false;
    }
}

