/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.redstone;

import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.redstone.DetectorBlock;
import de.dafuqs.spectrum.blocks.redstone.PlayerDetectorBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class PlayerDetectorBlock
extends DetectorBlock
implements class_2343 {
    public static final MapCodec<PlayerDetectorBlock> CODEC = PlayerDetectorBlock.method_54094(PlayerDetectorBlock::new);

    public PlayerDetectorBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public MapCodec<? extends PlayerDetectorBlock> method_53969() {
        return CODEC;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (!world.field_9236 && placer instanceof class_1657 && (blockEntity = world.method_8321(pos)) instanceof PlayerDetectorBlockEntity) {
            ((PlayerDetectorBlockEntity)blockEntity).setOwner((class_1657)placer);
        }
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (player.method_5715()) {
            String ownerName = this.getOwnerName(world, pos);
            if (ownerName != null && !ownerName.isBlank()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.player_detector.owner", (Object[])new Object[]{ownerName}), true);
            }
            return class_1269.field_21466;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    protected void updateState(class_2680 state, class_1937 world, class_2338 pos) {
        List players = world.method_18023((class_5575)class_1299.field_6097, this.getDetectionBox(pos), player -> player.method_5805() && !player.method_7325());
        int power = 0;
        if (!players.isEmpty()) {
            power = 8;
            UUID ownerUUID = this.getOwnerUUID(world, pos);
            if (ownerUUID != null) {
                for (class_1657 playerEntity : players) {
                    if (!playerEntity.method_5667().equals(ownerUUID)) continue;
                    power = 15;
                    break;
                }
            }
        }
        int n = power = (Boolean)state.method_11654((class_2769)INVERTED) != false ? 15 - power : power;
        if ((Integer)state.method_11654((class_2769)POWER) != power) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @Override
    int getUpdateFrequencyTicks() {
        return 20;
    }

    private UUID getOwnerUUID(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PlayerDetectorBlockEntity) {
            return ((PlayerDetectorBlockEntity)blockEntity).getOwnerUUID();
        }
        return null;
    }

    private String getOwnerName(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PlayerDetectorBlockEntity) {
            return ((PlayerDetectorBlockEntity)blockEntity).getOwnerName();
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PlayerDetectorBlockEntity(pos, state);
    }
}

