/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.shooting_star;

import de.dafuqs.spectrum.blocks.shooting_star.ShootingStar;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlock;
import de.dafuqs.spectrum.components.ShootingStarComponent;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class ShootingStarItem
extends class_1747
implements ShootingStar {
    private final ShootingStar.Variant shootingStarType;

    public ShootingStarItem(ShootingStarBlock block, class_1792.class_1793 settings) {
        super((class_2248)block, settings);
        this.shootingStarType = block.shootingStarType;
    }

    @NotNull
    public static class_1799 getWithRemainingHits(@NotNull ShootingStarItem shootingStarItem, int remainingHits, boolean hardened) {
        return ShootingStarItem.getWithRemainingHits(shootingStarItem.method_7854(), remainingHits, hardened);
    }

    @NotNull
    public static class_1799 getWithRemainingHits(@NotNull class_1799 stack, int remainingHits, boolean hardened) {
        ShootingStarComponent component = new ShootingStarComponent(remainingHits, hardened);
        stack.method_57379(SpectrumDataComponentTypes.SHOOTING_STAR, (Object)component);
        return stack;
    }

    public class_1269 method_7884(@NotNull class_1838 context) {
        if (context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        class_1937 world = context.method_8045();
        if (!world.field_9236) {
            class_1799 itemStack = context.method_8041();
            class_243 hitPos = context.method_17698();
            class_1657 user = context.method_8036();
            ShootingStarEntity shootingStarEntity = this.getEntityForStack(context.method_8045(), hitPos, itemStack);
            shootingStarEntity.method_36456(user.method_36454());
            if (!world.method_8587((class_1297)shootingStarEntity, shootingStarEntity.method_5829())) {
                return class_1269.field_5814;
            }
            world.method_8649((class_1297)shootingStarEntity);
            world.method_33596((class_1297)user, (class_6880)class_5712.field_28738, context.method_8037());
            if (!user.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @NotNull
    public ShootingStarEntity getEntityForStack(@NotNull class_1937 world, class_243 pos, class_1799 stack) {
        return new ShootingStarEntity(world, pos.field_1352, pos.field_1351, pos.field_1350, this.shootingStarType, true, ShootingStarItem.getRemainingHits(stack), ShootingStarItem.isHardened(stack));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (ShootingStarItem.isHardened(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.shooting_star.tooltip.hardened").method_27692(class_124.field_1080));
        }
    }

    public ShootingStar.Variant getShootingStarType() {
        return this.shootingStarType;
    }

    public static boolean isHardened(class_1799 stack) {
        return ((ShootingStarComponent)stack.method_57825(SpectrumDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT)).hardened();
    }

    public static int getRemainingHits(@NotNull class_1799 stack) {
        return ((ShootingStarComponent)stack.method_57825(SpectrumDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT)).remainingHits();
    }

    public static void setHardened(class_1799 stack) {
        ShootingStarComponent component = (ShootingStarComponent)stack.method_57825(SpectrumDataComponentTypes.SHOOTING_STAR, (Object)ShootingStarComponent.DEFAULT);
        component = component == null ? new ShootingStarComponent(ShootingStarComponent.DEFAULT.remainingHits(), true) : new ShootingStarComponent(component.remainingHits(), true);
        stack.method_57379(SpectrumDataComponentTypes.SHOOTING_STAR, (Object)component);
    }
}

