/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.spirit_instiller;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.mojang.serialization.MapCodec;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritInstillerBlock
extends InWorldInteractionBlock {
    public static final MapCodec<SpiritInstillerBlock> CODEC = SpiritInstillerBlock.method_54094(SpiritInstillerBlock::new);
    public static final List<class_2382> UPGRADE_BLOCK_OFFSETS = List.of(new class_2382(4, -1, 4), new class_2382(-4, -1, 4), new class_2382(4, -1, -4), new class_2382(-4, -1, -4));

    public SpiritInstillerBlock(class_4970.class_2251 settings) {
        super(settings);
        Upgradeable.registerUpgradePosOffsets(UPGRADE_BLOCK_OFFSETS);
    }

    public MapCodec<? extends SpiritInstillerBlock> method_53969() {
        return CODEC;
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        if (world.field_9236) {
            ModonomiconHelper.clearRenderedMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.SPIRIT_INSTILLER));
        }
    }

    public static boolean verifyStructure(class_1937 world, @NotNull class_2338 blockPos, @Nullable class_3222 serverPlayerEntity, @NotNull SpiritInstillerBlockEntity instiller) {
        Multiblock multiblock = SpectrumMultiblocks.get(SpectrumMultiblocks.SPIRIT_INSTILLER);
        class_2470 lastBlockRotation = instiller.getMultiblockRotation();
        boolean valid = false;
        int offset = -4;
        class_2470 checkRotation = lastBlockRotation;
        for (int i = 0; i < class_2470.values().length; ++i) {
            valid = multiblock.validate(world, blockPos.method_10087(1).method_10079(Support.directionFromRotation(checkRotation), offset), checkRotation);
            if (valid) {
                if (i == 0) break;
                instiller.setMultiblockRotation(checkRotation);
                break;
            }
            checkRotation = class_2470.values()[(checkRotation.ordinal() + 1) % class_2470.values().length];
        }
        instiller.setValidStructure(valid);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            Multiblock currentMultiBlock = MultiblockPreviewRenderer.getMultiblock();
            if (currentMultiBlock == multiblock) {
                lastBlockRotation = class_2470.values()[(MultiblockPreviewRenderer.getFacingRotation().ordinal() + 1) % class_2470.values().length];
                instiller.setMultiblockRotation(lastBlockRotation);
            }
            ModonomiconHelper.renderMultiblock(SpectrumMultiblocks.get(SpectrumMultiblocks.SPIRIT_INSTILLER), SpectrumMultiblocks.SPIRIT_INSTILLER_TEXT, blockPos.method_10087(2).method_10079(Support.directionFromRotation(lastBlockRotation), offset), lastBlockRotation);
        } else {
            SpiritInstillerBlock.scatterContents(world, blockPos);
        }
        return valid;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpiritInstillerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return SpiritInstillerBlock.method_31618(type, SpectrumBlockEntities.SPIRIT_INSTILLER, (class_5558)(world.field_9236 ? SpiritInstillerBlockEntity::clientTick : SpiritInstillerBlockEntity::serverTick));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            SpiritInstillerBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public class_9062 method_55765(class_1799 handStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        SpiritInstillerBlockEntity spiritInstillerBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (world.field_9236) {
            if (blockEntity instanceof SpiritInstillerBlockEntity) {
                SpiritInstillerBlockEntity spiritInstillerBlockEntity2 = (SpiritInstillerBlockEntity)blockEntity;
                SpiritInstillerBlock.verifyStructure(world, pos, null, spiritInstillerBlockEntity2);
            }
            return class_9062.field_47728;
        }
        if (blockEntity instanceof SpiritInstillerBlockEntity && SpiritInstillerBlock.verifyStructure(world, pos, (class_3222)player, spiritInstillerBlockEntity = (SpiritInstillerBlockEntity)blockEntity) && this.exchangeStack(world, pos, player, hand, handStack, spiritInstillerBlockEntity)) {
            spiritInstillerBlockEntity.setOwner(player);
        }
        return class_9062.field_47729;
    }
}

