/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.structure;

import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.blocks.item_roundel.ItemRoundelBlockEntity;
import de.dafuqs.spectrum.blocks.structure.PreservationControllerBlock;
import de.dafuqs.spectrum.blocks.structure.PreservationControllerBlockEntity;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class PreservationRoundelBlockEntity
extends ItemRoundelBlockEntity
implements PlayerOwned {
    protected static final int INVENTORY_SIZE = 6;
    private UUID lastInteractedPlayer;
    protected class_2382 controllerOffset = new class_2382(2, 2, 2);
    protected List<class_1792> requiredItems = new ArrayList<class_1792>();
    protected List<class_2382> otherRoundelOffsets = new ArrayList<class_2382>();

    public PreservationRoundelBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends ItemRoundelBlockEntity>)SpectrumBlockEntities.PRESERVATION_ROUNDEL, pos, state, 6);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.requiredItems = new ArrayList<class_1792>();
        if (nbt.method_10573("RequiredItems", 9)) {
            for (class_2520 e : nbt.method_10554("RequiredItems", 8)) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)e.method_10714()));
                if (item == class_1802.field_8162) continue;
                this.requiredItems.add(item);
            }
        }
        this.controllerOffset = null;
        if (nbt.method_10573("ControllerOffset", 11)) {
            int[] offset = nbt.method_10561("ControllerOffset");
            this.controllerOffset = new class_2382(offset[0], offset[1], offset[2]);
        }
        this.otherRoundelOffsets = new ArrayList<class_2382>();
        if (nbt.method_10573("OtherRoundelOffsets", 9)) {
            for (class_2520 e : nbt.method_10554("OtherRoundelOffsets", 11)) {
                int[] intArray = ((class_2495)e).method_10588();
                this.otherRoundelOffsets.add(new class_2382(intArray[0], intArray[1], intArray[2]));
            }
        }
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.requiredItems.isEmpty()) {
            class_2499 itemList = new class_2499();
            for (class_1792 requiredItem : this.requiredItems) {
                itemList.add((Object)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)requiredItem).toString()));
            }
            nbt.method_10566("RequiredItems", (class_2520)itemList);
        }
        if (this.controllerOffset != null) {
            nbt.method_10539("ControllerOffset", new int[]{this.controllerOffset.method_10263(), this.controllerOffset.method_10264(), this.controllerOffset.method_10260()});
        }
        if (!this.otherRoundelOffsets.isEmpty()) {
            class_2499 offsetList = new class_2499();
            for (class_2382 offset : this.otherRoundelOffsets) {
                offsetList.add((Object)new class_2495(new int[]{offset.method_10263(), offset.method_10264(), offset.method_10260()}));
            }
            nbt.method_10566("OtherRoundelOffsets", (class_2520)offsetList);
        }
    }

    public boolean method_11011() {
        return true;
    }

    @Override
    public void method_5431() {
        class_2586 blockEntity;
        super.method_5431();
        if (this.field_11863 instanceof class_3218 && this.controllerOffset != null && this.inventoryAndConnectedOnesMatchRequirement() && (blockEntity = this.field_11863.method_8321(Support.directionalOffset(this.field_11867, this.controllerOffset, (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)PreservationControllerBlock.FACING)))) instanceof PreservationControllerBlockEntity) {
            PreservationControllerBlockEntity controller = (PreservationControllerBlockEntity)blockEntity;
            controller.openExit();
        }
    }

    public boolean inventoryAndConnectedOnesMatchRequirement() {
        if (!this.inventoryMatchesRequirement() || this.field_11863 == null) {
            return false;
        }
        for (class_2382 otherRoundelOffset : this.otherRoundelOffsets) {
            PreservationRoundelBlockEntity preservationRoundelBlockEntity;
            class_2338 otherRoundelPos = Support.directionalOffset(this.field_11867, otherRoundelOffset, (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)PreservationControllerBlock.FACING));
            class_2586 class_25862 = this.field_11863.method_8321(otherRoundelPos);
            if (!(class_25862 instanceof PreservationRoundelBlockEntity) || (preservationRoundelBlockEntity = (PreservationRoundelBlockEntity)class_25862).inventoryMatchesRequirement()) continue;
            return false;
        }
        return true;
    }

    public boolean inventoryMatchesRequirement() {
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        ArrayList<class_1792> requirements = new ArrayList<class_1792>(this.requiredItems);
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 slotStack = this.method_5438(i);
            if (slotStack.method_7960()) continue;
            int usedCount = 0;
            for (int j = 0; j < requirements.size(); ++j) {
                if (!slotStack.method_31574((class_1792)requirements.get(j))) continue;
                requirements.remove(j);
                --j;
                if (slotStack.method_7947() == ++usedCount) break;
            }
            if (usedCount == slotStack.method_7947()) continue;
            return false;
        }
        if (requirements.isEmpty() && this.field_11863 != null) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)this.field_11863, class_243.method_24953((class_2382)this.field_11867), (class_2394)class_2398.field_11211, 10, new class_243(0.25, 0.5, 0.25), new class_243(0.1, 0.1, 0.1));
            this.field_11863.method_8396(null, this.field_11867, SpectrumSoundEvents.NEW_RECIPE, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean renderStacksAsIndividualItems() {
        return true;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.lastInteractedPlayer;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.lastInteractedPlayer = playerEntity.method_5667();
        this.method_5431();
    }
}

