/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.upgrade;

import com.google.common.collect.Sets;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.blocks.upgrade.UpgradeBlock;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Upgradeable {
    public static final Set<class_2382> POSSIBLE_UPGRADE_POS_OFFSETS = Sets.newTreeSet();

    @NotNull
    public static UpgradeHolder calculateUpgradeMods4(class_1937 world, @NotNull class_2338 blockPos, int offsetHorizontal, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        posList.add(blockPos.method_10069(offsetHorizontal, offsetUp, offsetHorizontal));
        posList.add(blockPos.method_10069(offsetHorizontal, offsetUp, -offsetHorizontal));
        posList.add(blockPos.method_10069(-offsetHorizontal, offsetUp, offsetHorizontal));
        posList.add(blockPos.method_10069(-offsetHorizontal, offsetUp, -offsetHorizontal));
        return Upgradeable.calculateUpgrades(world, blockPos, posList, advancementPlayerUUID);
    }

    @NotNull
    public static UpgradeHolder calculateUpgradeMods2(class_1937 world, class_2338 blockPos, @NotNull class_2470 multiblockRotation, int offsetHorizontal, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        return Upgradeable.calculateUpgradeMods2(world, blockPos, multiblockRotation, offsetHorizontal, offsetHorizontal, offsetUp, advancementPlayerUUID);
    }

    @NotNull
    public static UpgradeHolder calculateUpgradeMods2(class_1937 world, class_2338 blockPos, @NotNull class_2470 multiblockRotation, int offsetSide, int offsetBack, int offsetUp, @Nullable UUID advancementPlayerUUID) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        switch (multiblockRotation) {
            case field_11467: {
                positions.add(blockPos.method_10069(-offsetSide, offsetUp, offsetBack));
                positions.add(blockPos.method_10069(offsetSide, offsetUp, offsetBack));
                break;
            }
            case field_11463: {
                positions.add(blockPos.method_10069(-offsetBack, offsetUp, offsetSide));
                positions.add(blockPos.method_10069(-offsetBack, offsetUp, -offsetSide));
                break;
            }
            case field_11464: {
                positions.add(blockPos.method_10069(-offsetSide, offsetUp, -offsetBack));
                positions.add(blockPos.method_10069(offsetSide, offsetUp, -offsetBack));
                break;
            }
            default: {
                positions.add(blockPos.method_10069(offsetBack, offsetUp, -offsetSide));
                positions.add(blockPos.method_10069(offsetBack, offsetUp, offsetSide));
            }
        }
        return Upgradeable.calculateUpgrades(world, blockPos, positions, advancementPlayerUUID);
    }

    @NotNull
    private static UpgradeHolder calculateUpgrades(class_1937 world, class_2338 blockPos, @NotNull List<class_2338> positions, @Nullable UUID advancementPlayerUUID) {
        class_3222 player;
        HashMap<UpgradeType, Integer> upgradeMods = new HashMap<UpgradeType, Integer>();
        for (UpgradeType upgradeType : UpgradeType.values()) {
            upgradeMods.put(upgradeType, 0);
        }
        int upgradeCount = 0;
        for (class_2338 offsetPos : positions) {
            class_2248 block = world.method_8320(offsetPos).method_26204();
            if (!(block instanceof UpgradeBlock)) continue;
            UpgradeBlock upgradeBlock = (UpgradeBlock)block;
            UpgradeType upgradeType = upgradeBlock.getUpgradeType();
            int upgradeMod = upgradeBlock.getUpgradeMod();
            upgradeMods.put(upgradeType, upgradeMods.get((Object)upgradeType) + upgradeMod);
            ++upgradeCount;
        }
        if (advancementPlayerUUID != null && !world.field_9236 && (player = (class_3222)PlayerOwned.getPlayerEntityIfOnline(advancementPlayerUUID)) != null) {
            SpectrumAdvancementCriteria.UPGRADE_PLACING.trigger(player, (class_3218)world, blockPos, upgradeCount, upgradeMods);
        }
        return new UpgradeHolder(upgradeMods);
    }

    public void resetUpgrades();

    public void calculateUpgrades();

    public UpgradeHolder getUpgradeHolder();

    public List<class_2382> getUpgradePosOffsets();

    public static void registerUpgradePosOffsets(List<class_2382> offsets) {
        POSSIBLE_UPGRADE_POS_OFFSETS.addAll(offsets);
    }

    public static class UpgradeHolder {
        private final Map<UpgradeType, Integer> upgrades;

        public UpgradeHolder() {
            this.upgrades = new HashMap<UpgradeType, Integer>();
            for (UpgradeType upgradeType : UpgradeType.values()) {
                this.upgrades.put(upgradeType, 0);
            }
        }

        public UpgradeHolder(Map<UpgradeType, Integer> upgrades) {
            this.upgrades = upgrades;
        }

        public class_2499 toNbt() {
            class_2499 nbtList = new class_2499();
            if (!this.upgrades.isEmpty()) {
                for (Map.Entry<UpgradeType, Integer> upgrade : this.upgrades.entrySet()) {
                    if (upgrade.getValue() <= 0) continue;
                    class_2487 upgradeCompound = new class_2487();
                    upgradeCompound.method_10582("Variant", upgrade.getKey().toString());
                    upgradeCompound.method_10548("Power", (float)upgrade.getValue().intValue());
                    nbtList.add((Object)upgradeCompound);
                }
            }
            return nbtList;
        }

        public static UpgradeHolder fromNbt(@NotNull class_2499 nbtList) {
            HashMap<UpgradeType, Integer> map = new HashMap<UpgradeType, Integer>();
            for (UpgradeType upgradeType : UpgradeType.values()) {
                map.put(upgradeType, 0);
            }
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                UpgradeType upgradeType = UpgradeType.valueOf(nbtCompound.method_10558("Variant"));
                int upgradeMod = nbtCompound.method_10550("Power");
                map.put(upgradeType, upgradeMod);
            }
            return new UpgradeHolder(map);
        }

        public int getRawValue(UpgradeType upgradeType) {
            return this.upgrades.get((Object)upgradeType);
        }

        public float getEffectiveValue(UpgradeType upgradeType) {
            return 1.0f + (float)this.upgrades.get((Object)upgradeType).intValue() / (float)upgradeType.getEffectivityDivisor();
        }

        public long getEffectiveCost(UpgradeType upgradeType) {
            return 1L << this.upgrades.get((Object)upgradeType);
        }

        public long getEffectiveCostUsingEfficiency(UpgradeType upgradeType) {
            int efficiencyMod = this.getRawValue(UpgradeType.EFFICIENCY);
            return 1L << Math.max(this.upgrades.get((Object)upgradeType) - efficiencyMod, 0);
        }

        public long getEffectiveCostUsingEfficiency(long amount) {
            int efficiencyMod = this.getRawValue(UpgradeType.EFFICIENCY);
            return Math.max(1L, amount >> efficiencyMod);
        }

        public Iterable<? extends Map.Entry<UpgradeType, Integer>> entrySet() {
            return this.upgrades.entrySet();
        }
    }

    public static enum UpgradeType {
        SPEED(1),
        EFFICIENCY(16),
        YIELD(16),
        EXPERIENCE(1);

        private final int effectivityDivisor;

        private UpgradeType(int effectivityDivisor) {
            this.effectivityDivisor = effectivityDivisor;
        }

        public int getEffectivityDivisor() {
            return this.effectivityDivisor;
        }
    }
}

