/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.entity.PlayerEntityAccessor;
import de.dafuqs.spectrum.api.item.SleepAlteringItem;
import de.dafuqs.spectrum.networking.s2c_payloads.SyncMentalPresencePayload;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class MiscPlayerDataComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final ComponentKey<MiscPlayerDataComponent> MISC_PLAYER_DATA_COMPONENT = ComponentRegistry.getOrCreate((class_2960)SpectrumCommon.locate("misc_player_data"), MiscPlayerDataComponent.class);
    private final class_1657 player;
    private int ticksBeforeSleep = -1;
    private int sleepingWindow = -1;
    private int sleepInvincibility;
    private double lastSyncedSleepPotency = -2.0;
    private Optional<SleepAlteringItem> sleepConsumable = Optional.empty();
    private boolean isLunging;
    private boolean bHopWindow;
    private boolean perfectCounter;
    private int parryTicks;

    public MiscPlayerDataComponent(class_1657 player) {
        this.player = player;
    }

    public void tick() {
        this.tickSleep();
        this.tickSwordMechanics();
    }

    public void serverTick() {
        super.serverTick();
        double fortitude = this.player.method_45325(SpectrumEntityAttributes.MENTAL_PRESENCE);
        if (this.lastSyncedSleepPotency != fortitude) {
            this.lastSyncedSleepPotency = fortitude;
            SyncMentalPresencePayload.sendMentalPresenceSync((class_3222)this.player, fortitude);
        }
    }

    private boolean isInModifiedMotionState() {
        return this.player.method_24828() || this.player.method_5681() || this.player.method_6128() || this.player.method_31549().field_7479;
    }

    public void initiateLungeState() {
        this.isLunging = true;
        this.bHopWindow = true;
    }

    public void endLunge() {
        this.isLunging = false;
        this.bHopWindow = false;
    }

    public boolean isLunging() {
        return this.isLunging;
    }

    public void setParryTicks(int ticks) {
        this.parryTicks = ticks;
    }

    public void markForPerfectCounter() {
        this.perfectCounter = true;
    }

    public boolean consumePerfectCounter() {
        if (this.perfectCounter) {
            this.perfectCounter = false;
            return true;
        }
        return false;
    }

    public boolean isParrying() {
        return this.parryTicks > 0;
    }

    private void tickSwordMechanics() {
        if (this.parryTicks > 1) {
            --this.parryTicks;
        } else if (this.parryTicks == 1) {
            this.parryTicks = 0;
            this.consumePerfectCounter();
        }
        if (!this.bHopWindow && this.isLunging) {
            if (this.isInModifiedMotionState()) {
                this.isLunging = false;
            } else {
                this.bHopWindow = true;
            }
        } else if (this.isLunging && this.isInModifiedMotionState()) {
            this.bHopWindow = false;
        }
    }

    public float getFrictionModifiers() {
        return this.isLunging ? 0.04f : 0.0f;
    }

    private void tickSleep() {
        if (this.ticksBeforeSleep > 0) {
            --this.ticksBeforeSleep;
            if (this.ticksBeforeSleep == 0) {
                this.player.method_18403(this.player.method_24515());
                ((PlayerEntityAccessor)this.player).setSleepTimer(0);
                class_1937 world = this.player.method_37908();
                if (!world.method_8608()) {
                    ((class_3218)world).method_8448();
                }
            }
        }
        if (this.sleepInvincibility > 0) {
            --this.sleepInvincibility;
        }
        if (this.ticksBeforeSleep != 0) {
            return;
        }
        if (this.sleepingWindow > 0) {
            --this.sleepingWindow;
            if (this.sleepingWindow == 0) {
                this.failSleep();
            }
        }
    }

    private void failSleep() {
        if (!this.player.method_37908().method_8608()) {
            this.player.method_18400();
            this.resetSleepingState(true);
        }
    }

    public boolean isSleeping() {
        return this.ticksBeforeSleep == 0 && this.sleepingWindow > 0;
    }

    public boolean shouldLieDown() {
        return this.ticksBeforeSleep > 0;
    }

    public void notifyHit() {
        if (this.sleepInvincibility <= 0) {
            this.resetSleepingState(true);
        }
    }

    public void resetSleepingState(boolean canApplyPenalties) {
        if (this.ticksBeforeSleep == -1) {
            return;
        }
        this.ticksBeforeSleep = -1;
        this.sleepingWindow = -1;
        this.sleepInvincibility = -1;
        if (canApplyPenalties) {
            this.sleepConsumable.ifPresent(p -> p.applyPenalties(this.player));
        }
        this.sleepConsumable = Optional.empty();
    }

    public void setSleepTimers(int wait, int window, int invulnTicks) {
        this.ticksBeforeSleep = wait;
        this.sleepingWindow = window;
        this.sleepInvincibility = invulnTicks;
    }

    public void setLastSleepItem(@NotNull SleepAlteringItem item) {
        this.sleepConsumable = Optional.of(item);
    }

    public void readFromNbt(class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 wrapperLookup) {
        this.ticksBeforeSleep = tag.method_10550("ticksBeforeSleep");
        this.sleepingWindow = tag.method_10550("sleepingWindow");
        this.sleepInvincibility = tag.method_10550("sleepInvincibility");
        if (tag.method_10545("sleepConsumable")) {
            this.sleepConsumable = Optional.of((SleepAlteringItem)class_7923.field_41178.method_10223(class_2960.method_12829((String)tag.method_10558("sleepConsumable"))));
        }
    }

    public void writeToNbt(class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 wrapperLookup) {
        tag.method_10569("ticksBeforeSleep", this.ticksBeforeSleep);
        tag.method_10569("sleepingWindow", this.sleepingWindow);
        tag.method_10569("sleepInvincibility", this.sleepInvincibility);
        this.sleepConsumable.map(sleepPenalizingItem -> (class_1792)sleepPenalizingItem).map(class_1792::method_40131).flatMap(class_6880.class_6883::method_40230).map(class_5321::method_29177).ifPresent(id -> tag.method_10582("sleepConsumable", id.toString()));
    }

    public static MiscPlayerDataComponent get(@NotNull class_1657 player) {
        return (MiscPlayerDataComponent)MISC_PLAYER_DATA_COMPONENT.get((Object)player);
    }

    public void setLastSyncedSleepPotency(double lastSyncedSleepPotency) {
        this.lastSyncedSleepPotency = lastSyncedSleepPotency;
    }

    public double getLastSyncedSleepPotency() {
        return this.lastSyncedSleepPotency;
    }
}

