/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.sound.OnPrimordialFireSoundInstance;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class OnPrimordialFireComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final float BASE_PERCENT_DAMAGE = 0.1f;
    @Environment(value=EnvType.CLIENT)
    private static Optional<OnPrimordialFireSoundInstance> soundInstance;
    public static final ComponentKey<OnPrimordialFireComponent> ON_PRIMORDIAL_FIRE_COMPONENT;
    private class_1309 provider;
    private long primordialFireTicks = 0L;

    public OnPrimordialFireComponent() {
    }

    public OnPrimordialFireComponent(class_1309 entity) {
        this.provider = entity;
    }

    public void writeToNbt(@NotNull class_2487 tag, @NotNull class_7225.class_7874 wrapperLookup) {
        if (this.primordialFireTicks > 0L) {
            tag.method_10544("ticks", this.primordialFireTicks);
        }
    }

    public void readFromNbt(class_2487 tag, @NotNull class_7225.class_7874 wrapperLookup) {
        this.primordialFireTicks = tag.method_10573("ticks", 4) ? tag.method_10537("ticks") : 0L;
    }

    public static void setPrimordialFireTicks(class_1309 livingEntity, int ticks) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        component.primordialFireTicks = ticks;
        ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
    }

    public static void addPrimordialFireTicks(class_1309 livingEntity, int ticks) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        int i = SpectrumEnchantmentHelper.getEquipmentLevel((class_7225.class_7874)livingEntity.method_37908().method_30349(), (class_5321<class_1887>)class_1893.field_9095, livingEntity);
        if (i > 0) {
            ticks -= class_3532.method_15375((float)((float)(ticks * i) * 0.15f));
        }
        component.primordialFireTicks += (long)ticks;
        ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
    }

    public static boolean isOnPrimordialFire(class_1309 livingEntity) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        return component.primordialFireTicks > 0L;
    }

    public static boolean putOut(class_1309 livingEntity) {
        OnPrimordialFireComponent component = (OnPrimordialFireComponent)ON_PRIMORDIAL_FIRE_COMPONENT.get((Object)livingEntity);
        if (component.primordialFireTicks > 0L) {
            component.primordialFireTicks = 0L;
            ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)component.provider);
            return true;
        }
        return false;
    }

    public void serverTick() {
        if (this.provider.method_5864().method_20210(SpectrumEntityTypeTags.PRIMORDIAL_FIRE_IMMUNE)) {
            this.primordialFireTicks = 0L;
            ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)this.provider);
            return;
        }
        if (this.primordialFireTicks > 0L) {
            if (!this.isAffectingConstruct()) {
                float damageScaling = this.getDamage(this.provider);
                this.provider.method_5643(SpectrumDamageTypes.primordialFire(this.provider.method_37908()), damageScaling);
            } else if (this.provider.field_6012 % 20 == 0) {
                this.provider.method_5643(SpectrumDamageTypes.primordialFire(this.provider.method_37908()), 2.0f);
            }
            this.primordialFireTicks -= this.provider.method_5861(class_3486.field_15517) > 0.0 ? 3L : 1L;
            if (this.primordialFireTicks <= 0L) {
                ON_PRIMORDIAL_FIRE_COMPONENT.sync((Object)this.provider);
            }
        }
    }

    public boolean isAffectingConstruct() {
        return this.provider.method_5864().method_20210(SpectrumEntityTypeTags.SOULLESS);
    }

    public float getDamage(class_1309 entity) {
        float baseDamage = 0.1f;
        if (entity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            baseDamage /= 20.0f;
        }
        float fireImmunityMultiplier = entity.method_5753() ? 0.25f : 1.0f;
        return baseDamage * fireImmunityMultiplier * this.provider.method_6063();
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        if (this.primordialFireTicks > 0L) {
            double fluidHeight;
            if (this.provider.equals((Object)class_310.method_1551().field_1724) && this.primordialFireTicks > 2L && soundInstance.isEmpty()) {
                soundInstance = Optional.of(new OnPrimordialFireSoundInstance((class_1657)this.provider));
                class_310.method_1551().method_1483().method_4873((class_1113)soundInstance.get());
            }
            if ((fluidHeight = this.provider.method_5861(class_3486.field_15517)) > 0.0) {
                class_1937 world = this.provider.method_37908();
                class_5819 random = world.field_9229;
                class_243 pos = this.provider.method_19538();
                for (int i = 0; i < 2; ++i) {
                    world.method_8406((class_2394)class_2398.field_11241, this.provider.method_23322(1.0), pos.method_10214() + Math.min(fluidHeight, (double)this.provider.method_17682()) * (double)random.method_43057(), this.provider.method_23325(1.0), 0.0, 0.04, 0.0);
                    world.method_8406((class_2394)class_2398.field_11251, this.provider.method_23322(1.0), pos.method_10214() + Math.min(fluidHeight, (double)this.provider.method_17682()) * (double)random.method_43057(), this.provider.method_23325(1.0), 0.0, 0.04, 0.0);
                }
                if (world.field_9229.method_43048(12) == 0) {
                    this.provider.method_5783(class_3417.field_15102, 0.2f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f);
                }
            }
        } else if (this.provider.equals((Object)class_310.method_1551().field_1724) && soundInstance.isPresent()) {
            soundInstance = Optional.empty();
        }
    }

    static {
        if (EnvType.CLIENT == FabricLoader.getInstance().getEnvironmentType()) {
            soundInstance = Optional.empty();
        }
        ON_PRIMORDIAL_FIRE_COMPONENT = ComponentRegistry.getOrCreate((class_2960)SpectrumCommon.locate("on_primordial_fire"), OnPrimordialFireComponent.class);
    }
}

