/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.dafuqs.fractal.api.ItemSubGroup;
import de.dafuqs.revelationary.RevelationRegistry;
import de.dafuqs.revelationary.advancement_criteria.AdvancementCountCriterion;
import de.dafuqs.revelationary.advancement_criteria.AdvancementGottenCriterion;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.api.recipe.GatedRecipe;
import de.dafuqs.spectrum.blocks.PlacedItemBlock;
import de.dafuqs.spectrum.blocks.deeper_down.flora.WeepingGalaFrondsBlock;
import de.dafuqs.spectrum.blocks.gemstone.SpectrumBuddingBlock;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.recipe.pedestal.BuiltinGemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.SpectrumItemGroups;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import net.minecraft.class_9695;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class SanityCommand {
    private static final class_2960 WIP_ADVANCEMENT_ID = SpectrumCommon.locate("__wip");
    private static final List<class_2960> ADVANCEMENT_GATING_WARNING_WHITELIST = List.of(SpectrumCommon.locate("find_preservation_ruins"), SpectrumCommon.locate("fail_to_glitch_into_preservation_ruin"), SpectrumCommon.locate("midgame/craft_blacklisted_memory_success"), SpectrumCommon.locate("lategame/collect_myceylon"), SpectrumCommon.locate("lategame/strike_up_hummingstone_hymn"));
    private static final List<class_2960> GUIDEBOOK_WARNING_WHITELIST = List.of(SpectrumCommon.locate("cuisine/cookbooks/brewers_handbook"));

    public static void register(LiteralCommandNode<class_2168> root) {
        LiteralCommandNode sanity = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sanity").requires(source -> source.method_9259(2))).executes(context -> SanityCommand.execute((class_2168)context.getSource(), "spectrum"))).build();
        ArgumentCommandNode modId = ((RequiredArgumentBuilder)class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).executes(context -> SanityCommand.execute((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"mod_id")))).build();
        sanity.addChild((CommandNode)modId);
        root.addChild((CommandNode)sanity);
    }

    private static int execute(class_2168 source, String modId) {
        Object id;
        class_6880 entry;
        class_9304 enchantments;
        class_1799 output;
        GatedSpectrumRecipe recipe;
        class_5321 registryKey;
        class_5455 registryManager = source.method_30497();
        SpectrumCommon.logInfo("##### SANITY CHECK START ######");
        for (Map.Entry entry2 : class_7923.field_41175.method_29722()) {
            class_2680 blockState;
            registryKey = (class_5321)entry2.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (blockState = ((class_2248)entry2.getValue()).method_9564()).method_26204().method_36555() <= 0.0f || blockState.method_26164(class_3481.field_33715) || blockState.method_26164(class_3481.field_33713) || blockState.method_26164(class_3481.field_33716) || blockState.method_26164(class_3481.field_33714) || blockState.method_26164(class_3481.field_44469) || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK)) continue;
            SpectrumCommon.logWarning("[SANITY: Mineable Tags] Block " + String.valueOf(registryKey.method_29177()) + " is not contained in a any vanilla mineable tag.");
        }
        for (Map.Entry entry3 : class_7923.field_41175.method_29722()) {
            class_2248 block;
            registryKey = (class_5321)entry3.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (block = (class_2248)entry3.getValue()) instanceof PlacedItemBlock || block instanceof SpectrumBuddingBlock || block instanceof WeepingGalaFrondsBlock) continue;
            class_2680 blockState = ((class_2248)entry3.getValue()).method_9564();
            class_5321 lootTableKey = block.method_26162();
            class_2960 class_29602 = lootTableKey.method_29177();
            if (blockState.method_26204().method_36555() <= -1.0f || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK)) continue;
            if (lootTableKey.equals(class_39.field_844) || class_29602.method_12832().equals("blocks/air")) {
                SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.method_29177()) + " has a non-existent loot table (" + String.valueOf(class_29602) + ")");
                continue;
            }
            class_52 lootTable = source.method_9225().method_8503().method_58576().method_58295(lootTableKey);
            List lootPools = lootTable.field_943;
            if (!lootPools.isEmpty()) continue;
            SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + String.valueOf(registryKey.method_29177()) + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap<BuiltinGemstoneColor, Integer> colorMap = new HashMap<BuiltinGemstoneColor, Integer>();
            for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
                colorMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put((Object)((Object)pedestalRecipeTier), colorMap);
        }
        MinecraftServer minecraftServer = source.method_9225().method_8503();
        class_1863 recipeManager = minecraftServer.method_3772();
        class_2989 advancementLoader = minecraftServer.method_3851();
        for (class_8786 pedestalRecipeHolder : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)pedestalRecipeHolder.comp_1933();
            if ((pedestalRecipe.getTier() == PedestalRecipeTier.BASIC || pedestalRecipe.getTier() == PedestalRecipeTier.SIMPLE) && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.BLACK, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipeHolder.comp_1932()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
            }
            if (pedestalRecipe.getTier() != PedestalRecipeTier.COMPLEX && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.WHITE, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + String.valueOf(pedestalRecipeHolder.comp_1932()) + "' of tier '" + String.valueOf((Object)pedestalRecipe.getTier()) + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry<GemstoneColor, Integer> powderInput : pedestalRecipe.getPowderInputs().entrySet()) {
                ((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).put(powderInput.getKey(), (Integer)((Map)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).get(powderInput.getKey()) + powderInput.getValue());
            }
        }
        for (Map.Entry item : class_7923.field_41178.method_29722()) {
            if (!((class_5321)item.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_1792)item.getValue()).method_7876())) continue;
            SpectrumCommon.logWarning("[SANITY: Item Lang] Missing translation string " + ((class_1792)item.getValue()).method_7876());
        }
        for (Map.Entry block : class_7923.field_41175.method_29722()) {
            if (!((class_5321)block.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_2248)block.getValue()).method_9539())) continue;
            SpectrumCommon.logWarning("[SANITY: Block Lang] Missing translation string " + ((class_2248)block.getValue()).method_9539());
        }
        for (Object entityType : class_7923.field_41177.method_29722()) {
            if (!((class_5321)entityType.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_1299)entityType.getValue()).method_5882())) continue;
            SpectrumCommon.logWarning("[SANITY: EntityType Lang] Missing translation string " + ((class_1299)entityType.getValue()).method_5882());
        }
        for (Object entityType : class_7923.field_41174.method_29722()) {
            if (!((class_5321)entityType.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_1291)entityType.getValue()).method_5567())) continue;
            SpectrumCommon.logWarning("[SANITY: Status Effect Lang] Missing translation string " + ((class_1291)entityType.getValue()).method_5567());
        }
        for (Object entityType : class_7923.field_41190.method_29722()) {
            if (!((class_5321)entityType.getKey()).method_29177().method_12836().equals(modId) || class_2477.method_10517().method_4678(((class_1320)entityType.getValue()).method_26830())) continue;
            SpectrumCommon.logWarning("[SANITY: Attribute Lang] Missing translation string " + ((class_1320)entityType.getValue()).method_26830());
        }
        for (Object entityType : class_7923.field_41190.method_29722()) {
            if (!((class_5321)entityType.getKey()).method_29177().method_12836().equals(modId)) continue;
            if (!class_2477.method_10517().method_4678(((class_1320)entityType.getValue()).method_26830())) {
                SpectrumCommon.logWarning("[SANITY: Attribute Lang] Missing translation string " + ((class_1320)entityType.getValue()).method_26830());
            }
            if (class_2477.method_10517().method_4678(((class_1320)entityType.getValue()).method_26830() + ".desc")) continue;
            SpectrumCommon.logWarning("[SANITY: Attribute Lang] Missing description string " + ((class_1320)entityType.getValue()).method_26830() + ".desc");
        }
        HashSet recipeGroups = new HashSet();
        recipeManager.method_8127().forEach(identifier -> {
            class_1860 patt0$temp;
            Optional recipe = recipeManager.method_8130(identifier);
            if (recipe.isPresent() && (patt0$temp = ((class_8786)recipe.get()).comp_1933()) instanceof GatedSpectrumRecipe) {
                GatedSpectrumRecipe gatedSpectrumRecipe = (GatedSpectrumRecipe)patt0$temp;
                String group = gatedSpectrumRecipe.method_8112();
                if (group == null) {
                    SpectrumCommon.logWarning("Recipe with null group found! :" + gatedSpectrumRecipe.method_8112());
                } else if (!group.isEmpty()) {
                    recipeGroups.add(group);
                }
            }
        });
        for (String string : recipeGroups) {
            if (class_2477.method_10517().method_4678("recipeGroup.spectrum." + string)) continue;
            SpectrumCommon.logWarning("[SANITY: Recipe Group Lang] Recipe group " + string + " is not localized.");
        }
        source.method_9225().method_8433().method_30027(SpectrumRecipeTypes.PEDESTAL).stream().filter(pedestalRecipeRecipeHolder -> pedestalRecipeRecipeHolder.comp_1932().method_12832().contains("lucky_roll")).collect(Collectors.toUnmodifiableList());
        for (class_8786 class_87862 : recipeManager.method_8126()) {
            GatedRecipe gatedRecipe;
            Optional<class_2960> advancementIdentifier;
            class_1860 powderInput = class_87862.comp_1933();
            if (!(powderInput instanceof GatedRecipe) || !(advancementIdentifier = (gatedRecipe = (GatedRecipe)powderInput).getRequiredAdvancementIdentifier()).isPresent() || advancementLoader.method_12896(advancementIdentifier.get()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: " + gatedRecipe.getRecipeTypeShortID() + " Recipe Unlocks] Advancement '" + String.valueOf(gatedRecipe.getRequiredAdvancementIdentifier()) + "' in recipe '" + String.valueOf(class_87862.comp_1932()) + "' does not exist");
        }
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, registryManager);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.SPIRIT_INSTILLING, "Spirit Instiller", recipeManager, registryManager);
        for (Map.Entry entry4 : RevelationRegistry.getBlockStateEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)entry4.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Block Cloaks] Advancement '" + ((class_2960)entry4.getKey()).toString() + "' for block cloaking does not exist. Registered cloaks: " + ((List)entry4.getValue()).size());
        }
        for (Map.Entry entry5 : RevelationRegistry.getItemEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)entry5.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Cloaks] Advancement '" + ((class_2960)entry5.getKey()).toString() + "' for item cloaking does not exist. Registered cloaks: " + ((List)entry5.getValue()).size());
        }
        for (class_8779 class_87792 : advancementLoader.method_12893()) {
            class_161 advancement = class_87792.comp_1920();
            for (class_175 criterion : advancement.comp_1915().values()) {
                class_184 conditions = criterion.comp_1924();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    class_8779 advancementCriterionAdvancement;
                    AdvancementGottenCriterion.Conditions hasAdvancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    class_2960 advancementIdentifier = hasAdvancementConditions.getAdvancementIdentifier();
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier)) != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Has_Advancement Criteria] Advancement '" + String.valueOf(class_87792.comp_1919()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                    continue;
                }
                if (!(conditions instanceof AdvancementCountCriterion.Conditions)) continue;
                AdvancementCountCriterion.Conditions hasAdvancementConditions = (AdvancementCountCriterion.Conditions)conditions;
                for (class_2960 advancementIdentifier : hasAdvancementConditions.advancementIdentifiers()) {
                    class_8779 advancementCriterionAdvancement;
                    if (advancementIdentifier.equals((Object)WIP_ADVANCEMENT_ID) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier)) != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Advancement_Count Criteria] Advancement '" + String.valueOf(class_87792.comp_1919()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
                }
            }
        }
        for (class_8779 class_87793 : advancementLoader.method_12893()) {
            Object parentOfParentId;
            class_2960 advancementId = class_87793.comp_1919();
            String path = advancementId.method_12832();
            Optional parentId = class_87793.comp_1920().comp_1912();
            if (!advancementId.method_12836().equals(modId) || path.startsWith("hidden") || path.startsWith("progression") || path.startsWith("milestones") || !parentId.isPresent()) continue;
            class_2960 gottenPreviousAdvancementIdentifier = null;
            for (List requirement : class_87793.comp_1920().comp_1916().comp_1922()) {
                if (requirement.isEmpty() || !((String)requirement.getFirst()).equals("gotten_previous")) continue;
                class_184 conditions = ((class_175)class_87793.comp_1920().comp_1915().get("gotten_previous")).comp_1924();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    AdvancementGottenCriterion.Conditions advancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    gottenPreviousAdvancementIdentifier = advancementConditions.getAdvancementIdentifier();
                    break;
                }
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has a \"gotten_previous\" requirement, but its not of type revelationary:advancement_gotten");
            }
            if (ADVANCEMENT_GATING_WARNING_WHITELIST.contains(advancementId)) continue;
            if (gottenPreviousAdvancementIdentifier == null) {
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' does not have its parent set as requirement");
                continue;
            }
            class_8779 parentEntry = advancementLoader.method_12896((class_2960)parentId.get());
            if (parentEntry == null) {
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has its \"gotten_previous\" advancement set an advancement that does not exist.");
                continue;
            }
            if (parentEntry.comp_1919().equals(gottenPreviousAdvancementIdentifier) || ((Optional)(parentOfParentId = parentEntry.comp_1920().comp_1912())).isPresent() && ((class_2960)((Optional)parentOfParentId).get()).equals((Object)gottenPreviousAdvancementIdentifier)) continue;
            SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + String.valueOf(advancementId) + "' has its \"gotten_previous\" advancement set to something else than their parent. Intended?");
        }
        for (class_8786 class_87863 : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            PedestalRecipe recipe2 = (PedestalRecipe)class_87863.comp_1933();
            class_2960 id2 = class_87863.comp_1932();
            if (id2.method_12832().startsWith("mod_integration/") || id2.method_12832().contains("/glass/") || id2.method_12832().contains("/saplings/") || id2.method_12832().contains("/detectors/") || id2.method_12832().contains("/gemstone_lights/") || id2.method_12832().contains("/pylons/") || id2.method_12832().contains("/runes/") || id2.method_12832().contains("/pastel_network/") || id2.method_12832().contains("/gemstone_chimes/") || id2.method_12832().contains("/semi_permeable_glass/") || id2.method_12832().contains("/colored_lamps/") || id2.method_12832().contains("/colored_spore_blossoms/") || id2.method_12832().contains("/glowblocks/")) continue;
            if (recipe2.getTier() == PedestalRecipeTier.BASIC && !id2.method_12832().contains("/tier1/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] BASIC recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() == PedestalRecipeTier.SIMPLE && !id2.method_12832().contains("/tier2/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] SIMPLE recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() == PedestalRecipeTier.ADVANCED && !id2.method_12832().contains("/tier3/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] ADVANCED recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
                continue;
            }
            if (recipe2.getTier() != PedestalRecipeTier.COMPLEX || id2.method_12832().contains("/tier4/")) continue;
            SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] COMPLEX recipe not in the correct tier folder: '" + String.valueOf(id2) + "'");
        }
        for (class_8786 class_87864 : recipeManager.method_30027(SpectrumRecipeTypes.ANVIL_CRUSHING)) {
            AnvilCrushingRecipe recipe3 = (AnvilCrushingRecipe)class_87864.comp_1933();
            class_3414 soundEvent = recipe3.getSoundEvent();
            if (soundEvent != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Crushing] Recipe '" + String.valueOf(class_87864.comp_1932()) + "' has a nonexistent sound set");
        }
        HashMap<class_6880, InkColor> craftingColors = new HashMap<class_6880, InkColor>();
        HashMap<class_6880, InkColor> hashMap = new HashMap<class_6880, InkColor>();
        for (class_8786 recipeEntry : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTER)) {
            recipe = (EnchanterRecipe)recipeEntry.comp_1933();
            output = ((EnchanterRecipe)recipe).method_8110((class_7225.class_7874)source.method_30497());
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_57532((class_1799)output)).method_57543()) continue;
            for (class_1856 ingredient : ((EnchanterRecipe)recipe).method_8117()) {
                for (class_1799 matchingStack : ingredient.method_8105()) {
                    class_1792 class_17922 = matchingStack.method_7909();
                    if (!(class_17922 instanceof PigmentItem)) continue;
                    PigmentItem pigmentItem = (PigmentItem)class_17922;
                    craftingColors.put((class_6880)enchantments.method_57534().stream().toList().getFirst(), pigmentItem.getInkColor());
                }
            }
        }
        for (class_8786 recipeEntry : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE)) {
            class_1856 ingredient;
            recipe = (EnchantmentUpgradeRecipe)recipeEntry.comp_1933();
            output = ((EnchantmentUpgradeRecipe)recipe).method_8110((class_7225.class_7874)source.method_30497());
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_57532((class_1799)output)).method_57543() || !((ingredient = ((EnchantmentUpgradeRecipe)recipe).getBulkItem()) instanceof PigmentItem)) continue;
            PigmentItem pigmentItem = (PigmentItem)ingredient;
            hashMap.put((class_6880)enchantments.method_57534().stream().toList().getFirst(), pigmentItem.getInkColor());
        }
        for (class_1887 enchantment : registryManager.method_30530(class_7924.field_41265)) {
            entry = registryManager.method_30530(class_7924.field_41265).method_47983((Object)enchantment);
            if (!craftingColors.containsKey(entry)) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + entry.method_55840() + "' does not have a crafting recipe");
            }
            if (!hashMap.containsKey(entry) && enchantment.method_8183() > 1) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + entry.method_55840() + "' does not have a upgrading recipe");
            }
            if (!craftingColors.containsKey(entry) || !hashMap.containsKey(entry) || craftingColors.get(entry) == hashMap.get(entry)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment recipes for '" + entry.method_55840() + "' use different pigments");
        }
        for (class_1887 enchantment : registryManager.method_30530(class_7924.field_41265)) {
            entry = registryManager.method_30530(class_7924.field_41265).method_47983((Object)enchantment);
            id = ((class_5321)entry.method_40230().get()).method_29177();
            if (!id.method_12836().equals(modId) || entry.method_40220(SpectrumEnchantmentTags.SPECTRUM_ENCHANTMENT)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Tags] Enchantment '" + String.valueOf(id) + "' is missing in the spectrum:enchantments tag");
        }
        for (Map.Entry item : class_7923.field_41178.method_29722()) {
            SpectrumTrinketItem trinketItem;
            class_2960 advancementIdentifier;
            class_8779 advancementCriterionAdvancement;
            id = item.getValue();
            if (!(id instanceof SpectrumTrinketItem) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (trinketItem = (SpectrumTrinketItem)((Object)id)).getUnlockIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Trinkets] Trinket '" + String.valueOf(((class_5321)item.getKey()).method_29177()) + "' references advancement '" + String.valueOf(advancementIdentifier) + "' that does not exist");
        }
        for (class_8786 recipe4 : source.method_9225().method_8433().method_8126()) {
            class_2960 id3 = recipe4.comp_1932();
            class_1860 r = recipe4.comp_1933();
            int brokenCount = 0;
            for (class_1856 ingredient : r.method_8117()) {
                if (ingredient.method_8105().length != 0 || ingredient.method_8103() || ingredient == class_1856.field_9017) continue;
                ++brokenCount;
            }
            if (brokenCount <= 0) continue;
            SpectrumCommon.logWarning("[SANITY: Recipe Ingredients] Recipe '" + String.valueOf(id3) + "' has " + brokenCount + " broken ingredient(s)");
        }
        Collection itemGroupStacks = SpectrumItemGroups.MAIN.method_45414();
        if (itemGroupStacks.isEmpty()) {
            for (ItemSubGroup subGroup : SpectrumItemGroups.MAIN.fractal$getChildren()) {
                subGroup.method_47306(new class_1761.class_8128(class_7699.method_45397(), false, (class_7225.class_7874)registryManager));
            }
            itemGroupStacks = SpectrumItemGroups.MAIN.method_45414();
        }
        for (Map.Entry item : class_7923.field_41178.method_29722()) {
            if (!((class_5321)item.getKey()).method_29177().method_12836().equals(modId) || ((class_1792)item.getValue()).method_40131().method_40220(SpectrumItemTags.COMING_SOON_TOOLTIP)) continue;
            boolean found = false;
            for (class_1799 stack : itemGroupStacks) {
                if (!stack.method_31574((class_1792)item.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            SpectrumCommon.logWarning("[SANITY: ItemGroups] Item '" + String.valueOf(((class_5321)item.getKey()).method_29177()) + "' is missing from the Spectrum item group.");
        }
        SpectrumCommon.logInfo("##### SANITY CHECK FINISHED ######");
        SpectrumCommon.logInfo("##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            Map entry6 = (Map)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            SpectrumCommon.logInfo("[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)entry6.get(BuiltinGemstoneColor.CYAN)).toString(), (int)4) + " M:" + StringUtils.leftPad((String)((Integer)entry6.get(BuiltinGemstoneColor.MAGENTA)).toString(), (int)4) + " Y:" + StringUtils.leftPad((String)((Integer)entry6.get(BuiltinGemstoneColor.YELLOW)).toString(), (int)4) + " K:" + StringUtils.leftPad((String)((Integer)entry6.get(BuiltinGemstoneColor.BLACK)).toString(), (int)4) + " W:" + StringUtils.leftPad((String)((Integer)entry6.get(BuiltinGemstoneColor.WHITE)).toString(), (int)4));
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_12972;
            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"commands.spectrum.progression_sanity.success"), false);
        }
        return 0;
    }

    private static <R extends GatedRecipe<C>, C extends class_9695> void testRecipeUnlocks(class_3956<R> recipeType, String name, class_1863 recipeManager, class_2989 advancementLoader) {
        for (class_8786 recipe : recipeManager.method_30027(recipeType)) {
            Optional<class_2960> advancementIdentifier = ((GatedRecipe)recipe.comp_1933()).getRequiredAdvancementIdentifier();
            if (!advancementIdentifier.isPresent() || advancementLoader.method_12896(advancementIdentifier.get()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe Unlocks] Advancement '" + String.valueOf(advancementIdentifier) + "' in recipe '" + String.valueOf(recipe.comp_1932()) + "' does not exist");
        }
    }

    private static <R extends GatedRecipe<C>, C extends class_9695> void testIngredientsAndOutputInColorRegistry(class_3956<R> recipeType, String name, class_1863 recipeManager, class_5455 registryManager) {
        for (class_8786 recipe : recipeManager.method_30027(recipeType)) {
            for (class_1856 inputIngredient : ((GatedRecipe)recipe.comp_1933()).method_8117()) {
                for (class_1799 matchingItemStack : inputIngredient.method_8105()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Input '" + String.valueOf(class_7923.field_41178.method_10221((Object)matchingItemStack.method_7909())) + "' in recipe '" + String.valueOf(recipe.comp_1932()) + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            class_1792 outputItem = ((GatedRecipe)recipe.comp_1933()).method_8110((class_7225.class_7874)registryManager).method_7909();
            if (outputItem == class_1802.field_8162 || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Output '" + String.valueOf(class_7923.field_41178.method_10221((Object)outputItem)) + "' in recipe '" + String.valueOf(recipe.comp_1932()) + "', does not exist in the item color registry. Add it for nice effects!");
        }
    }
}

