/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.ae2.AE2Compat;
import de.dafuqs.spectrum.compat.alloy_forgery.AlloyForgeryCompat;
import de.dafuqs.spectrum.compat.botania.BotaniaCompat;
import de.dafuqs.spectrum.compat.create.CreateCompat;
import de.dafuqs.spectrum.compat.ears.EarsCompat;
import de.dafuqs.spectrum.compat.exclusions_lib.ExclusionsLibCompat;
import de.dafuqs.spectrum.compat.gobber.GobberCompat;
import de.dafuqs.spectrum.compat.idwtialsimmoedm.IdwtialsimmoedmCompat;
import de.dafuqs.spectrum.compat.malum.MalumCompat;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconCompat;
import de.dafuqs.spectrum.compat.neepmeat.NEEPMeatCompat;
import de.dafuqs.spectrum.compat.starry_skies.StarrySkiesCompat;
import de.dafuqs.spectrum.compat.travelersbackpack.TravelersBackpackCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

public class SpectrumIntegrationPacks {
    protected static final Map<String, ModIntegrationPack> INTEGRATION_PACKS = new HashMap<String, ModIntegrationPack>();
    public static final String CONNECTOR_ID = "connector";
    public static final String AE2_ID = "ae2";
    public static final String GOBBER_ID = "gobber2";
    public static final String ALLOY_FORGERY_ID = "alloy_forgery";
    public static final String TRAVELERS_BACKPACK_ID = "travelersbackpack";
    public static final String BOTANIA_ID = "botania";
    public static final String MODONOMICON_ID = "modonomicon";
    public static final String CREATE_ID = "create";
    public static final String NEEPMEAT_ID = "neepmeat";
    public static final String MALUM_ID = "malum";
    public static final String EXCLUSIONS_LIB_ID = "exclusions_lib";
    public static final String STARRY_SKIES_ID = "starry_skies";
    public static final String EARS_ID = "ears";
    public static final String IDWTIALSIMMOEDM_ID = "idwtialsimmoedm";

    protected static void registerIntegrationPack(String modId, Supplier<ModIntegrationPack> container) {
        if (!SpectrumCommon.CONFIG.IntegrationPacksToSkipLoading.contains(modId) && FabricLoader.getInstance().isModLoaded(modId)) {
            INTEGRATION_PACKS.put(modId, container.get());
        }
    }

    public static void register() {
        SpectrumIntegrationPacks.registerIntegrationPack(MODONOMICON_ID, () -> new ModonomiconCompat());
        if (!FabricLoader.getInstance().isModLoaded(EXCLUSIONS_LIB_ID)) {
            ExclusionsLibCompat.registerNotPresent();
        }
        if (!FabricLoader.getInstance().isModLoaded(CONNECTOR_ID)) {
            SpectrumIntegrationPacks.registerIntegrationPack(AE2_ID, () -> new AE2Compat());
            SpectrumIntegrationPacks.registerIntegrationPack(GOBBER_ID, () -> new GobberCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(ALLOY_FORGERY_ID, () -> new AlloyForgeryCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(TRAVELERS_BACKPACK_ID, () -> new TravelersBackpackCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(BOTANIA_ID, () -> new BotaniaCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(NEEPMEAT_ID, () -> new NEEPMeatCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(MALUM_ID, () -> new MalumCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(CREATE_ID, () -> new CreateCompat());
            SpectrumIntegrationPacks.registerIntegrationPack(STARRY_SKIES_ID, () -> new StarrySkiesCompat());
        }
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.register();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        SpectrumIntegrationPacks.registerIntegrationPack(EARS_ID, () -> new EarsCompat());
        SpectrumIntegrationPacks.registerIntegrationPack(IDWTIALSIMMOEDM_ID, () -> new IdwtialsimmoedmCompat());
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.registerClient();
        }
    }

    public static boolean isIntegrationPackActive(String modId) {
        return INTEGRATION_PACKS.containsKey(modId);
    }

    public static abstract class ModIntegrationPack {
        public abstract void register();

        public abstract void registerClient();
    }
}

