/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import de.dafuqs.spectrum.compat.emi.FluidIngredientEmi;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.compat.emi.SpectrumEmiRecipeCategories;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelEmiRecipeGated
extends GatedSpectrumEmiRecipe<ITitrationBarrelRecipe> {
    @Nullable
    protected final List<EmiStack> displayedStacks;

    public TitrationBarrelEmiRecipeGated(class_8786<ITitrationBarrelRecipe> entry) {
        super(SpectrumEmiRecipeCategories.TITRATION_BARREL, entry, 136, 50);
        this.inputs = new ArrayList();
        if (!((ITitrationBarrelRecipe)this.recipe).getFluidInput().fluid().get().method_15780(class_3612.field_15906)) {
            this.inputs.add(FluidIngredientEmi.into(((ITitrationBarrelRecipe)this.recipe).getFluidInput()));
        }
        this.inputs.addAll(((ITitrationBarrelRecipe)this.recipe).getIngredientStacks().stream().map(s -> EmiIngredient.of(s.getMatchingStacks().stream().map(EmiStack::of).toList())).toList());
        this.displayedStacks = TitrationBarrelEmiRecipeGated.buildFermentationOutputVariations((ITitrationBarrelRecipe)this.recipe);
    }

    private static List<EmiStack> buildFermentationOutputVariations(ITitrationBarrelRecipe recipe) {
        TitrationBarrelRecipe titrationBarrelRecipe;
        if (recipe instanceof TitrationBarrelRecipe && (titrationBarrelRecipe = (TitrationBarrelRecipe)recipe).getFermentationData() != null) {
            return titrationBarrelRecipe.getOutputVariations(TitrationBarrelRecipe.FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS).stream().map(EmiStack::of).toList();
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int startX = Math.max(10, 40 - this.inputs.size() * 10);
        int startY = this.inputs.size() > 3 ? 0 : 10;
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = startX + i % 3 * 20;
            int y = startY + i / 3 * 20;
            widgets.addSlot((EmiIngredient)this.inputs.get(i), x, y);
        }
        EmiStack tapping = EmiStack.of((class_1935)((ITitrationBarrelRecipe)this.recipe).getTappingItem());
        if (tapping.isEmpty()) {
            widgets.addFillingArrow(70, 10, ((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours() * 20 * 50);
        } else {
            widgets.addFillingArrow(70, 2, ((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours() * 20 * 50);
            widgets.addSlot((EmiIngredient)tapping, 74, 20);
        }
        if (this.displayedStacks == null) {
            widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 100, 5).large(true).recipeContext((EmiRecipe)this);
        } else if (class_310.method_1551().field_1687 != null) {
            widgets.addGeneratedSlot(random -> (EmiIngredient)this.displayedStacks.get((int)(class_310.method_1551().field_1687.method_8510() % (long)this.displayedStacks.size())), 1, 100, 5).large(true).recipeContext((EmiRecipe)this);
        }
        class_5250 text = TitrationBarrelRecipe.getDurationText(((ITitrationBarrelRecipe)this.recipe).getMinFermentationTimeHours(), ((ITitrationBarrelRecipe)this.recipe).getFermentationData());
        widgets.addText((class_2561)text, this.width / 2, 40, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

