/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.modonomicon.client.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.GemstoneColor;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconHelper;
import de.dafuqs.spectrum.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import de.dafuqs.spectrum.compat.modonomicon.pages.BookGatedRecipePage;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BookPedestalCraftingPageRenderer
extends BookGatedRecipePageRenderer<PedestalRecipe, BookGatedRecipePage<PedestalRecipe>> {
    private static final class_2960 BACKGROUND_TEXTURE1 = SpectrumCommon.locate("textures/gui/modonomicon/pedestal_crafting1.png");
    private static final class_2960 BACKGROUND_TEXTURE2 = SpectrumCommon.locate("textures/gui/modonomicon/pedestal_crafting2.png");
    private static final class_2960 BACKGROUND_TEXTURE3 = SpectrumCommon.locate("textures/gui/modonomicon/pedestal_crafting3.png");
    private static final class_2960 BACKGROUND_TEXTURE4 = SpectrumCommon.locate("textures/gui/modonomicon/pedestal_crafting4.png");

    public BookPedestalCraftingPageRenderer(BookGatedRecipePage<PedestalRecipe> page) {
        super(page);
    }

    protected int getRecipeHeight() {
        return 110;
    }

    protected void drawRecipe(class_332 drawContext, class_8786<PedestalRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        PedestalRecipe recipe = (PedestalRecipe)recipeEntry.comp_1933();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        drawContext.method_25290(this.getBackgroundTextureForTier(recipe.getTier()), recipeX - 2, recipeY - 2, 0.0f, 0.0f, 106, 97, 128, 256);
        this.renderTitle(drawContext, recipeY, second);
        this.parentScreen.renderItemStack(drawContext, recipeX + 78, recipeY + 22, mouseX, mouseY, recipe.method_8110((class_7225.class_7874)world.method_30349()));
        switch (recipe.getTier()) {
            case COMPLEX: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().getAvailableGemstoneColors(), 3, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            case ADVANCED: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().getAvailableGemstoneColors(), 12, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            default: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().getAvailableGemstoneColors(), 22, recipeX, recipeY, mouseX, mouseY);
            }
        }
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int wrap = recipe.getWidth();
        for (int i = 0; i < ingredients.size(); ++i) {
            ModonomiconHelper.renderIngredientStack(drawContext, this.parentScreen, recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, ingredients.get(i));
        }
    }

    @Contract(pure=true)
    private class_2960 getBackgroundTextureForTier(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        return switch (pedestalRecipeTier) {
            case PedestalRecipeTier.BASIC -> BACKGROUND_TEXTURE1;
            case PedestalRecipeTier.SIMPLE -> BACKGROUND_TEXTURE2;
            case PedestalRecipeTier.ADVANCED -> BACKGROUND_TEXTURE3;
            default -> BACKGROUND_TEXTURE4;
        };
    }

    private void drawGemstonePowderSlots(class_332 drawContext, PedestalRecipe recipe, GemstoneColor @NotNull [] colors, int startX, int recipeX, int recipeY, int mouseX, int mouseY) {
        int h = 0;
        for (GemstoneColor color : colors) {
            int amount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (amount > 0) {
                class_1799 stack = color.getGemstonePowderItem().method_7854();
                stack.method_7939(amount);
                this.parentScreen.renderItemStack(drawContext, recipeX + startX + h * 19, recipeY + 72, mouseX, mouseY, stack);
            }
            ++h;
        }
    }
}

