/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import de.dafuqs.spectrum.compat.modonomicon.ModonomiconCompat;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookLinkPage
extends BookTextPage {
    private final String url;
    private BookTextHolder linkText;

    public BookLinkPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, String url, BookTextHolder linkText) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.url = url;
        this.linkText = linkText;
    }

    public static BookLinkPage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (class_7225.class_7874)provider);
        boolean useMarkdownInTitle = class_3518.method_15258((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = class_3518.method_15258((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (class_7225.class_7874)provider);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((class_2960)entryId, (JsonObject)json.getAsJsonObject("condition"), (class_7225.class_7874)provider) : new BookNoneCondition();
        String url = class_3518.method_15253((JsonObject)json, (String)"url", (String)"");
        BookTextHolder linkText = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"link_text", (BookTextHolder)BookTextHolder.EMPTY, (class_7225.class_7874)provider);
        return new BookLinkPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, url, linkText);
    }

    public static BookLinkPage fromNetwork(class_9129 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((class_9129)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((class_9129)buffer);
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork((class_9129)buffer);
        String url = buffer.method_19772();
        BookTextHolder linkText = BookTextHolder.fromNetwork((class_9129)buffer);
        return new BookLinkPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, url, linkText);
    }

    public BookTextHolder getLinkText() {
        return this.linkText;
    }

    public class_2960 getType() {
        return ModonomiconCompat.LINK_PAGE;
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.linkText.hasComponent()) {
            class_5250 text = class_2561.method_43471((String)this.linkText.getKey());
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, this.url)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)this.url)));
            this.linkText = new BookTextHolder((class_2561)text.method_27696(style));
        }
    }

    public void toNetwork(class_9129 buffer) {
        super.toNetwork(buffer);
        buffer.method_10814(this.url);
        this.linkText.toNetwork(buffer);
    }

    public boolean matchesQuery(String query) {
        return super.matchesQuery(query) || this.url.toLowerCase().contains(query) || this.linkText.getString().toLowerCase().contains(query);
    }
}

