/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class CrystalApothecarySimulationsDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "crystal_apothecary_simulation";
    public static final CrystalApothecarySimulationsDataLoader INSTANCE = new CrystalApothecarySimulationsDataLoader();
    public static final HashMap<class_2248, SimulatedBlockGrowthEntry> COMPENSATIONS = new HashMap();

    private CrystalApothecarySimulationsDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        COMPENSATIONS.clear();
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject object = jsonElement.getAsJsonObject();
            DataResult buddingBlock = class_7923.field_41175.method_39673().decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("budding_block")).map(Pair::getFirst);
            if (buddingBlock.error().isPresent() || buddingBlock.result().isEmpty()) {
                SpectrumCommon.logError("Crystal apothecary simulation error for " + String.valueOf(identifier) + ": " + String.valueOf(buddingBlock.error().get()) + ". Ignoring that one.");
                return;
            }
            DataResult entry = SimulatedBlockGrowthEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, jsonElement).map(Pair::getFirst);
            if (entry.error().isPresent() || entry.result().isEmpty()) {
                SpectrumCommon.logError("Crystal Apothecary Simulation error for " + String.valueOf(identifier) + ": " + String.valueOf(entry.error().get()) + ". Ignoring that one.");
                return;
            }
            COMPENSATIONS.put((class_2248)buddingBlock.result().get(), (SimulatedBlockGrowthEntry)entry.result().get());
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public record SimulatedBlockGrowthEntry(Collection<class_2248> validNeighbors, int ticksForCompensationLootPerValidNeighbor, class_1799 compensatedStack) {
        public static final Codec<SimulatedBlockGrowthEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_7923.field_41175.method_39673().listOf().xmap(list -> list, set -> set.stream().toList()).fieldOf("valid_neighbor_blocks").forGetter(c -> c.validNeighbors), (App)Codec.INT.optionalFieldOf("ticks_for_compensation_loot_per_valid_neighbor", (Object)10000).forGetter(c -> c.ticksForCompensationLootPerValidNeighbor), (App)class_1799.field_24671.fieldOf("compensated_loot").forGetter(c -> c.compensatedStack)).apply((Applicative)i, SimulatedBlockGrowthEntry::new));
    }
}

