/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders.resonance_processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.interaction.ResonanceProcessor;
import de.dafuqs.spectrum.api.predicate.block.BrokenBlockPredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class DropSelfResonanceProcessor
extends ResonanceProcessor {
    public static final MapCodec<DropSelfResonanceProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BrokenBlockPredicate.CODEC.fieldOf("block").validate(block -> block.test(class_2246.field_10124.method_9564()) ? DataResult.error(() -> "Registering a Resonance Drop that matches on everything!") : DataResult.success((Object)block)).forGetter(c -> c.blockPredicate), (App)Codec.STRING.listOf().optionalFieldOf("state_properties_to_copy", List.of()).forGetter(c -> c.statePropertiesToCopy), (App)Codec.STRING.listOf().optionalFieldOf("nbt_to_copy", List.of()).forGetter(c -> c.nbtToCopy), (App)Codec.BOOL.optionalFieldOf("include_default_state_properties", (Object)false).forGetter(c -> c.includeDefaultStateProperties)).apply((Applicative)i, DropSelfResonanceProcessor::new));
    public List<String> statePropertiesToCopy;
    public List<String> nbtToCopy;
    public boolean includeDefaultStateProperties;

    public DropSelfResonanceProcessor(BrokenBlockPredicate blockTarget, List<String> statePropertiesToCopy, List<String> nbtToCopy, boolean includeDefaultStateProperties) {
        super(blockTarget);
        this.statePropertiesToCopy = statePropertiesToCopy;
        this.nbtToCopy = nbtToCopy;
        this.includeDefaultStateProperties = includeDefaultStateProperties;
    }

    @Override
    public boolean process(class_2680 state, class_2586 blockEntity, List<class_1799> droppedStacks) {
        if (this.blockPredicate.test(state)) {
            this.dropSelf(state, blockEntity, droppedStacks);
            ResonanceProcessor.preventNextXPDrop = true;
            return true;
        }
        return false;
    }

    public void copyBlockStateTags(class_2680 minedState, class_1799 convertedStack) {
        class_9275 component = class_9275.field_49284;
        for (class_2769 blockProperty : minedState.method_28501()) {
            if (!this.statePropertiesToCopy.contains(blockProperty.method_11899()) || !this.includeDefaultStateProperties && minedState.method_26204().method_9564().method_11654(blockProperty) == minedState.method_11654(blockProperty)) continue;
            component = component.method_57419(blockProperty, minedState);
        }
        convertedStack.method_57379(class_9334.field_49623, (Object)component);
    }

    public void copyNbt(class_2586 blockEntity, class_1799 convertedStack) {
        class_2487 newNbt = new class_2487();
        class_2487 BlockEntityNbt = blockEntity.method_59535((class_7225.class_7874)blockEntity.method_10997().method_30349());
        for (String s : this.nbtToCopy) {
            if (!BlockEntityNbt.method_10545(s)) continue;
            newNbt.method_10566(s, BlockEntityNbt.method_10580(s));
        }
        if (!newNbt.method_33133()) {
            class_1747.method_57338((class_1799)convertedStack, (class_2591)blockEntity.method_11017(), (class_2487)newNbt);
        }
    }

    private void dropSelf(class_2680 minedState, class_2586 blockEntity, List<class_1799> droppedStacks) {
        class_1799 selfStack = minedState.method_26204().method_8389().method_7854();
        if (!this.statePropertiesToCopy.isEmpty()) {
            this.copyBlockStateTags(minedState, selfStack);
        }
        if (!this.nbtToCopy.isEmpty()) {
            this.copyNbt(blockEntity, selfStack);
        }
        droppedStacks.clear();
        droppedStacks.add(selfStack);
    }

    @Override
    public MapCodec<? extends ResonanceProcessor> getCodec() {
        return CODEC;
    }

    public static Builder builder(BrokenBlockPredicate blockTarget) {
        return new Builder(blockTarget);
    }

    public static class Builder {
        private final BrokenBlockPredicate blockTarget;
        private final List<String> nbtToCopy = new ArrayList<String>();
        private final List<String> statePropertiesToCopy = new ArrayList<String>();
        private boolean includeDefaultStateProperties = false;

        private Builder(BrokenBlockPredicate blockTarget) {
            this.blockTarget = blockTarget;
        }

        public Builder copyNbt(String ... tags) {
            this.nbtToCopy.addAll(List.of(tags));
            return this;
        }

        public Builder copyState(String ... states) {
            this.statePropertiesToCopy.addAll(List.of(states));
            return this;
        }

        public Builder includeDefaultState() {
            this.includeDefaultStateProperties = true;
            return this;
        }

        public DropSelfResonanceProcessor build() {
            return new DropSelfResonanceProcessor(this.blockTarget, this.statePropertiesToCopy, this.nbtToCopy, this.includeDefaultStateProperties);
        }
    }
}

