/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.deeper_down;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.client.FallingAshParticle;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.sound.BiomeAttenuatingSoundInstance;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class HowlingSpireEffects {
    public static int spireTicks;
    public static int lastSpireTicks;
    private static boolean initialized;
    private static final long ASH_UPDATE_INTERVAL = 1600L;
    private static final double BASE_ASH_VELOCITY = 0.25;
    private static double targetAshVelocity;
    private static double lastAshVelocity;
    private static double ashScaleA;
    private static double ashScaleB;
    private static double ashScaleC;
    private static int ashSwitchTicks;
    private static int ashSpawns;
    private static class_2350.class_2351 ashAxis;
    private static class_310 client;

    public static void clientTick(class_638 world, class_1297 cameraEntity, class_6880<class_1959> biome) {
        if (client.method_1493()) {
            return;
        }
        lastSpireTicks = spireTicks;
        BiomeAttenuatingSoundInstance.update(biome);
        boolean inHowlingSpires = biome.method_40225(SpectrumBiomes.HOWLING_SPIRES);
        if (inHowlingSpires) {
            if (spireTicks < 60) {
                ++spireTicks;
            }
        } else if (spireTicks > 0) {
            --spireTicks;
        }
        long time = world.method_8510();
        class_5819 random = world.method_8409();
        double ashVelocity = targetAshVelocity;
        if (ashSwitchTicks < 50) {
            ashVelocity = class_3532.method_15390((double)lastAshVelocity, (double)targetAshVelocity, (double)ashSwitchTicks);
            ++ashSwitchTicks;
        }
        if (time % 1600L == 0L || !initialized) {
            HowlingSpireEffects.updateAshEffects(random);
            FallingAshParticle.setTargetVelocity(ashVelocity);
            FallingAshParticle.setPrimaryAxis(ashAxis);
            FallingAshParticle.setAshScaleA(ashScaleA);
            FallingAshParticle.setAshScaleB(ashScaleB);
            FallingAshParticle.setAshScaleC(ashScaleC);
        }
        if (inHowlingSpires) {
            int maxAsh = ashSpawns / (SpectrumCommon.CONFIG.ReducedParticles ? 2 : 1);
            HowlingSpireEffects.spawnHowlingSpiresAsh(cameraEntity, maxAsh, random, world, biome);
        }
        initialized = true;
    }

    private static void updateAshEffects(class_5819 random) {
        class_2350.class_2351 newAxis;
        ashSpawns = random.method_39332(5, 7);
        if ((double)random.method_43057() < 0.125) {
            targetAshVelocity = class_3532.method_15350((double)(targetAshVelocity + (double)random.method_43057() * 0.05 - 0.025), (double)0.025, (double)0.75);
            return;
        }
        if (random.method_43057() < 0.95f) {
            return;
        }
        ashScaleA = 500.0 * (random.method_43058() + 1.0) * (random.method_43058() * 20.0) + 1000.0;
        ashScaleB = 100.0 * (random.method_43058() + 1.0) * (random.method_43058() * 10.0) + 250.0;
        ashScaleC = 20.0 * (random.method_43058() + 1.0) * (random.method_43058() * 5.0) + 100.0;
        class_2350.class_2351 class_23512 = newAxis = random.method_43056() ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        if (newAxis == ashAxis) {
            return;
        }
        targetAshVelocity = 0.25 * (random.method_43058() * 0.5 + 0.5) * (double)(random.method_43056() ? -1 : 1);
        ashAxis = newAxis;
    }

    private static void spawnHowlingSpiresAsh(class_1297 cameraEntity, int maxAsh, class_5819 random, class_638 clientWorld, class_6880<class_1959> biome) {
        class_2338 pos;
        double z;
        double y;
        double x;
        int i;
        class_243 camera = cameraEntity.method_19538();
        int renderDistance = HowlingSpireEffects.getRenderRadius();
        int maxSpawnDistance = Math.min(96, renderDistance) * 2;
        for (i = 0; i < maxAsh; ++i) {
            x = camera.method_10216() + (double)random.method_43048(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f);
            pos = new class_2338((int)x, (int)(y = camera.method_10214() + (double)random.method_43048(64) - 32.0), (int)(z = camera.method_10215() + (double)random.method_43048(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f)));
            if (!clientWorld.method_8320(pos).method_26215()) continue;
            clientWorld.method_8406((class_2394)SpectrumParticleTypes.FALLING_ASH, x, y, z, 0.0, 0.0, 0.0);
        }
        maxSpawnDistance /= 2;
        for (i = 0; i < maxAsh; ++i) {
            x = camera.method_10216() + (double)random.method_43048(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f);
            pos = new class_2338((int)x, (int)(y = camera.method_10214() + (double)random.method_43048(29) - 8.0), (int)(z = camera.method_10215() + (double)random.method_43048(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f)));
            if (!clientWorld.method_8320(pos).method_26215()) continue;
            clientWorld.method_8406((class_2394)SpectrumParticleTypes.FALLING_ASH, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static int getRenderRadius() {
        return ((Integer)HowlingSpireEffects.client.field_1690.method_42503().method_41753() + 1) * 16;
    }

    static {
        initialized = false;
        targetAshVelocity = 0.215;
        lastAshVelocity = 0.215;
        ashScaleA = 20000.0;
        ashScaleB = 2200.0;
        ashScaleC = 200.0;
        ashSwitchTicks = 50;
        ashAxis = class_2350.class_2351.field_11048;
        client = class_310.method_1551();
    }
}

