/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_173;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_52;
import net.minecraft.class_5253;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class EggLayingWoolyPigEntity
extends class_1429
implements class_5147 {
    private static final class_1856 FOOD = class_1856.method_8091((class_1935[])new class_1935[]{SpectrumBlocks.AMARANTH_BUSHEL});
    private static final int MAX_GRASS_TIMER = 40;
    private static final class_2940<Byte> COLOR_AND_SHEARED = class_2945.method_12791(EggLayingWoolyPigEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> HATLESS = class_2945.method_12791(EggLayingWoolyPigEntity.class, (class_2941)class_2943.field_13323);
    private static final Map<class_1767, Integer> COLORS = new EnumMap(SpectrumColorHelper.VANILLA_DYE_COLORS.stream().collect(Collectors.toMap(Function.identity(), EggLayingWoolyPigEntity::getDyedColor)));
    private int eatGrassTimer;
    private class_1345 eatGrassGoal;
    public int eggLayTime;

    public EggLayingWoolyPigEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.eggLayTime = this.field_5974.method_43048(12000) + 12000;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1937 world = this.method_37908();
        class_1799 handStack = player.method_5998(hand);
        class_1792 class_17922 = handStack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            if (this.method_5805() && this.getColor() != dyeItem.method_7802()) {
                world.method_43129(player, (class_1297)this, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                if (!world.field_9236) {
                    this.setColor(dyeItem.method_7802());
                    handStack.method_7934(1);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        if (handStack.method_31574(class_1802.field_8550) && !this.method_6109()) {
            player.method_5783(class_3417.field_14691, 1.0f, 1.0f);
            class_1799 itemStack2 = class_5328.method_30012((class_1799)handStack, (class_1657)player, (class_1799)class_1802.field_8103.method_7854());
            player.method_6122(hand, itemStack2);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (handStack.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
            if (!world.method_8608() && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                handStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public static class_5132.class_5133 createEggLayingWoolyPigAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 0.2);
    }

    public boolean method_6481(class_1799 stack) {
        return FOOD.method_8093(stack);
    }

    protected void method_5959() {
        this.eatGrassGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, (Predicate)FOOD, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)this.eatGrassGoal);
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5711(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.method_5711(status);
        }
    }

    protected void method_5958() {
        this.eatGrassTimer = this.eatGrassGoal.method_6258();
        super.method_5958();
    }

    public void method_6007() {
        if (this.method_37908().method_8608()) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        if (!this.method_37908().method_8608() && this.method_5805() && !this.method_6109() && --this.eggLayTime <= 0) {
            this.method_5783(class_3417.field_15219, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            this.method_5706((class_1935)class_1802.field_8803);
            this.eggLayTime = this.field_5974.method_43048(6000) + 6000;
        }
        super.method_6007();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR_AND_SHEARED, (Object)0);
        builder.method_56912(HATLESS, (Object)false);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        EggLayingWoolyPigEntity other = (EggLayingWoolyPigEntity)entity;
        EggLayingWoolyPigEntity child = (EggLayingWoolyPigEntity)SpectrumEntityTypes.EGG_LAYING_WOOLY_PIG.method_5883((class_1937)world);
        if (child != null) {
            child.setColor(this.getChildColor(this, other));
            if (world.field_9229.method_43048(50) == 0) {
                child.setHatless(true);
            }
        }
        return child;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
        nbt.method_10556("Hatless", this.isHatless());
        nbt.method_10567("Color", (byte)this.getColor().method_7789());
        nbt.method_10569("EggLayTime", this.eggLayTime);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSheared(nbt.method_10577("Sheared"));
        this.setHatless(nbt.method_10577("Hatless"));
        this.setColor(class_1767.method_7791((int)nbt.method_10571("Color")));
        if (nbt.method_10545("EggLayTime")) {
            this.eggLayTime = nbt.method_10550("EggLayTime");
        }
    }

    protected class_3414 method_5994() {
        return SpectrumSoundEvents.ENTITY_EGG_LAYING_WOOLY_PIG_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SpectrumSoundEvents.ENTITY_EGG_LAYING_WOOLY_HURT;
    }

    protected class_3414 method_6002() {
        return SpectrumSoundEvents.ENTITY_EGG_LAYING_WOOLY_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SpectrumSoundEvents.ENTITY_EGG_LAYING_WOOLY_STEP, 0.15f, 1.0f);
    }

    public void method_5983() {
        this.setSheared(false);
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        return this.eatGrassTimer < 4 ? ((float)this.eatGrassTimer - delta) / 4.0f : -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        return this.eatGrassTimer > 0 ? 0.62831855f : this.method_36455() * ((float)Math.PI / 180);
    }

    public void method_6636(class_3419 shearedSoundSource) {
        class_1937 world = this.method_37908();
        world.method_43129(null, (class_1297)this, class_3417.field_14975, shearedSoundSource, 1.0f, 1.0f);
        this.setSheared(true);
        for (class_1799 droppedStack : this.getShearedStacks((class_3218)world)) {
            class_1542 itemEntity = this.method_5699(droppedStack, 1.0f);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public List<class_1799> getShearedStacks(class_3218 world) {
        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538());
        class_52 lootTable = world.method_8503().method_58576().method_58295(SpectrumLootTables.EGG_LAYING_WOOLY_PIG_SHEARING);
        return lootTable.method_51878(builder.method_51875(class_173.field_16235));
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    public boolean isSheared() {
        return ((Byte)this.field_6011.method_12789(COLOR_AND_SHEARED) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte color = (Byte)this.field_6011.method_12789(COLOR_AND_SHEARED);
        if (sheared) {
            this.field_6011.method_12778(COLOR_AND_SHEARED, (Object)((byte)(color | 0x10)));
        } else {
            this.field_6011.method_12778(COLOR_AND_SHEARED, (Object)((byte)(color & 0xFFFFFFEF)));
        }
    }

    public boolean isHatless() {
        return (Boolean)this.field_6011.method_12789(HATLESS);
    }

    public void setHatless(boolean hatless) {
        this.field_6011.method_12778(HATLESS, (Object)hatless);
    }

    public static int getRgbColor(class_1767 dyeColor) {
        return COLORS.get(dyeColor);
    }

    private static int getDyedColor(class_1767 color) {
        if (color == class_1767.field_7952) {
            return -1644826;
        }
        int i = color.method_7787();
        return class_5253.class_5254.method_27764((int)255, (int)class_3532.method_15375((float)((float)class_5253.class_5254.method_27765((int)i) * 0.75f)), (int)class_3532.method_15375((float)((float)class_5253.class_5254.method_27766((int)i) * 0.75f)), (int)class_3532.method_15375((float)((float)class_5253.class_5254.method_27767((int)i) * 0.75f)));
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Byte)this.field_6011.method_12789(COLOR_AND_SHEARED) & 0xF));
    }

    public void setColor(class_1767 color) {
        byte b = (Byte)this.field_6011.method_12789(COLOR_AND_SHEARED);
        this.field_6011.method_12778(COLOR_AND_SHEARED, (Object)((byte)(b & 0xF0 | color.method_7789() & 0xF)));
    }

    private class_1767 getChildColor(class_1429 firstParent, class_1429 secondParent) {
        class_1792 class_17922;
        class_1937 world = this.method_37908();
        class_1767 dyeColor = ((EggLayingWoolyPigEntity)firstParent).getColor();
        class_1767 dyeColor2 = ((EggLayingWoolyPigEntity)secondParent).getColor();
        class_9694 craftingRecipeInput = EggLayingWoolyPigEntity.createChildColorRecipeInput(dyeColor, dyeColor2);
        Optional<class_1792> optionalItem = this.method_37908().method_8433().method_8132(class_3956.field_17545, (class_9695)craftingRecipeInput, this.method_37908()).map(recipe -> ((class_3955)recipe.comp_1933()).method_8116((class_9695)craftingRecipeInput, (class_7225.class_7874)this.method_37908().method_30349())).map(class_1799::method_7909);
        if (optionalItem.isPresent() && (class_17922 = optionalItem.get()) instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            return dyeItem.method_7802();
        }
        return world.field_9229.method_43056() ? dyeColor : dyeColor2;
    }

    private static class_9694 createChildColorRecipeInput(class_1767 firstColor, class_1767 secondColor) {
        return class_9694.method_59986((int)2, (int)1, List.of(new class_1799((class_1935)class_1769.method_7803((class_1767)firstColor)), new class_1799((class_1935)class_1769.method_7803((class_1767)secondColor))));
    }

    private static class_1715 createDyeMixingCraftingInventory(class_1767 firstColor, class_1767 secondColor) {
        class_1715 craftingInventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int index) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }
        }, 2, 1);
        craftingInventory.method_5447(0, new class_1799((class_1935)class_1769.method_7803((class_1767)firstColor)));
        craftingInventory.method_5447(1, new class_1799((class_1935)class_1769.method_7803((class_1767)secondColor)));
        return craftingInventory;
    }
}

