/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.mojang.logging.LogUtils;
import de.dafuqs.spectrum.api.entity.PlayerEntityAccessor;
import de.dafuqs.spectrum.blocks.fluid.SpectrumFluidBlock;
import de.dafuqs.spectrum.data_loaders.EntityFishingDataLoader;
import de.dafuqs.spectrum.entity.entity.FireproofItemEntity;
import de.dafuqs.spectrum.helpers.enchantments.ExuberanceHelper;
import de.dafuqs.spectrum.helpers.enchantments.FoundryHelper;
import de.dafuqs.spectrum.items.tools.SpectrumFishingRodItem;
import de.dafuqs.spectrum.loot.SpectrumLootContextTypes;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumLootTables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9279;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class SpectrumFishingBobberEntity
extends class_1676 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_5819 velocityRandom = class_5819.method_43047();
    private boolean caughtFish;
    private int outOfOpenFluidTicks;
    private static final int MAX_OUT_OF_OPEN_WATER_TICKS = 10;
    private static final class_2940<Integer> HOOK_ENTITY_ID = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CAUGHT_FISH = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ABLAZE = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inOpenWater = true;
    @Nullable
    private class_1297 hookedEntity;
    private State state = State.FLYING;
    protected final int luckBonus;
    protected final int waitTimeReductionTicks;
    protected final int exuberanceLevel;
    protected final int bigCatchLevel;
    protected final int serendipityReelLevel;
    protected final boolean inventoryInsertion;

    public SpectrumFishingBobberEntity(class_1299<? extends SpectrumFishingBobberEntity> type, class_1937 world, int luckBonus, int waitTimeReductionTicks, int exuberanceLevel, int bigCatchLevel, int serendipityReelLevel, boolean inventoryInsertion, boolean ablaze) {
        super(type, world);
        this.field_5985 = true;
        this.luckBonus = Math.max(0, luckBonus);
        this.waitTimeReductionTicks = Math.max(0, waitTimeReductionTicks);
        this.exuberanceLevel = Math.max(0, exuberanceLevel);
        this.bigCatchLevel = Math.max(0, bigCatchLevel);
        this.serendipityReelLevel = Math.max(0, serendipityReelLevel);
        this.inventoryInsertion = inventoryInsertion;
        this.method_5841().method_12778(ABLAZE, (Object)ablaze);
    }

    public SpectrumFishingBobberEntity(class_1299<? extends SpectrumFishingBobberEntity> entityType, class_1937 world) {
        this(entityType, world, 0, 0, 0, 0, 0, false, false);
    }

    public SpectrumFishingBobberEntity(class_1299<? extends SpectrumFishingBobberEntity> entityType, class_1657 thrower, class_1937 world, int luckBonus, int waitTimeReductionTicks, int exuberanceLevel, int bigCatchLevel, int serendipityReelLevel, boolean inventoryInsertion, boolean ablaze) {
        this(entityType, world, luckBonus, waitTimeReductionTicks, exuberanceLevel, bigCatchLevel, serendipityReelLevel, inventoryInsertion, ablaze);
        this.method_7432((class_1297)thrower);
        float f = thrower.method_36455();
        float g = thrower.method_36454();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d = thrower.method_23317() - (double)i * 0.3;
        double e = thrower.method_23320();
        double l = thrower.method_23321() - (double)h * 0.3;
        this.method_5808(d, e, l, g, f);
        class_243 vec3d = new class_243((double)(-i), (double)class_3532.method_15363((float)(-(k / j)), (float)-5.0f, (float)5.0f), (double)(-h));
        double m = vec3d.method_1033();
        vec3d = vec3d.method_18805(0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365));
        this.method_18799(vec3d);
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 180.0 / 3.1415927410125732));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * 180.0 / 3.1415927410125732));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(HOOK_ENTITY_ID, (Object)0);
        builder.method_56912(CAUGHT_FISH, (Object)false);
        builder.method_56912(ABLAZE, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (HOOK_ENTITY_ID.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(HOOK_ENTITY_ID);
            class_1297 class_12972 = this.hookedEntity = i > 0 ? this.method_37908().method_8469(i - 1) : null;
        }
        if (CAUGHT_FISH.equals(data)) {
            this.caughtFish = (Boolean)this.method_5841().method_12789(CAUGHT_FISH);
            if (this.caughtFish) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.velocityRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        super.method_5674(data);
    }

    public boolean method_5640(double distance) {
        double d = 64.0;
        return distance < d * d;
    }

    public abstract int getLineColor();

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
    }

    public void method_5773() {
        this.velocityRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.method_37908().method_8510());
        super.method_5773();
        class_1657 playerEntity = this.getPlayerOwner();
        if (playerEntity == null) {
            this.method_31472();
        } else if (this.method_37908().field_9236 || !this.removeIfInvalid(playerEntity)) {
            boolean bl;
            SpectrumFishingRodItem spectrumFishingRodItem;
            boolean canFishInFluid;
            if (this.method_24828()) {
                ++this.removalTimer;
                if (this.removalTimer >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.removalTimer = 0;
            }
            float f = 0.0f;
            class_2338 blockPos = this.method_24515();
            class_3610 fluidState = this.method_37908().method_8316(blockPos);
            class_1792 class_17922 = this.getFishingRod(playerEntity).method_7909();
            boolean bl2 = canFishInFluid = class_17922 instanceof SpectrumFishingRodItem && (spectrumFishingRodItem = (SpectrumFishingRodItem)class_17922).canFishIn(fluidState);
            if (canFishInFluid) {
                f = fluidState.method_15763((class_1922)this.method_37908(), blockPos);
            }
            boolean bl3 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (this.hookedEntity != null) {
                    this.method_18799(class_243.field_1353);
                    this.state = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (bl) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.state = State.BOBBING;
                    return;
                }
                this.checkForCollision();
            } else {
                if (this.state == State.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.method_31481() && this.hookedEntity.method_37908().method_27983() == this.method_37908().method_27983()) {
                            this.method_5814(this.hookedEntity.method_23317(), this.hookedEntity.method_23323(0.8), this.hookedEntity.method_23321());
                            this.hookedEntityTick(this.hookedEntity);
                        } else {
                            this.updateHookedEntityId(null);
                            this.state = State.FLYING;
                        }
                    }
                    return;
                }
                if (this.state == State.BOBBING) {
                    class_243 vec3d = this.method_18798();
                    double d = this.method_23318() + vec3d.field_1351 - (double)blockPos.method_10264() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.method_18800(vec3d.field_1352 * 0.9, vec3d.field_1351 - d * (double)this.field_5974.method_43057() * 0.2, vec3d.field_1350 * 0.9);
                    if (this.hookCountdown <= 0 && this.fishTravelCountdown <= 0) {
                        this.inOpenWater = true;
                    } else {
                        boolean bl4 = this.inOpenWater = this.inOpenWater && this.outOfOpenFluidTicks < 10 && this.isOpenOrWaterAround(blockPos);
                    }
                    if (bl) {
                        this.outOfOpenFluidTicks = Math.max(0, this.outOfOpenFluidTicks - 1);
                        if (this.caughtFish) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.velocityRandom.method_43057() * (double)this.velocityRandom.method_43057(), 0.0));
                        }
                        if (!this.method_37908().field_9236) {
                            this.tickFishingLogic(blockPos);
                        }
                    } else {
                        this.outOfOpenFluidTicks = Math.min(10, this.outOfOpenFluidTicks + 1);
                    }
                }
            }
            if (!canFishInFluid) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_26962();
            if (this.state == State.FLYING && (this.method_24828() || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            double e = 0.92;
            this.method_18799(this.method_18798().method_1021(e));
            this.method_23311();
        }
    }

    public boolean removeIfInvalid(class_1657 player) {
        class_1799 itemStack = player.method_6047();
        class_1799 itemStack2 = player.method_6079();
        boolean bl = itemStack.method_7909() instanceof SpectrumFishingRodItem;
        boolean bl2 = itemStack2.method_7909() instanceof SpectrumFishingRodItem;
        if (!player.method_31481() && player.method_5805() && (bl || bl2) && !(this.method_5858((class_1297)player) > 1024.0)) {
            return false;
        }
        this.method_31472();
        return true;
    }

    private void checkForCollision() {
        class_239 hitResult = class_1675.method_49997((class_1297)this, this::method_26958);
        this.method_59860(hitResult);
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_37908().field_9236) {
            this.updateHookedEntityId(entityHitResult.method_17782());
        }
    }

    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_18799(this.method_18798().method_1029().method_1021(blockHitResult.method_24801((class_1297)this)));
    }

    public void updateHookedEntityId(@Nullable class_1297 entity) {
        this.hookedEntity = entity;
        this.method_5841().method_12778(HOOK_ENTITY_ID, (Object)(entity == null ? 0 : entity.method_5628() + 1));
    }

    public void tickFishingLogic(class_2338 pos) {
        class_3218 serverWorld = (class_3218)this.method_37908();
        int i = 1;
        class_2338 blockPos = pos.method_10084();
        if (this.field_5974.method_43057() < 0.25f && this.method_37908().method_8520(blockPos)) {
            ++i;
        }
        if (this.field_5974.method_43057() < 0.5f && !this.method_37908().method_8311(blockPos)) {
            --i;
        }
        if (this.hookCountdown > 0) {
            --this.hookCountdown;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.method_5841().method_12778(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            this.fishTravelCountdown -= i;
            if (this.fishTravelCountdown > 0) {
                this.fishAngle += (float)this.field_5974.method_43385(0.0, 9.188);
            }
            float f = this.fishAngle * ((float)Math.PI / 180);
            float g = class_3532.method_15374((float)f);
            float h = class_3532.method_15362((float)f);
            double d = this.method_23317() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
            double e = (float)class_3532.method_15357((double)this.method_23318()) + 1.0f;
            double j = this.method_23321() + (double)(h * (float)this.fishTravelCountdown * 0.1f);
            class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)(e - 1.0), (double)j));
            class_3545<class_2400, class_2400> particles = this.getFluidParticles(blockState);
            if (this.fishTravelCountdown > 0) {
                if (particles != null) {
                    if (this.field_5974.method_43057() < 0.15f) {
                        serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), d, e - (double)0.1f, j, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), d, e, j, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), d, e, j, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else if (particles != null) {
                this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                double m = this.method_23318() + 0.5;
                serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                this.hookCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                this.method_5841().method_12778(CAUGHT_FISH, (Object)true);
            }
        } else if (this.waitCountdown > 0) {
            this.waitCountdown -= i;
            float f = 0.15f;
            if (this.waitCountdown < 20) {
                f += (float)(20 - this.waitCountdown) * 0.05f;
            } else if (this.waitCountdown < 40) {
                f += (float)(40 - this.waitCountdown) * 0.02f;
            } else if (this.waitCountdown < 60) {
                f += (float)(60 - this.waitCountdown) * 0.01f;
            }
            if (this.field_5974.method_43057() < f) {
                double j;
                double e;
                float g = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double d = this.method_23317() + (double)(class_3532.method_15374((float)g) * h) * 0.1;
                class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)((e = (double)class_3532.method_15357((double)this.method_23318()) + 1.0) - 1.0), (double)(j = this.method_23321() + (double)(class_3532.method_15362((float)g) * h) * 0.1)));
                class_3545<class_2400, class_2400> particles = this.getFluidParticles(blockState);
                if (particles != null) {
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), d, e, j, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.waitCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)100, (int)600);
            this.waitCountdown -= this.waitTimeReductionTicks;
            this.waitCountdown = Math.max(1, this.waitCountdown);
        }
    }

    @Nullable
    private class_3545<class_2400, class_2400> getFluidParticles(class_2680 blockState) {
        class_3545 particles = null;
        class_2248 class_22482 = this.method_37908().method_8320(this.method_24515()).method_26204();
        if (class_22482 instanceof SpectrumFluidBlock) {
            SpectrumFluidBlock spectrumFluidBlock = (SpectrumFluidBlock)class_22482;
            particles = spectrumFluidBlock.getFishingParticles();
        } else if (blockState.method_27852(class_2246.field_10164)) {
            particles = new class_3545((Object)class_2398.field_11240, (Object)SpectrumParticleTypes.LAVA_FISHING);
        } else if (blockState.method_27852(class_2246.field_10382)) {
            particles = new class_3545((Object)class_2398.field_11247, (Object)class_2398.field_11244);
        }
        return particles;
    }

    public boolean isOpenOrWaterAround(class_2338 pos) {
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            PositionType positionType2 = this.getPositionType(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
            switch (positionType2.ordinal()) {
                case 0: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (positionType != PositionType.ABOVE_FLUID) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    public PositionType getPositionType(class_2338 start, class_2338 end) {
        return class_2338.method_20437((class_2338)start, (class_2338)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
    }

    public PositionType getPositionType(class_2338 pos) {
        class_2680 blockState = this.method_37908().method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return !fluidState.method_15769() && fluidState.method_15771() && blockState.method_26220((class_1922)this.method_37908(), pos).method_1110() ? PositionType.INSIDE_FLUID : PositionType.INVALID;
        }
        return PositionType.ABOVE_FLUID;
    }

    public boolean isInOpenWater() {
        return this.inOpenWater;
    }

    public int use(class_1799 usedItem) {
        class_1657 playerEntity = this.getPlayerOwner();
        if (!this.method_37908().method_8608() && playerEntity != null && !this.removeIfInvalid(playerEntity)) {
            int i = 0;
            if (this.hookedEntity != null) {
                this.pullHookedEntity(this.hookedEntity);
                SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, null, Collections.emptyList());
                this.method_37908().method_8421((class_1297)this, (byte)31);
                i = this.hookedEntity instanceof class_1542 ? 3 : 5;
            } else if (this.hookCountdown > 0) {
                if (!this.tryCatchEntity(usedItem, playerEntity, (class_3218)this.method_37908(), this.method_24515())) {
                    int lootAmount = this.field_5974.method_39332(1, (int)Math.pow(2.0, 1 + this.serendipityReelLevel) - 1);
                    for (int j = 0; j < lootAmount; ++j) {
                        this.catchLoot(usedItem, playerEntity);
                    }
                }
                i = 1;
            }
            if (this.method_24828()) {
                i = 2;
            }
            this.method_31472();
            return i;
        }
        return 0;
    }

    public void method_5711(byte status) {
        if (status == 31 && this.method_37908().field_9236 && this.hookedEntity instanceof class_1657 && ((class_1657)this.hookedEntity).method_7340()) {
            this.pullHookedEntity(this.hookedEntity);
        }
        super.method_5711(status);
    }

    public void pullHookedEntity(class_1297 entity) {
        class_1297 entity2 = this.method_24921();
        if (entity2 != null) {
            class_243 vec3d = new class_243(entity2.method_23317() - this.method_23317(), entity2.method_23318() - this.method_23318(), entity2.method_23321() - this.method_23321()).method_1021(0.1);
            entity.method_18799(entity.method_18798().method_1019(vec3d));
        }
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.setPlayerFishHook(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.setPlayerFishHook(null);
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        this.setPlayerFishHook(this);
    }

    public void setPlayerFishHook(@Nullable SpectrumFishingBobberEntity fishingBobber) {
        class_1657 playerEntity = this.getPlayerOwner();
        if (playerEntity != null) {
            ((PlayerEntityAccessor)playerEntity).setSpectrumBobber(fishingBobber);
        }
    }

    @Nullable
    public class_1657 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (class_1657)entity : null;
    }

    @Nullable
    public class_1297 getHookedEntity() {
        return this.hookedEntity;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getPlayerOwner() == null) {
            int entityData = packet.method_11166();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.method_37908().method_8469(entityData), (Object)entityData);
            this.method_5768();
        }
    }

    public class_1799 getFishingRod(class_1657 player) {
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7909() instanceof SpectrumFishingRodItem) {
            return itemStack;
        }
        itemStack = player.method_6079();
        if (itemStack.method_7909() instanceof SpectrumFishingRodItem) {
            return itemStack;
        }
        return class_1799.field_8037;
    }

    private boolean tryCatchEntity(class_1799 usedItem, class_1657 playerEntity, class_3218 world, class_2338 blockPos) {
        Optional<EntityFishingDataLoader.EntityFishingEntity> caughtEntityType = EntityFishingDataLoader.tryCatchEntity(world, blockPos, this.bigCatchLevel);
        if (caughtEntityType.isPresent()) {
            class_6880<class_1299<?>> entityType = caughtEntityType.get().entityType();
            class_9279 nbt = class_9279.method_57456((class_2487)caughtEntityType.get().nbt());
            class_1297 entity = ((class_1299)entityType.comp_349()).method_5899(world, ent -> class_1299.method_5881((class_1937)world, (class_1657)playerEntity, (class_1297)ent, (class_9279)nbt), blockPos, class_3730.field_16461, false, false);
            if (entity != null) {
                double xDif = playerEntity.method_23317() - this.method_23317();
                double yDif = playerEntity.method_23318() - this.method_23318();
                double zDif = playerEntity.method_23321() - this.method_23321();
                double velocityMod = 0.15;
                entity.method_5762(xDif * velocityMod, yDif * velocityMod + Math.sqrt(Math.sqrt(xDif * xDif + yDif * yDif + zDif * zDif)) * 0.08, zDif * velocityMod);
                if (this.isAblaze()) {
                    entity.method_5639(4.0f);
                }
                if (entity instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity;
                    mobEntity.method_5966();
                    mobEntity.method_5990();
                }
                SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, entity, List.of());
                return true;
            }
        }
        return false;
    }

    protected void catchLoot(class_1799 usedItem, class_1657 playerEntity) {
        class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)playerEntity.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)usedItem).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_1227, (Object)playerEntity).method_51871((float)this.luckBonus + playerEntity.method_7292()).method_51875(SpectrumLootContextTypes.FISHING);
        if (this.method_37908().method_8503() == null) {
            return;
        }
        class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(SpectrumLootTables.UNIVERSAL_FISHING);
        Object list = lootTable.method_51878(lootContextParameterSet);
        SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, null, (Collection<class_1799>)list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (!itemStack.method_31573(class_3489.field_15527)) continue;
            playerEntity.method_7339(class_3468.field_15391, 1);
        }
        if (this.isAblaze()) {
            list = FoundryHelper.applyFoundry(this.method_37908(), (List<class_1799>)list);
        }
        float exuberanceMod = ExuberanceHelper.getExuberanceMod(this.exuberanceLevel);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            class_1799 itemStack = (class_1799)iterator2.next();
            int experienceAmount = this.field_5974.method_43048((int)(6.0f * exuberanceMod) + 1);
            if (this.inventoryInsertion) {
                playerEntity.method_31548().method_7398(itemStack);
                playerEntity.method_7255(experienceAmount);
                playerEntity.method_37908().method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((playerEntity.method_59922().method_43057() - playerEntity.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                continue;
            }
            FireproofItemEntity itemEntity = new FireproofItemEntity(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
            double d = playerEntity.method_23317() - this.method_23317();
            double e = playerEntity.method_23318() - this.method_23318();
            double f = playerEntity.method_23321() - this.method_23321();
            double g = 0.1;
            itemEntity.method_18800(d * g, e * g + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * g);
            this.method_37908().method_8649((class_1297)itemEntity);
            if (experienceAmount <= 0) continue;
            playerEntity.method_37908().method_8649((class_1297)new class_1303(playerEntity.method_37908(), playerEntity.method_23317(), playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, experienceAmount));
        }
    }

    public boolean isAblaze() {
        return (Boolean)this.method_5841().method_12789(ABLAZE);
    }

    public boolean method_5862() {
        return this.isAblaze();
    }

    protected void hookedEntityTick(class_1297 hookedEntity) {
    }

    public static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    public static enum PositionType {
        ABOVE_FLUID,
        INSIDE_FLUID,
        INVALID;

    }
}

