/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.item.ModularExplosionProvider;
import de.dafuqs.spectrum.explosion.ExplosionArchetype;
import de.dafuqs.spectrum.explosion.ExplosionModifier;
import de.dafuqs.spectrum.explosion.ExplosionModifierType;
import de.dafuqs.spectrum.explosion.ModularExplosion;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumRegistryKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularExplosionDefinition {
    public static final Codec<ModularExplosionDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_3542.method_28140(ExplosionArchetype::values).fieldOf("archetype").forGetter(c -> c.archetype), (App)SpectrumRegistries.EXPLOSION_MODIFIER.method_39673().listOf().optionalFieldOf("modifiers", List.of()).forGetter(c -> c.modifiers)).apply((Applicative)i, ModularExplosionDefinition::new));
    public static final class_9139<class_9129, ModularExplosionDefinition> PACKET_CODEC = PacketCodecHelper.tuple(ExplosionArchetype.PACKET_CODEC, c -> c.archetype, class_9135.method_56365(SpectrumRegistryKeys.EXPLOSION_MODIFIER).method_56433(class_9135.method_56363()), c -> c.modifiers, ModularExplosionDefinition::new);
    protected ExplosionArchetype archetype = ExplosionArchetype.COSMETIC;
    protected List<ExplosionModifier> modifiers;

    public ModularExplosionDefinition() {
        this.modifiers = new ArrayList<ExplosionModifier>();
    }

    public ModularExplosionDefinition(ExplosionArchetype archetype, List<ExplosionModifier> modifiers) {
        this.archetype = archetype;
        this.modifiers = modifiers;
    }

    public static ModularExplosionDefinition getFromStack(class_1799 stack) {
        return (ModularExplosionDefinition)stack.method_57825(SpectrumDataComponentTypes.MODULAR_EXPLOSION, (Object)new ModularExplosionDefinition());
    }

    public static ModularExplosionDefinition clone(ModularExplosionDefinition original) {
        return new ModularExplosionDefinition(original.archetype, new ArrayList<ExplosionModifier>(original.modifiers));
    }

    public static ModularExplosionDefinition cloneFromStack(class_1799 stack) {
        return ModularExplosionDefinition.clone(ModularExplosionDefinition.getFromStack(stack));
    }

    public static void removeFromStack(class_1799 stack) {
        stack.method_57381(SpectrumDataComponentTypes.MODULAR_EXPLOSION);
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, @Nullable class_1657 owner, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ModularExplosionProvider) {
            ModularExplosionProvider provider = (ModularExplosionProvider)class_17922;
            ModularExplosionDefinition definition = ModularExplosionDefinition.getFromStack(stack);
            ModularExplosion.explode(world, pos, owner, provider.getBaseExplosionBlastRadius(), provider.getBaseExplosionDamage(), definition.archetype, definition.modifiers);
        }
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, class_2350 direction, @Nullable class_1657 owner, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ModularExplosionProvider) {
            ModularExplosionProvider provider = (ModularExplosionProvider)class_17922;
            ModularExplosionDefinition definition = ModularExplosionDefinition.getFromStack(stack);
            class_2338 finalPos = pos.method_10079(direction, (int)provider.getBaseExplosionBlastRadius() - 2);
            ModularExplosion.explode(world, finalPos, owner, provider.getBaseExplosionBlastRadius(), provider.getBaseExplosionDamage(), definition.archetype, definition.modifiers);
        }
    }

    public void addModifiers(List<ExplosionModifier> modifiers) {
        try {
            this.modifiers.addAll(modifiers);
        }
        catch (UnsupportedOperationException e) {
            ArrayList<ExplosionModifier> newModifiers = new ArrayList<ExplosionModifier>();
            newModifiers.addAll(this.modifiers);
            newModifiers.addAll(modifiers);
            this.modifiers = newModifiers;
        }
    }

    public ExplosionArchetype getArchetype() {
        return this.archetype;
    }

    public void setArchetype(ExplosionArchetype archetype) {
        this.archetype = archetype;
    }

    public boolean isValid(ModularExplosionProvider provider) {
        if (this.modifiers.size() > provider.getMaxExplosionModifiers()) {
            return false;
        }
        HashMap<ExplosionModifierType, Integer> occurrences = new HashMap<ExplosionModifierType, Integer>();
        for (ExplosionModifier modifier : this.modifiers) {
            if (!modifier.type.acceptsArchetype(this.archetype)) {
                return false;
            }
            ExplosionModifierType type = modifier.getType();
            int typeCount = occurrences.getOrDefault(type, 0);
            if (typeCount > type.getMaxModifiersForType()) {
                return false;
            }
            occurrences.put(type, typeCount + 1);
        }
        return true;
    }

    public int getModifierCount() {
        return this.modifiers.size();
    }

    public void attachToStack(class_1799 stack) {
        stack.method_57379(SpectrumDataComponentTypes.MODULAR_EXPLOSION, (Object)this);
    }

    public void appendTooltip(List<class_2561> tooltip, ModularExplosionProvider provider) {
        int modifierCount = this.modifiers.size();
        int maxModifierCount = provider.getMaxExplosionModifiers();
        tooltip.add(this.archetype.getName());
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.tooltip.explosives.remaining_slots", (Object[])new Object[]{modifierCount, maxModifierCount}).method_27692(class_124.field_1080));
        if (modifierCount == 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.tooltip.explosives.modifiers").method_27692(class_124.field_1080));
        } else {
            for (ExplosionModifier explosionModifier : this.modifiers) {
                tooltip.add(explosionModifier.getName());
            }
        }
    }

    public void explode(@NotNull class_3218 world, class_2338 pos, @Nullable class_1657 owner, double baseBlastRadius, float baseDamage) {
        ModularExplosion.explode(world, pos, owner, baseBlastRadius, baseDamage, this.archetype, this.modifiers);
    }
}

