/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;

public class WeightedPool<E extends class_6008> {
    private final int totalWeight;
    private final ImmutableList<E> entries;

    public WeightedPool(List<? extends E> entries) {
        this.entries = ImmutableList.copyOf(entries);
        this.totalWeight = class_6011.method_34984(entries);
    }

    public static <E extends class_6008> WeightedPool<E> empty() {
        return new WeightedPool<E>(ImmutableList.of());
    }

    @SafeVarargs
    public static <E extends class_6008> WeightedPool<E> of(E ... entries) {
        return new WeightedPool<E>(ImmutableList.copyOf((Object[])entries));
    }

    public static <E extends class_6008> WeightedPool<E> of(List<E> entries) {
        return new WeightedPool<E>(entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Optional<E> getOrEmpty(class_5819 random) {
        if (this.totalWeight == 0) {
            return Optional.empty();
        }
        int i = random.method_43048(this.totalWeight);
        return class_6011.method_34985(this.entries, (int)i);
    }

    public List<E> getEntries() {
        return this.entries;
    }

    public static <E extends class_6008> Codec<WeightedPool<E>> createCodec(Codec<E> entryCodec) {
        return entryCodec.listOf().xmap(WeightedPool::of, WeightedPool::getEntries);
    }
}

