/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.PigmentItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_4861;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_8047;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BedrockAnvilScreenHandler
extends class_4861 {
    public static final int MAX_LORE_LENGTH = 200;
    public static final int FIRST_INPUT_SLOT_INDEX = 0;
    public static final int SECOND_INPUT_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;
    private final class_3915 levelCost = class_3915.method_17403();
    private int repairItemCount;
    private String newItemName;
    private String newLoreString;

    public BedrockAnvilScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, class_3914.field_17304);
    }

    public BedrockAnvilScreenHandler(int syncId, class_1661 inventory, class_3914 context) {
        super(SpectrumScreenHandlerTypes.BEDROCK_ANVIL, syncId, inventory, context);
        this.method_17362(this.levelCost);
    }

    protected class_8047 method_48352() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> true).method_48374(1, 76, 47, stack -> true).method_48373(2, 134, 47).method_48372();
    }

    public void method_48353(class_1661 playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 108 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 166));
        }
    }

    protected boolean method_24925(class_2680 state) {
        return state.method_26164(class_3481.field_15486);
    }

    public static int getNextCost(int cost) {
        return cost * 2 + 1;
    }

    protected boolean method_24927(class_1657 player, boolean present) {
        return player.method_56992() || player.field_7520 >= this.levelCost.method_17407();
    }

    protected void method_24923(class_1657 player, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            player.method_7316(-this.levelCost.method_17407());
        }
        this.field_22480.method_5447(0, class_1799.field_8037);
        if (this.repairItemCount > 0) {
            class_1799 itemStack = this.field_22480.method_5438(1);
            if (!itemStack.method_7960() && itemStack.method_7947() > this.repairItemCount) {
                itemStack.method_7934(this.repairItemCount);
                this.field_22480.method_5447(1, itemStack);
            } else {
                this.field_22480.method_5447(1, class_1799.field_8037);
            }
        } else {
            this.field_22480.method_5447(1, class_1799.field_8037);
        }
        this.levelCost.method_17404(0);
        this.field_22481.method_17393((world, pos) -> world.method_20290(1030, pos, 0));
    }

    public void method_24928() {
        boolean combined = false;
        class_1799 inputStack = this.field_22480.method_5438(0);
        this.levelCost.method_17404(0);
        int enchantmentLevelCost = 0;
        long repairLevelCost = 0L;
        if (!inputStack.method_7960() && class_1890.method_57529((class_1799)inputStack)) {
            class_1799 outputStack = inputStack.method_7972();
            class_1799 repairSlotStack = this.field_22480.method_5438(1);
            class_9304.class_9305 builder = new class_9304.class_9305(class_1890.method_57532((class_1799)outputStack));
            repairLevelCost += (long)((Integer)inputStack.method_57825(class_9334.field_49639, (Object)0)).intValue() + (long)((Integer)repairSlotStack.method_57825(class_9334.field_49639, (Object)0)).intValue();
            this.repairItemCount = 0;
            boolean pigmentInRepairSlot = repairSlotStack.method_7909() instanceof PigmentItem;
            if (pigmentInRepairSlot) {
                this.repairItemCount = 1;
            }
            if (!repairSlotStack.method_7960()) {
                boolean enchantedBookInRepairSlot;
                combined = true;
                boolean bl = enchantedBookInRepairSlot = repairSlotStack.method_31574(class_1802.field_8598) && repairSlotStack.method_57826(class_9334.field_49643);
                if (outputStack.method_7963() && outputStack.method_7909().method_7878(inputStack, repairSlotStack)) {
                    int repairItemCount;
                    int toRepair = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    if (toRepair <= 0) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    for (repairItemCount = 0; toRepair > 0 && repairItemCount < repairSlotStack.method_7947(); ++repairItemCount) {
                        int newOutputStackDamage = outputStack.method_7919() - toRepair;
                        outputStack.method_7974(newOutputStackDamage);
                        ++enchantmentLevelCost;
                        toRepair = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    }
                    this.repairItemCount = repairItemCount;
                } else {
                    if (!(pigmentInRepairSlot || enchantedBookInRepairSlot || outputStack.method_31574(repairSlotStack.method_7909()) && outputStack.method_7963())) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    if (outputStack.method_7963() && !enchantedBookInRepairSlot && !pigmentInRepairSlot) {
                        int inputItemDurability = inputStack.method_7936() - inputStack.method_7919();
                        int repairItemDurability = repairSlotStack.method_7936() - repairSlotStack.method_7919();
                        int toRepair = repairItemDurability + outputStack.method_7936() * 12 / 100;
                        int outputItemDurability = inputItemDurability + toRepair;
                        int outputItemDamage = outputStack.method_7936() - outputItemDurability;
                        if (outputItemDamage < 0) {
                            outputItemDamage = 0;
                        }
                        if (outputItemDamage < outputStack.method_7919()) {
                            outputStack.method_7974(outputItemDamage);
                            enchantmentLevelCost += 2;
                        }
                    }
                    class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)repairSlotStack);
                    boolean foundAcceptable = false;
                    boolean foundUnacceptable = false;
                    for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                        boolean capToMaxLevel;
                        int newEnchantmentLevel;
                        class_6880 registryEntry = (class_6880)entry.getKey();
                        int t = builder.method_57546(registryEntry);
                        newEnchantmentLevel = t == (newEnchantmentLevel = entry.getIntValue()) ? newEnchantmentLevel + 1 : Math.max(newEnchantmentLevel, t);
                        class_1887 enchantment = (class_1887)registryEntry.comp_349();
                        boolean itemStackIsAcceptableForStack = inputStack.canBeEnchantedWith(registryEntry, EnchantingContext.ACCEPTABLE);
                        if (this.field_22482.method_31549().field_7477 || inputStack.method_31574(class_1802.field_8598)) {
                            itemStackIsAcceptableForStack = true;
                        }
                        for (class_6880 registryEntry2 : builder.method_57545()) {
                            if (registryEntry2.equals((Object)registryEntry) || class_1887.method_60033((class_6880)registryEntry, (class_6880)registryEntry2)) continue;
                            itemStackIsAcceptableForStack = false;
                            ++enchantmentLevelCost;
                        }
                        if (!itemStackIsAcceptableForStack) {
                            foundUnacceptable = true;
                            continue;
                        }
                        foundAcceptable = true;
                        boolean bl2 = capToMaxLevel = inputStack.method_31574(class_1802.field_8598) && !inputStack.method_57826(class_9334.field_49643) || !SpectrumCommon.CONFIG.BedrockAnvilCanExceedMaxVanillaEnchantmentLevel;
                        if (capToMaxLevel && newEnchantmentLevel > enchantment.method_8183()) {
                            newEnchantmentLevel = enchantment.method_8183();
                        }
                        builder.method_57547(registryEntry, newEnchantmentLevel);
                        int anvilCost = enchantment.method_58446();
                        if (enchantedBookInRepairSlot) {
                            anvilCost = Math.max(1, anvilCost / 2);
                        }
                        enchantmentLevelCost += anvilCost * newEnchantmentLevel;
                        if (inputStack.method_7947() <= 1) continue;
                        enchantmentLevelCost = 40;
                    }
                    if (foundUnacceptable && !foundAcceptable) {
                        this.field_22479.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                }
            }
            if (pigmentInRepairSlot || this.newItemName != null && !class_3544.method_57181((String)this.newItemName)) {
                class_5250 newName = class_2561.method_43470((String)this.newItemName);
                class_2561 class_25612 = inputStack.method_7964();
                if (class_25612 instanceof class_5250) {
                    class_5250 inputText = (class_5250)class_25612;
                    newName.method_10862(inputText.method_10866());
                }
                if (pigmentInRepairSlot) {
                    int newColor = ((PigmentItem)repairSlotStack.method_7909()).getInkColor().getColorInt();
                    newName = newName.method_10862(newName.method_10866().method_36139(newColor));
                }
                outputStack.method_57379(class_9334.field_49631, (Object)newName);
            } else if (inputStack.method_57826(class_9334.field_49631)) {
                outputStack.method_57381(class_9334.field_49631);
            }
            if (this.newLoreString != null && !class_3544.method_57181((String)this.newLoreString)) {
                List<class_2561> lore = LoreHelper.getLoreTextArrayFromString(this.newLoreString);
                if (!LoreHelper.equalsLore(lore, inputStack)) {
                    LoreHelper.setLore(outputStack, lore);
                }
            } else if (LoreHelper.hasLore(inputStack)) {
                LoreHelper.removeLore(outputStack);
            }
            int totalCost = (int)class_3532.method_53062((long)(repairLevelCost + (long)enchantmentLevelCost), (long)0L, (long)Integer.MAX_VALUE);
            this.levelCost.method_17404(totalCost);
            if (enchantmentLevelCost < 0) {
                outputStack = class_1799.field_8037;
            }
            if (!combined || pigmentInRepairSlot) {
                this.levelCost.method_17404(0);
            } else if (!outputStack.method_7960()) {
                int repairCost = (Integer)outputStack.method_57825(class_9334.field_49639, (Object)0);
                if (repairCost < (Integer)repairSlotStack.method_57825(class_9334.field_49639, (Object)0)) {
                    repairCost = (Integer)repairSlotStack.method_57825(class_9334.field_49639, (Object)0);
                }
                if (enchantmentLevelCost > 0) {
                    repairCost = BedrockAnvilScreenHandler.getNextCost(repairCost);
                    outputStack.method_57379(class_9334.field_49639, (Object)repairCost);
                }
                class_1890.method_57530((class_1799)outputStack, (class_9304)builder.method_57549());
            }
            this.field_22479.method_5447(0, outputStack);
            this.method_7623();
        } else {
            this.field_22479.method_5447(0, class_1799.field_8037);
            this.levelCost.method_17404(0);
        }
    }

    public boolean setNewItemName(String newItemName) {
        String string = BedrockAnvilScreenHandler.sanitize(newItemName, 50);
        if (string != null && !string.equals(this.newItemName)) {
            this.newItemName = string;
            if (this.method_7611(2).method_7681()) {
                class_1799 itemStack = this.method_7611(2).method_7677();
                if (class_3544.method_57181((String)string)) {
                    itemStack.method_57381(class_9334.field_49631);
                } else {
                    itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)string));
                }
            }
            this.method_24928();
            return true;
        }
        return false;
    }

    @Nullable
    private static String sanitize(String name, int maxLength) {
        String string = class_3544.method_57180((String)name);
        return string.length() <= maxLength ? string : null;
    }

    public boolean setNewItemLore(String newLoreString) {
        String string = BedrockAnvilScreenHandler.sanitize(newLoreString, 200);
        if (string != null && !string.equals(this.newLoreString)) {
            this.newLoreString = string;
            if (this.method_7611(2).method_7681()) {
                class_1799 itemStack = this.method_7611(2).method_7677();
                if (StringUtils.isBlank((CharSequence)newLoreString)) {
                    LoreHelper.removeLore(itemStack);
                } else {
                    LoreHelper.setLore(itemStack, LoreHelper.getLoreTextArrayFromString(this.newLoreString));
                }
            }
            this.method_24928();
            return true;
        }
        return false;
    }

    public int getLevelCost() {
        return this.levelCost.method_17407();
    }
}

