/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class InkGaugeWidget
implements class_4068,
class_364,
class_6379 {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean focused;
    protected boolean hovered;
    protected final class_437 screen;
    protected final InkStorageBlockEntity<?> blockEntity;

    public InkGaugeWidget(int x, int y, int width, int height, class_437 screen, InkStorageBlockEntity<?> blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_332 drawContext, int x, int y) {
        class_310 client = class_310.method_1551();
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        for (InkColor color : InkColors.all()) {
            long amount = this.blockEntity.getEnergyStorage().getEnergy(color);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
        if (tooltip.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_powered.empty"));
        } else {
            tooltip.add(0, (class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_powered.stored"));
        }
        drawContext.method_51437(client.field_1772, tooltip, Optional.empty(), x, y);
    }

    public void draw(class_332 drawContext) {
        long totalInk = this.blockEntity.getEnergyStorage().getCurrentTotal();
        if (totalInk > 0L) {
            int centerX = this.x + this.width / 2;
            int centerY = this.y + this.width / 2;
            int radius = 22;
            double startRad = -1.5707963267948966;
            for (InkColor color : InkColors.all()) {
                double curr;
                long currentInk = this.blockEntity.getEnergyStorage().getEnergy(color);
                if (currentInk <= 0L) continue;
                for (double thisPart = (double)currentInk / (double)totalInk; thisPart > 0.0; thisPart -= curr) {
                    curr = Math.min(0.2, thisPart);
                    double endRad = startRad + curr * 2.0 * Math.PI;
                    int p2x = (int)((double)radius * Math.cos(startRad));
                    int p2y = (int)((double)radius * Math.sin(startRad));
                    int p3x = (int)((double)radius * Math.cos(endRad));
                    int p3y = (int)((double)radius * Math.sin(endRad));
                    RenderHelper.fillTriangle(drawContext.method_51448(), centerX, centerY, centerX + p3x, centerY + p3y, centerX + p2x, centerY + p2y, color.getColorVec());
                    double middleRad = startRad + curr * Math.PI;
                    int pmx = (int)((double)radius * Math.cos(middleRad));
                    int pmy = (int)((double)radius * Math.sin(middleRad));
                    RenderHelper.fillTriangle(drawContext.method_51448(), centerX + p3x, centerY + p3y, centerX + pmx, centerY + pmy, centerX + p2x, centerY + p2y, color.getColorVec());
                    startRad = endRad;
                }
            }
        }
    }
}

