/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class InkMeterWidget
implements class_4068,
class_364,
class_6379 {
    public static final int WIDTH_PER_COLOR = 4;
    public static final int SPACE_BETWEEN_COLORS = 2;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean hovered;
    protected boolean focused;
    protected final class_437 screen;
    protected final InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity;

    public InkMeterWidget(int x, int y, int height, class_437 screen, InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity) {
        this.x = x;
        this.y = y;
        this.width = inkStorageBlockEntity.getEnergyStorage().getSupportedColors().size() * 6 - 2;
        this.height = height;
        this.screen = screen;
        this.inkStorageBlockEntity = inkStorageBlockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_332 drawContext, int x, int y) {
        class_310 client = class_310.method_1551();
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.inkStorageBlockEntity.getEnergyStorage().addTooltip(tooltip);
        drawContext.method_51437(client.field_1772, tooltip, Optional.empty(), x, y);
    }

    public void draw(class_332 drawContext, List<InkColor> colors) {
        int startHeight = this.y + this.height;
        int currentXOffset = 0;
        IndividualCappedInkStorage inkStorage = this.inkStorageBlockEntity.getEnergyStorage();
        long total = inkStorage.getMaxPerColor();
        for (InkColor color : colors) {
            long amount = inkStorage.getEnergy(color);
            if (amount > 0L) {
                int height = Math.max(1, Math.round((float)amount / ((float)total / (float)this.height)));
                RenderHelper.fillQuad(drawContext.method_51448(), this.x + currentXOffset, startHeight - height, height, 4, color.getColorVec());
            }
            currentXOffset = currentXOffset + 4 + 2;
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }
}

