/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.item.LoomPatternProvider;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.CraftingTabletScreenHandler;
import de.dafuqs.spectrum.items.tooltip.CraftingTabletTooltipData;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingTabletItem
extends class_1792
implements LoomPatternProvider {
    private static final class_2561 TITLE = class_2561.method_43471((String)"item.spectrum.crafting_tablet");

    public CraftingTabletItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void setStoredRecipe(class_1799 craftingTabletItemStack, class_8786<?> recipe) {
        craftingTabletItemStack.method_57379(SpectrumDataComponentTypes.STORED_RECIPE, (Object)recipe.comp_1932());
    }

    public static void clearStoredRecipe(class_1799 craftingTabletItemStack) {
        craftingTabletItemStack.method_57381(SpectrumDataComponentTypes.STORED_RECIPE);
    }

    @Nullable
    public static class_8786<?> getStoredRecipe(class_1937 world, class_1799 itemStack) {
        class_2960 id;
        if (world != null && (id = (class_2960)itemStack.method_57824(SpectrumDataComponentTypes.STORED_RECIPE)) != null) {
            return world.method_8433().method_8130(id).orElse(null);
        }
        return null;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_8786<?> storedRecipe = CraftingTabletItem.getStoredRecipe(world, itemStack);
        if (storedRecipe == null || user.method_5715()) {
            if (world.field_9236) {
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
            user.method_17355(this.createScreenHandlerFactory(world, (class_3222)user, itemStack));
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        if (storedRecipe.comp_1933() instanceof PedestalRecipe) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        if (CraftingTabletItem.tryCraftRecipe(user, storedRecipe.comp_1933(), world)) {
            if (world.field_9236) {
                return class_1271.method_22427((Object)user.method_5998(hand));
            }
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        user.method_5783(SpectrumSoundEvents.USE_FAIL, 1.0f, 1.0f);
        return class_1271.method_22431((Object)user.method_5998(hand));
    }

    public class_3908 createScreenHandlerFactory(class_1937 world, class_3222 serverPlayerEntity, class_1799 itemStack) {
        return new class_747((syncId, inventory, player) -> new CraftingTabletScreenHandler(syncId, inventory, class_3914.method_17392((class_1937)world, (class_2338)serverPlayerEntity.method_24515()), itemStack), TITLE);
    }

    public static boolean tryCraftRecipe(class_1657 serverPlayerEntity, class_1860<?> recipe, class_1937 world) {
        class_2371 ingredients = recipe.method_8117();
        class_1661 playerInventory = serverPlayerEntity.method_31548();
        boolean hasInInventory = InventoryHelper.hasInInventory((List<class_1856>)ingredients, (class_1263)playerInventory);
        if (world.field_9236) {
            return hasInInventory;
        }
        if (InventoryHelper.hasInInventory((List<class_1856>)ingredients, (class_1263)playerInventory)) {
            List<class_1799> remainders = InventoryHelper.removeFromInventoryWithRemainders((List<class_1856>)ingredients, (class_1263)playerInventory);
            class_1799 craftingResult = recipe.method_8110((class_7225.class_7874)serverPlayerEntity.method_37908().method_30349()).method_7972();
            serverPlayerEntity.method_31548().method_7398(craftingResult);
            for (class_1799 remainder : remainders) {
                serverPlayerEntity.method_31548().method_7398(remainder);
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        class_8786<?> recipe = CraftingTabletItem.getStoredRecipe((class_1937)class_310.method_1551().field_1687, stack);
        if (recipe == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.crafting_tablet.tooltip.no_recipe").method_27692(class_124.field_1080));
        } else {
            if (recipe.comp_1933() instanceof PedestalRecipe) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.crafting_tablet.tooltip.pedestal_recipe").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.crafting_tablet.tooltip.crafting_recipe").method_27692(class_124.field_1080));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.crafting_tablet.tooltip.shift_to_view_gui").method_27692(class_124.field_1080));
        }
        this.addBannerPatternProviderTooltip(tooltip);
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_310 client = class_310.method_1551();
        class_8786<?> storedRecipe = CraftingTabletItem.getStoredRecipe((class_1937)client.field_1687, stack);
        if (storedRecipe != null) {
            return Optional.of(new CraftingTabletTooltipData(storedRecipe.comp_1933(), (class_1937)client.field_1687));
        }
        return Optional.empty();
    }

    @Override
    public class_5321<class_2582> getPattern() {
        return SpectrumBannerPatterns.CRAFTING_TABLET;
    }
}

