/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.map;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.items.map.ArtisansAtlasState;
import de.dafuqs.spectrum.registries.SpectrumStructureTags;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalStructureTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ArtisansAtlasItem
extends class_1806 {
    public static final int COOLDOWN_DURATION_TICKS = 20;

    public ArtisansAtlasItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private static void createAndSetState(class_1799 stack, class_3218 world, int centerX, int centerZ, @Nullable class_3449 target, @Nullable class_2960 targetId) {
        ArtisansAtlasState state = new ArtisansAtlasState(centerX, centerZ, 1, true, true, false, (class_5321<class_1937>)world.method_27983());
        class_9209 id = world.method_17889();
        state.setTargetId(targetId);
        if (targetId != null) {
            state.startLocator(world);
            if (target != null) {
                state.addTarget((class_1936)world, target.method_14969().method_22874());
            }
        } else {
            state.cancelLocator();
        }
        world.method_17890(id, (class_22)state);
        stack.method_57379(class_9334.field_49646, (Object)id);
    }

    public void method_7998(class_1937 world, class_1297 entity, class_22 state) {
        class_1657 playerEntity;
        block13: {
            block12: {
                if (world.method_27983() != state.field_118 || !(entity instanceof class_1657)) break block12;
                playerEntity = (class_1657)entity;
                if (state instanceof ArtisansAtlasState) break block13;
            }
            return;
        }
        ArtisansAtlasState atlasState = (ArtisansAtlasState)state;
        int sampleSize = 1 << state.field_119;
        class_22.class_23 playerUpdateTracker = state.method_101(playerEntity);
        ++playerUpdateTracker.field_131;
        class_2382 delta = atlasState.getDisplayDelta();
        if (delta == null) {
            delta = entity.method_24515().method_10059((class_2382)atlasState.getDisplayedCenter());
            int deltaX = delta.method_10263() / sampleSize;
            int deltaZ = delta.method_10260() / sampleSize;
            for (int x = 0; x <= 127; ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
            atlasState.clearDisplayDelta();
            return;
        }
        int deltaX = delta.method_10263() / sampleSize;
        int deltaZ = delta.method_10260() / sampleSize;
        if (deltaX < 0) {
            int x;
            for (x = 127; x >= -deltaX; --x) {
                this.updateOrCopyVerticalStrip(world, atlasState, deltaX, deltaZ, x, playerUpdateTracker.field_131);
            }
            for (x = 0; x <= Math.min(127, -deltaX - 1); ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
        } else {
            int x;
            for (x = 0; x <= 127 - deltaX; ++x) {
                this.updateOrCopyVerticalStrip(world, atlasState, deltaX, deltaZ, x, playerUpdateTracker.field_131);
            }
            for (x = Math.max(0, 127 - deltaX + 1); x <= 127; ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
        }
        if (deltaX != 0 || deltaZ != 0) {
            atlasState.clearDisplayDelta();
        }
    }

    private void updateOrCopyVerticalStrip(class_1937 world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int tick) {
        if (deltaX > 127 || deltaX < -127 || deltaZ > 127 || deltaZ < -127 || (x & 0xF) == (tick & 0xF)) {
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 0, 127);
        } else if (deltaZ < 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 127, -deltaZ);
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 0, -deltaZ - 1);
        } else if (deltaZ > 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 0, 127 - deltaZ);
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 127 - deltaZ + 1, 127);
        } else if (deltaX != 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 0, 127);
        }
    }

    private void copyVerticalStrip(ArtisansAtlasState state, int deltaX, int deltaZ, int x, int startZ, int endZ) {
        if (startZ > endZ) {
            for (int z = startZ; z >= endZ; --z) {
                state.method_32370(x, z, state.field_122[x + deltaX + (z + deltaZ) * 128]);
            }
        } else {
            for (int z = startZ; z <= endZ; ++z) {
                state.method_32370(x, z, state.field_122[x + deltaX + (z + deltaZ) * 128]);
            }
        }
    }

    private void updateVerticalStrip(class_1937 world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int startZ, int endZ) {
        double previousHeight = this.getHeight(world, state, deltaX, deltaZ, x, startZ - 1);
        for (int z = startZ; z <= endZ; ++z) {
            previousHeight = this.updateColor(world, state, deltaX, deltaZ, x, z, previousHeight);
        }
    }

    private double updateColor(class_1937 world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int z, double previousHeight) {
        double f;
        double depth;
        double height;
        int sampleSize = 1 << state.field_119;
        int sampleArea = sampleSize * sampleSize;
        int sampleMask = sampleSize - 1;
        boolean hasCeiling = world.method_8597().comp_643();
        int blockX = ((state.getDisplayedCenter().method_10263() >> state.field_119) + deltaX + x - 64) * sampleSize;
        int blockZ = ((state.getDisplayedCenter().method_10260() >> state.field_119) + deltaZ + z - 64) * sampleSize;
        class_2818 chunk = world.method_8497(class_4076.method_18675((int)blockX), class_4076.method_18675((int)blockZ));
        if (chunk.method_12223()) {
            return previousHeight;
        }
        int[] multiset = new int[64];
        int fluidDepth = 0;
        if (hasCeiling) {
            int hash = blockX + blockZ * 231871;
            if (((hash = hash * hash * 31287121 + hash * 11) >> 20 & 1) == 0) {
                int n = class_2246.field_10566.method_9564().method_26205((class_1922)world, (class_2338)class_2338.field_10980).field_16021;
                multiset[n] = multiset[n] + 10;
            } else {
                int n = class_2246.field_10340.method_9564().method_26205((class_1922)world, (class_2338)class_2338.field_10980).field_16021;
                multiset[n] = multiset[n] + 100;
            }
            height = 100.0;
        } else {
            height = 0.0;
            int bottomY = world.method_31607();
            class_2338.class_2339 samplePos = new class_2338.class_2339(0, 0, 0);
            for (int sample = 0; sample < sampleArea; ++sample) {
                class_3620 mapColor;
                int posX = blockX + (sample >> state.field_119);
                int posZ = blockZ + (sample & sampleMask);
                samplePos.method_33097(posX);
                samplePos.method_33099(posZ);
                int sampleY = chunk.method_12005(class_2902.class_2903.field_13202, posX, posZ) + 1;
                if (sampleY <= bottomY + 1) {
                    blockState = class_2246.field_9987.method_9564();
                    mapColor = blockState.method_26205((class_1922)world, (class_2338)samplePos);
                } else {
                    do {
                        samplePos.method_33098(--sampleY);
                    } while ((mapColor = (blockState = chunk.method_8320((class_2338)samplePos)).method_26205((class_1922)world, (class_2338)samplePos)) == class_3620.field_16008 && sampleY > bottomY);
                    if (sampleY > bottomY && !blockState.method_26227().method_15769()) {
                        class_2680 fluidBlockState;
                        int fluidY = sampleY - 1;
                        class_2338.class_2339 fluidPos = samplePos.method_25503();
                        do {
                            fluidPos.method_33098(fluidY--);
                            fluidBlockState = chunk.method_8320((class_2338)fluidPos);
                        } while (fluidY > bottomY && !fluidBlockState.method_26227().method_15769());
                        fluidDepth += sampleY - 1 - fluidY;
                        class_3610 fluidState = blockState.method_26227();
                        blockState = !fluidState.method_15769() && !blockState.method_26206((class_1922)world, (class_2338)samplePos, class_2350.field_11036) ? fluidState.method_15759() : blockState;
                        mapColor = blockState.method_26205((class_1922)world, (class_2338)samplePos);
                    }
                }
                state.method_109((class_1922)world, posX, posZ);
                height += (double)sampleY;
                int n = mapColor.field_16021;
                multiset[n] = multiset[n] + 1;
            }
            height /= (double)sampleArea;
            fluidDepth /= sampleArea;
        }
        int maxCount = 0;
        class_3620 color = class_3620.field_16008;
        for (int i = 0; i < multiset.length; ++i) {
            if (multiset[i] <= maxCount) continue;
            maxCount = multiset[i];
            color = class_3620.method_38479((int)i);
        }
        int odd = (blockX ^ blockZ) / sampleSize & 1;
        class_3620.class_6594 brightness = color == class_3620.field_16019 ? ((depth = (double)fluidDepth * 0.1 + (double)odd * 0.2) < 0.5 ? class_3620.class_6594.field_34761 : (depth > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((f = (height - previousHeight) * 4.0 / (double)(sampleSize + 4) + ((double)odd - 0.5) * 0.4) > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
        state.method_32370(x, z, color.method_38481(brightness));
        return height;
    }

    private double getHeight(class_1937 world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int z) {
        double height;
        int sampleSize = 1 << state.field_119;
        int sampleArea = sampleSize * sampleSize;
        int sampleMask = sampleSize - 1;
        int blockX = ((state.getDisplayedCenter().method_10263() >> state.field_119) + deltaX + x - 64) * sampleSize;
        int blockZ = ((state.getDisplayedCenter().method_10260() >> state.field_119) + deltaZ + z - 64) * sampleSize;
        class_2818 chunk = world.method_8497(class_4076.method_18675((int)blockX), class_4076.method_18675((int)blockZ));
        if (chunk.method_12223()) {
            return 0.0;
        }
        if (world.method_8597().comp_643()) {
            height = 100.0;
        } else {
            height = 0.0;
            int bottomY = world.method_31607();
            for (int sample = 0; sample < sampleArea; ++sample) {
                int posX = blockX + (sample >> state.field_119);
                int posZ = blockZ + (sample & sampleMask);
                class_2338.class_2339 samplePos = new class_2338.class_2339(posX, 0, posZ);
                int sampleY = chunk.method_12005(class_2902.class_2903.field_13202, posX, posZ) + 1;
                if (sampleY > bottomY + 1) {
                    class_2680 blockState;
                    do {
                        samplePos.method_33098(--sampleY);
                    } while ((blockState = chunk.method_8320((class_2338)samplePos)).method_26205((class_1922)world, (class_2338)samplePos) == class_3620.field_16008 && sampleY > bottomY);
                }
                height += (double)sampleY;
            }
            height /= (double)sampleArea;
        }
        return height;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_22 state;
        if (!world.field_9236 && (state = ArtisansAtlasItem.method_8001((class_1799)stack, (class_1937)world)) instanceof ArtisansAtlasState) {
            ArtisansAtlasState atlasState = (ArtisansAtlasState)state;
            atlasState.updateDimension((class_5321<class_1937>)world.method_27983());
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 class_19372;
        if (!context.method_8045().method_8608() && (class_19372 = context.method_8045()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_19372 = context.method_8036();
            if (class_19372 instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)class_19372;
                class_1799 stack = serverPlayerEntity.method_5998(context.method_20287());
                if (serverPlayerEntity.method_5715()) {
                    class_243 hitPos = context.method_17698();
                    class_2338 blockPos = class_2338.method_49637((double)hitPos.method_10216(), (double)hitPos.method_10214(), (double)hitPos.method_10215());
                    Pair<class_2960, class_3449> pair = ArtisansAtlasState.locateAnyStructureAtBlock(serverWorld, blockPos);
                    if (pair != null) {
                        class_2960 structureId = (class_2960)pair.getFirst();
                        if (SpectrumStructureTags.isIn((class_1937)serverWorld, structureId, (class_6862<class_3195>)ConventionalStructureTags.HIDDEN_FROM_LOCATOR_SELECTION)) {
                            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.artisans_atlas.unlocatable"), true);
                        } else {
                            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.artisans_atlas.set_structure").method_10852((class_2561)class_2561.method_43471((String)structureId.method_42093("structure"))), true);
                            ArtisansAtlasItem.createAndSetState(stack, serverWorld, (int)serverPlayerEntity.method_23317(), (int)serverPlayerEntity.method_23321(), (class_3449)pair.getSecond(), (class_2960)pair.getFirst());
                        }
                    }
                    serverPlayerEntity.method_7357().method_7906(stack.method_7909(), 20);
                }
            }
        }
        return class_1269.method_29236((boolean)context.method_8045().method_8608());
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (user instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)user;
                if (user.method_5715()) {
                    ArtisansAtlasItem.createAndSetState(stack, serverWorld, (int)serverPlayerEntity.method_23317(), (int)serverPlayerEntity.method_23321(), null, null);
                }
            }
        }
        return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_22 class_222 = ArtisansAtlasItem.method_8001((class_1799)stack, (class_1937)world);
        if (class_222 instanceof ArtisansAtlasState) {
            ArtisansAtlasState atlasState = (ArtisansAtlasState)class_222;
            class_2960 structureId = atlasState.getTargetId();
            if (structureId == null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.artisans_atlas.empty"));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.artisans_atlas.locates_structure").method_10852((class_2561)class_2561.method_43471((String)structureId.method_42093("structure"))));
            }
        }
    }
}

