/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.item.SplitDamageItem;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.GreatswordItem;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.GreatswordChargingSoundInstance;
import de.dafuqs.spectrum.spells.MoonstoneStrike;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassCrestGreatswordItem
extends GreatswordItem
implements SplitDamageItem,
ExtendedItemBarProvider,
SlotBackgroundEffectProvider,
InkPowered {
    private static final InkCost GROUND_SLAM_COST = new InkCost(InkColors.WHITE, 25L);
    public static final float MAGIC_DAMAGE_SHARE = 0.25f;
    public final int GROUND_SLAM_CHARGE_TICKS = 32;

    public GlassCrestGreatswordItem(class_1832 material, int attackDamage, float attackSpeed, float extraReach, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, extraReach, settings);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.glass_crest_ultra_greatsword.tooltip", (Object[])new Object[]{25}));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.glass_crest_ultra_greatsword.tooltip2"));
        this.addInkPoweredTooltip(tooltip);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (this.getGroundSlamStrength((class_7225.class_7874)world.method_30349(), user.method_5998(hand)) > 0 && InkPowered.tryDrainEnergy(user, GROUND_SLAM_COST)) {
            if (world.field_9236) {
                this.startSoundInstance(user);
            }
            return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (world.field_9236) {
            class_5819 random = world.field_9229;
            for (int i = 0; i < (32 - remainingUseTicks) / 8; ++i) {
                world.method_8406((class_2394)class_2398.field_11213, user.method_23322(1.0), user.method_23318(), user.method_23325(1.0), random.method_43058() * 5.0 - 2.5, random.method_43058() * 1.2, random.method_43058() * 5.0 - 2.5);
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        int groundSlamStrength;
        if (!world.field_9236 && (groundSlamStrength = this.getGroundSlamStrength((class_7225.class_7874)world.method_30349(), stack)) > 0) {
            this.performGroundSlam(world, user.method_19538(), user, groundSlamStrength);
            stack.method_7970(1, user, class_1309.method_56079((class_1268)user.method_6058()));
        }
        return stack;
    }

    public int getGroundSlamStrength(class_7225.class_7874 lookup, class_1799 stack) {
        return SpectrumEnchantmentHelper.getLevel(lookup, (class_5321<class_1887>)class_1893.field_9115, stack);
    }

    public void performGroundSlam(class_1937 world, class_243 pos, class_1309 attacker, float strength) {
        world.method_33596((class_1297)attacker, (class_6880)class_5712.field_28159, class_2338.method_49637((double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350));
        MoonstoneStrike.create(world, (class_1297)attacker, null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), strength, 1.75f);
        world.method_8396(null, attacker.method_24515(), SpectrumSoundEvents.GROUND_SLAM, class_3419.field_15248, 0.7f, 1.0f);
        world.method_8396(null, attacker.method_24515(), SpectrumSoundEvents.DEEP_CRYSTAL_RING, class_3419.field_15248, 0.7f, 1.0f);
        world.method_8396(null, attacker.method_24515(), SpectrumSoundEvents.DEEP_CRYSTAL_RING, class_3419.field_15248, 0.4f, 0.334f);
        if (attacker instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)attacker;
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new GreatswordChargingSoundInstance(user, this.GROUND_SLAM_CHARGE_TICKS));
    }

    @Override
    public SplitDamageItem.DamageComposition getDamageComposition(class_1309 attacker, class_1309 target, class_1799 stack, float damage) {
        SplitDamageItem.DamageComposition composition = new SplitDamageItem.DamageComposition();
        composition.addPlayerOrEntity(attacker, damage * 0.75f);
        composition.add(attacker.method_48923().method_48831(), damage * 0.25f);
        return composition;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        boolean usable = InkPowered.hasAvailableInk(player, GROUND_SLAM_COST);
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return 0xFFFFFF;
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable class_1657 player, class_1799 stack) {
        if (player == null || player.method_5998(player.method_6058()) != stack) {
            return true;
        }
        return !player.method_6115();
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        if (player == null || !player.method_6115()) {
            return ExtendedItemBarProvider.PASS;
        }
        class_1799 activeStack = player.method_5998(player.method_6058());
        if (activeStack != stack) {
            return ExtendedItemBarProvider.PASS;
        }
        int progress = Math.round(class_3532.method_37166((float)0.0f, (float)13.0f, (float)((float)player.method_6048() / 32.0f)));
        return new ExtendedItemBarProvider.BarSignature(2, 13, 13, progress, 1, -1, 2, -16777216);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(GROUND_SLAM_COST.color());
    }
}

